/*
 * Syncany, www.syncany.org
 * Copyright (C) 2011-2016 Philipp C. Heckel <philipp.heckel@gmail.com> 
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.syncany.chunk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/**
 * Implements an empty {@link Transformer}. Used if no compression/encryption
 * is necessary.
 * 
 * @author Philipp C. Heckel <philipp.heckel@gmail.com>
 */
public class NoTransformer extends Transformer {
	/**
	 * The no-transformer does not take any parameters and therefore must
	 * not be initialized. This method does nothing.
	 */
	@Override
	public void init(Map<String, String> settings) throws Exception {
		// Nothing here
	}
	
    @Override
    public OutputStream createOutputStream(OutputStream out) throws IOException {
        if (nextTransformer == null) {
            return out;
        }
        else {
            return nextTransformer.createOutputStream(out);
        }
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        if (nextTransformer == null) {
            return in;
        }
        else {
            return nextTransformer.createInputStream(in);
        }
    }

    @Override
    public String toString() {
        return (nextTransformer == null) ? "None" : "None-"+nextTransformer;
    }    
}