/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GAMMABRIGHTNESS_H
#define GAMMABRIGHTNESS_H


#include <QDBusReply>
#include <QDBusMessage>
#include <QDBusArgument>
#include <QDBusInterface>

#include "clib-syslog.h"
#include "usd_global_define.h"
#include "abstract-brightness.h"

class GammaBrightness : public AbstractBrightness
{
    Q_OBJECT
public:
    GammaBrightness(QObject *parent);

    /**
     * @brief getBrightness
     * @return
     */
    int getBrightness();

    /**
     * @brief setBrightness
     * @param brightness
     * @return
     */
    int setBrightness(int brightness);

    /**
     * @brief connectTheSignal
     * @return
     */
    int connectTheSignal();

    /**
     * @brief isEnable
     * @return
     */
     QString backend();

private:
    QDBusInterface *m_pGmDbusInterface = nullptr;
};

#endif // GAMMABRIGHTNESS_H
