;;;
;;; Per Hammarlund, perham@nada.kth.se, 92 and Oct 94.
;;;
;;; Helpful remarks by Kenichi Handa.
;;;
;;; Version: 0.9

;;; ChangeLog:
;;; * Oct 94 (perham): Removed obsolete function, changed specification
;;;    of coding systems from variable to symbol, changed some
;;;    documentation strings, changed regexps in examples, and removed 
;;;    the ill fated *big5-hku* in favour of *big5*.
;;;

;;;
;;; You will need to add this in your .emacs file:
;;;
;;; (if (boundp 'MULE)
;;;  (progn
;;;    (load "guess-coding")
;;;    (setq insert-file-contents-pre-hook 'coding-from-filename)))
;;;

;;;
;;;  Startup coding systems.
;;;
(defvar *coding-from-filename-list* nil
  "*The user's list of favorite file codings given filename regexps.
To add to or change this list use functions insert-new-coding-from-filename
and remove-coding-from-filename.

The list is made up of dotted pairs of regexps and coding system symbols.
Example: ((\".*gb$\" . *euc-china*) (\".*jis$\" . *junet*))

")

;;;
;;; Recursive insert, hange or remove.
;;;
(defun insert-coding-from-filename-rec (filename-regexp file-coding coding-from-filename-list)
  "This function should not be used by users, use insert-coding-from-filename
or remove-coding-from-filename."
  ;;Is there more in the list?
  (if coding-from-filename-list
      ;;found the right regexp?
      (if (string= filename-regexp
		   (car (car coding-from-filename-list)))
	  ;;remove or change
	  (if file-coding
	      ;;change
	      (cons (cons filename-regexp file-coding)
		    (cdr coding-from-filename-list))
	    ;;remove
	    (cdr coding-from-filename-list))
	;;go further down
	(cons (car coding-from-filename-list)
	      (insert-coding-from-filename-rec filename-regexp
					       file-coding
					       (cdr coding-from-filename-list))))
    ;;at the end
    (if file-coding
	;;create new entry
	(list (cons filename-regexp file-coding))
      ;;report error
      (error "Cannot remove nonexistent coding-to-filename entry!"))))

;;;
;;; User function
;;;
(defun insert-new-coding-from-filename (filename-regexp file-coding)
  "This function inserts or changes an entry in the variable
coding-from-filename-list.

If the string FILENAME-REGEXP matches an entry in the list, then the
coding of that entry is changed to the symbol FILE-CODING.  If there
is no match on FILENAME-REGEXP, a new entry is added at the end of the
list."
  (interactive "sFilename regexp: \nSCoding symbol: ")
  (if (stringp filename-regexp)
      (if (check-coding-system file-coding)
	  (setq *coding-from-filename-list*
		(insert-coding-from-filename-rec filename-regexp
						 file-coding
						 *coding-from-filename-list*)))
    (error "Insert-new-coding-from-filename called with something that
is not a string!")))

;;;
;;; User function
;;;
(defun remove-coding-from-filename (filename-regexp)
  "This function removes a filename-to-coding entry where the filename-regexp
of the entry matches FILENAME-REGEXP."
  (interactive "sFilename regexp: ")
  (if (stringp filename-regexp)
      (setq *coding-from-filename-list*
	    (insert-coding-from-filename-rec filename-regexp nil *coding-from-filename-list*))
    (error "Remove-coding-from-filename called with something that is not string!")))

;;;
;;;
;;;
(defun coding-from-filename (name visit)
  "This function attempts to find a suitable coding systems for a file
based on its filename.  It uses the entries in the list
*coding-from-filename-list* when testing what coding to use.

It will use the last entry in the list that matches NAME, ie the
last entry the user inserted into the list.

The automatic selection of a coding system can be overridden by
initiating the file read with C-u C-x C-f, C-u C-x C-i, or C-u C-x
C-r.

If no suitable coding is found, then it returns the default.
"
  ;;check if the user wants to specify coding himself.
  (if (eq file-coding-system-for-read 'query)
      ;;return what the user types
      (read-coding-system "Coding-system: ")
    ;;try to look at the filename and decide...
    (let ((result-coding nil)
	  filename-regexp
	  coding)
      ;;loop through all of teh list to really capture the last entry matching NAME.
      (dolist (code-entry *coding-from-filename-list*)
	;;Make sure that we are looking at a cons cell, the user may have inserted
	;; something on his own...
	(if (consp code-entry)
	    (progn
	      (setq filename-regexp (car code-entry))
	      (setq coding (cdr code-entry))
	      (if (and (stringp filename-regexp)
		       (check-coding-system coding))
		  (if (string-match filename-regexp name)
		      (setq result-coding coding))
		;;somthing that is not a string coding cons cell has been found...
		(error "Coding-from-extension: Something alien in the *coding-from-filename-list* list!")))
	  ;;Not a cons cell...
	  (error "Coding-from-extension: Something that is not a cons cell in *coding-from-filename-list*!")))
      ;; Now check the result, if nil return default...
      (if result-coding
	  ;;Get the real coding
	  result-coding
	;;Just settle for the default.
	file-coding-system-for-read))))

;;;Sample matches
(insert-new-coding-from-filename ".*gb$"   '*euc-china*)
(insert-new-coding-from-filename ".*jis$"  '*junet*)
(insert-new-coding-from-filename ".*big$"  '*big5*)
(insert-new-coding-from-filename ".*big5$" '*big5*)
