;;; -*- Mode: Emacs-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  File: hanyin-minor-mode.el  (hanyin--> han4-yin1 $A::Rt(B)
;;;  Description: To follow han4-zi4-zi4-yin1 ($A::WVWVRt(B) in minibuffer.
;;;  Environment: Mule (Multi-lingual Gnu-Emacs). (require 'gb2pinyin)
;;;  Author: Dong-Ping Deng  <deng@bnl.gov>
;;;  Date: Tue Nov 24 1992
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  History:
;;;   Created.
;;;   Tue Nov 24 1992  Dong-Ping Deng <deng@bnl.gov>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Motive: I have a hard time to read Chinese classics, in this way,
;;; I can use arrow key to move to one character at a time, the pinyin
;;; also shows up in the echo area.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Acknowledgment:
;;; Some ideas and codes are from quail.el K.Handa <handa@etl.go.jp>
;;; and from linenumbers.el Ajay Shekhawat <ajay@cs.Buffalo.EDU>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;; This program is free software.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; Bugs report:
;;; This is a minor mode, proceed carefully if you change the local key-maps.
;;; 
;;; GNUS users: it's best to invoke it in the *Article* buffer.
;;;             disable it in the *Subject* buffer...
;;; MH users: best invoke it in the *{show-+<folder>}*.
;;; Use with other minor modes other than "Fill" or "Abbrev", invoke
;;;  hanyin-minor-mode first.
;;;
;;; Should you find any bugs, or have any comments, suggestions on the style
;;; and improvement to the codes, please drop a note to <deng@bnl.gov>.
;;; Thanks.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Personal preference: 
;;; (global-set-key "\C-x\\" 'hanyin-minor-mode)
;;; (autoload 'hanyin-minor-mode "hanyin" "$A::Rt(B" t)
;;; (autoload 'gb2pinyin "gb2pinyin" 
;;;           "To find $AF4Rt(B on a Chinese character." t)
;;;
;;; To use x-sb-mouse package, press control and click left button on a $A::WV(B. 
;;; (setq x-mouse-bind-hook
;;;       '(lambda ()
;;;         (x-mouse-define-key "x-mouse-c1-window-click" t
;;;           'default '(lambda ()
;;;                      (x-mouse-set-point)
;;;		      (gb2pinyin)))))
;;; (load-library "~/gnu/xsbmouse/x-sb-mouse")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
(global-set-key "\C-x\\" 'hanyin-minor-mode)
(autoload 'hanyin-minor-mode "hanyin" "$A::Rt(B" t)
(autoload 'gb2pinyin "gb2pinyin" "To find $AF4Rt(B on a Chinese character." t)
;;;

(defvar hanyin-minor-mode-keymap nil 
  "Local key map for hanyin-minor-mode.")

(defvar hanyin-minor-mode nil "Hanyin-minor-mode toggle.")
(defvar hanyin-minor-mode-string nil "Hanyin-minor-mode-string.")

(if hanyin-minor-mode-keymap
    ()
  (setq hanyin-minor-mode-keymap (make-keymap))
  (define-key hanyin-minor-mode-keymap "\C-a"         'beginning-of-line*)
  (define-key hanyin-minor-mode-keymap "\C-cg"        'goto-line*)
  (define-key hanyin-minor-mode-keymap "\C-k"         'kill-line*)
  (define-key hanyin-minor-mode-keymap "\C-m"         'newline*)
  (define-key hanyin-minor-mode-keymap "\C-b"         'backward-char*)
  (define-key hanyin-minor-mode-keymap "\C-w"         'kill-region*)
  (define-key hanyin-minor-mode-keymap "\C-y"         'yank*)
  (define-key hanyin-minor-mode-keymap "\C-x["        'backward-page*)
  (define-key hanyin-minor-mode-keymap "\C-p"         'previous-line*)
  (define-key hanyin-minor-mode-keymap "\eb"          'backward-word*)
  (define-key hanyin-minor-mode-keymap "\e<"          'beginning-of-buffer*)
  (define-key hanyin-minor-mode-keymap "\ev"          'scroll-down*)
  (define-key hanyin-minor-mode-keymap "\ey"          'yank-pop*)
  (define-key hanyin-minor-mode-keymap "\C-v"         'scroll-up*)
  (define-key hanyin-minor-mode-keymap "\C-n"         'next-line*)
  (define-key hanyin-minor-mode-keymap "\C-f"         'forward-char*)
  (define-key hanyin-minor-mode-keymap "\C-x]"        'forward-page*)
  (define-key hanyin-minor-mode-keymap "\e>"          'end-of-buffer*)
  (define-key hanyin-minor-mode-keymap "\C-d"         'delete-char*)
  (define-key hanyin-minor-mode-keymap "\C-@"         'set-mark*)
  (define-key hanyin-minor-mode-keymap "\C-xm"        'set-mark*)
  (define-key hanyin-minor-mode-keymap "\ef"          'forward-word*)           
  );;end

(defun hanyin-minor-mode ()
  "A minor mode to follow $A::WVWVRt(B in the minibuffer.

Commands:
Most cursor movement commands. 

   C-a          beginning-of-line       
   C-cg         goto-line               
   C-k          kill-line               
   C-m          newline                 
   C-b          backward-char           
   C-w          kill-region             
   C-y          yank                    
   C-x [        backward-page           
   C-p          previous-line           
   ESC b        backward-word           
   ESC v        scroll-down             
   ESC y        yank-pop                
   C-v          scroll-up               
   C-n          next-line               
   C-f          forward-char            
   C-x ]        forward-page            
   ESC <        beginning-of-buffer     
   ESC >        end-of-buffer           
   C-d          delete-char             
   C-@          set-mark                
   ESC f        forward-word            

Use \\[hanyin-minor-mode-help] to get help.

  "

  (interactive)
  (cond (hanyin-minor-mode 
	 (use-local-map hanyin-minor-previous-local-map)
	 (setq hanyin-minor-mode nil)
	 (set-buffer-modified-p (buffer-modified-p)))
    (t
     (if (not (assq 'hanyin-minor-mode minor-mode-alist))
	 (setq minor-mode-alist
	       (cons '(hanyin-minor-mode hanyin-minor-mode-string) minor-mode-alist)))
     (mapcar 'make-variable-buffer-local
	     '(hanyin-minor-previous-local-map 
	       hanyin-minor-mode
	       hanyin-minor-keymap
	       hanyin-minor-mode-string))
     (setq hanyin-minor-previous-local-map (current-local-map))
     (setq hanyin-minor-mode-string " $A::Rt(B")
     (setq hanyin-minor-mode t)
     (message (substitute-command-keys "\\[hanyin-minor-mode-help] for help."))
     (use-local-map hanyin-minor-mode-keymap)
     (set-buffer-modified-p (buffer-modified-p)))))

(defun hanyin-minor-mode-help ()
  "To get help for hanyin-minor-mode.
  \\[hanyin-minor-mode-help]."

  (interactive)
  (describe-function 'hanyin-minor-mode))

(defun backward-char* (arg)
  "Same as \\[backward-char], but display $A::Rt(B also."
  (interactive "p")
  (backward-char arg)
  (gb2pinyin))

(defun delete-char* (arg)
  "Same as \\[backward-char], but display $A::Rt(B also."
  (interactive "p")
  (delete-char arg)
  (gb2pinyin))

(defun set-mark* (arg)
  "Same as \\[set-mark-command], but display $A::Rt(B also."
  (interactive "p")
  (set-mark-command nil)
;  (forward-char 1)
;  (backward-char 1)
  (gb2pinyin)
)

(defun backward-page* (arg)
  "Same as \\[backward-page], but display $A::Rt(B also."
  (interactive "p")
  (backward-page arg)
  (gb2pinyin))

(defun previous-line* (arg)
  "Same as \\[previous-line], but display $A::Rt(B also."
  (interactive "p")
  (previous-line arg)
  (gb2pinyin))

(defun backward-word* (arg)
  "Same as \\[backward-word], but display $A::Rt(B also."
  (interactive "p")
  (backward-word arg)
  (gb2pinyin))

(defun beginning-of-line* (arg)
  "Same as \\[beginning-of-line], but display $A::Rt(B also."
  (interactive "P")
  (beginning-of-line arg)
  (gb2pinyin))


(defun beginning-of-buffer* (arg)
  "Same as \\[beginning-of-buffer], but display $A::Rt(B also."
  (interactive "P")
  (beginning-of-buffer arg)
  (gb2pinyin))

(defun scroll-down* (arg)
  "Same as \\[scroll-down], but display $A::Rt(B also."
  (interactive "P")
  (scroll-down arg)
  (gb2pinyin))

(defun scroll-up* (arg)
  "Same as \\[scroll-up], but display $A::Rt(B also."
  (interactive "P")
  (scroll-up arg)
  (gb2pinyin))

(defun next-line* (arg)
  "Same as \\[next-line], but display $A::Rt(B also."
  (interactive "p")
  (next-line arg)
  (gb2pinyin))


(defun forward-char* (arg)
  "Same as \\[forward-char], but display $A::Rt(B also."
  (interactive "p")
  (forward-char arg)
  (gb2pinyin))

(defun forward-page* (arg)
  "Same as \\[forward-page], but display $A::Rt(B also."
  (interactive "p")
  (forward-page arg)
  (gb2pinyin))

(defun end-of-buffer* (arg)
  "Same as \\[end-of-buffer], but display $A::Rt(B also."
  (interactive "P")
  (message (concat " " arg))
  (end-of-buffer arg)
  (gb2pinyin))

(defun forward-word* (arg)
  "Same as \\[forward-word], but display $A::Rt(B also."
  (interactive "p")
  (forward-word arg)
  (gb2pinyin))


(defun newline* (arg)
  "Same as \\[newline], but display $A::Rt(B also."
  (interactive "p")
  (newline arg)
  (gb2pinyin))

(defun delete-blank-lines* (arg)
  "Same as \\[delete-blank-lines], but display $A::Rt(B also."
  (interactive "*" )
  (delete-blank-lines arg)
  (gb2pinyin))

(defun goto-line* (arg)
  "Same as \\[goto-line], but display $A::Rt(B also."
  (interactive "Ngoto? ")
  (goto-line arg)
  (gb2pinyin))

(defun kill-line* (arg)
  "Same as \\[kill-line], but display $A::Rt(B also."
  (interactive "*P")
  (setq this-command 'kill-line)
  (kill-line arg)
  (gb2pinyin))

(defun kill-region* (beg end)
  "Same as \\[kill-region], but display $A::Rt(B also."
  (interactive "*r")
  (setq this-command 'kill-region)
  (kill-region beg end)
  (gb2pinyin))

(defun yank-pop* (arg)
  "Same as \\[yank-pop], but display $A::Rt(B also."
  (interactive "*p")
  (setq this-command 'yank-pop)
  (yank-pop arg)
  (gb2pinyin))

(defun yank* (arg)
  "Same as \\[yank], but display $A::Rt(B also."
  (interactive "*P")
  (setq this-command 'yank)
  (yank arg)
  (gb2pinyin))

;;;; end