(if (not (boundp 'MULE)) nil
  (defvar *nemacs-to-mule-code-alist*
    '((1 . *sjis*) (2 . *junet*) ("SHIFT-JIS" . *sjis*) ("JIS" . *junet*)
      ("sjis" . *sjis*) ("shift jis" . *sjis*) ("jis" . *junet*)))

  (defun nemacs-to-mule-code (code)
    (and code
	 (let ((c (assoc code *nemacs-to-mule-code-alist*)))
	   (if c (cdr c) '*euc-japan*))))
  
  (defvar kanji-fileio-code nil)
  (defvar kanji-display-code nil)
  (defvar kanji-input-code nil)
  (defvar to-kanji-display nil)
  (defvar to-ascii-display nil)
  (defvar to-kanji-fileio nil)
  (defvar to-ascii-fileio nil)
  (defvar to-kanji-process nil)
  (defvar to-ascii-process nil)
  
  (defun define-program-kanji-code (buffer program code)
    (define-program-coding-system buffer program (nemacs-to-mule-code code)))
  (defun define-service-kanji-code (service host code)
    (let ((code (nemacs-to-mule-code code)))
      (define-service-coding-system service host (cons code code))))

  (defun set-default-kanji-fileio-code (code)
    (set-default-file-coding-system (nemacs-to-mule-code code)))
  (defun set-default-kanji-process-code (code)
    (let ((code (nemacs-to-mule-code code)))
      (set-default-process-coding-system code code)))
  
  (defun set-kanji-display-code (code)
    (set-display-coding-system (nemacs-to-mule-code code)))
  (defun set-kanji-expected-code (code)
    (set-file-coding-system (nemacs-to-mule-code code)))
  (defun set-kanji-fileio-code (code)
    (set-file-coding-system (nemacs-to-mule-code code)))
  (defun set-kanji-input-code (code)
    (set-keyboard-coding-system (nemacs-to-mule-code code)))
  (defun set-kanji-process-code (code)
    (let ((code (nemacs-to-mule-code code)))
      (set-current-process-coding-system (cons code code))))
  (defun set-process-kanji-code (proc code)
    (set-process-coding-system proc (nemacs-to-mule-code code)))
  
  (defun defrule (in out)
    (let ((its:*defrule-verbose* nil))
      (its-defrule in out nil nil "roma-kana")
      ))

  (or (fboundp 'line-move)
      (fset 'line-move (symbol-function 'next-line-internal)))
  
  )
