/*
 * make vf which converts ASCII-dvi to BK-dvi
 * mkvfa2bk [-kXX] ryumin-l 10 min10 /.../min10.tfm afm [VFDIR]
 *	min10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"
#include	"jsub.h"
#include	"parseAFM.h"

#define	UNIT	1048576		/* 1 fixpoint real = 2^20 */
#define	LASTCODE	0x257e

/* hard coded data */

int abk_ratio = 1008957;	/* (ASC(1008957)/BK(2^20)) UNIT */
/*unsigned int vfcs = 0xe99fd0f6;*/

/* end of hard coded data */

char *bk1, *bk2;
char *ascfont;
int vfds;
char *vfdir;
FILE *jfm, *afm, *vf;
int lastku;
char shortform;

/* set by readjfm */
extern char header[];
extern char width[];
extern int id, nt, lh, bc, ec, nw, ds;
extern struct jfmfntinfo *jfmfi;

/* set by parseFile */
FontInfo *fi;

CharMetricInfo *curcmi;

main(ac, av)
int ac;
char *av[];
{
    int ac0;
    char name[64];

    if (av[1][0] == '-') {
	shortform = TRUE;
	lastku = atoi(av[1]+2);
	ac0 = 1;
    } else {
	shortform = FALSE;
	lastku = 84;
	ac0 = 0;
    }
    bk1 = av[ac0+1];
    bk2 = av[ac0+2];
    vfds = atoi(bk2)<<20;
    ascfont = av[ac0+3];
    if ((jfm = fopen(av[ac0+4], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[ac0+4]);
	exit(1);
    }
    if (!readjfm(jfm)) {
	fprintf(stderr, "%s is not jfm\n", av[ac0+4]);
	exit(1);
    }
    if ((afm = fopen(av[ac0+5], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[ac0+5]);
	exit(1);
    }
    parseFile(afm, &fi, P_M);
    curcmi = fi->cmi;

    vfdir = (ac > ac0+6) ? av[ac0+6] : "";
    sprintf(name, "%s%s.vf", vfdir, ascfont);
    if ((vf = fopen(name, "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    ascvf();
    fclose(vf);

    exit(0);
}

#define	makejis(k,t)	((k+0x20)*256+t+0x20)

ascvf()
{
    int ku, ten;
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    putuint(vf, FNT_DEF1, 1);
    putuint(vf, 1, 1);
    putuint(vf, 0, 4);
    putuint(vf, abk_ratio, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(bk1), 1);
    putbytes(vf, bk1, strlen(bk1));

    for (ku = 1; ku <= lastku; ku++)
	for (ten = 1; ten <= 94; ten++)
	    vfchar(makejis(ku, ten));

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

vfchar(jis)
int jis;
{
    int pl, n;
    int ct, gl, l;
    byte b[sizeof(int)];

    pl = 3;	/* SET2 jis */
    ct = getctype(jis, jfmfi);
    gl = 0;
    if (jis <= LASTCODE) {
	for (; curcmi->code < jis; curcmi++)
	    ;
	if (curcmi->code == jis) {
	    if (id == JFM_ID)
		l = curcmi->charBBox.llx+curcmi->charBBox.urx;
	    else
		l = -(curcmi->charBBox.lly+curcmi->charBBox.ury);
	    gl = ((l*UNIT)/1000 - jfmfi->ch[ct].tfmw) /2;
	    if (gl != 0) {
		n = inttob(b, -gl, TRUE);
		pl += 1+n;
	    }
	}
    }
    
    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, jis, 4);
    putuint(vf, jfmfi->ch[ct].tfmw, 4);
    if (gl != 0) {
	putuint(vf, RIGHT1+n-1, 1);
	putbytes(vf, b, n);
    }
    putuint(vf, SET2, 1);
    putuint(vf, jis, 2);
}
