#include	<stdio.h>
#include	"defs.h"

byte *rotbm;
int rbm_size;
int rbm_len, rbm_width, rbm_bwid, rbm_height;

init_rotbm()
{
    rbm_size = 128;
    rotbm = (unsigned char *)malloc(rbm_size);
}

#define	BL	8

byte *rbm;
byte remp;
int remb;

rotate(bm, w, bw, h, mirror)
byte *bm;
int w, bw, h;
BOOLEAN mirror;
{
    int bh;
    int i, j;
    int n, b;

    bh = (h+7)>>3;
    rbm_len = w*bh;
    if (rbm_len > rbm_size) {
	rbm_size = rbm_len;
	rotbm = (byte *)realloc(rotbm, rbm_size);
    }
    rbm = rotbm;
    remp = 0;
    remb = 0;
    if (mirror) 
	for (i = 0; i < w; i++) {
	    n = i/8;
	    b = i%8;
	    for (j = 0; j <= h-1; j++)
		cvr(((*(bm+j*bw+n))>>(7-b))&1, 1);
	    cvrend();
	}
    else
	for (i = 0; i < w; i++) {
	    n = i/8;
	    b = i%8;
	    for (j = h-1; j >= 0; --j)
		cvr(((*(bm+j*bw+n))>>(7-b))&1, 1);
	    cvrend();
	}
    rbm_width = h;
    rbm_bwid = bh;
    rbm_height = w;
    if (rbm_len != rbm-rotbm)
	fprintf(stderr, "w %d h %d rbm_len %d diff %d\n",
		w, h, rbm_len, rbm-rotbm);
}

cvr(p, m)
unsigned char p;
int m;
{
    if (remb+m < BL) {
	remb += m;
	remp |= p<<(BL-remb);
    } else {
	remb = remb+m-BL;
	remp |= p>>remb;
	*rbm++ = remp;
	remp = p<<(BL-remb);
    }
}

cvrend()
{
    if (remb > 0) {
	*rbm++ = remp;
	remp = 0;
	remb = 0;
    }
}
