/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1989, 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/names.e,v 2.15 1993/03/24 06:56:52 william Exp $
 */

#define ITEM_DSPED 10
#define ITEM_LEN 30
#define ROW_HEIGHT (defaultFontHeight+1)
#define BUTTON_OK 0
#define BUTTON_SETDIR 1
#define BUTTON_CANCEL 2
#define MAXBUTTONS 3

typedef struct _DspList {
   char			itemstr[MAXPATHLENGTH+1];
   char			pathstr[MAXPATHLENGTH+1];
   int			directory;
   struct _DspList	* next;
} DspList;

extern char	curDomainName[];
extern char	curDomainPath[];
extern char	curDir[];
extern char	curImportDir[];
extern char	curSymDir[];
extern int	doubleClickInterval;
extern int	importFromLibrary;

extern Window	nameBaseWin;
extern Window	nameDspWin;
extern Window	nameScrollWin;
extern int	nameEntries;
extern char	* * nameDspPtr;
extern int	nameFirst;
extern int	nameMarked;
extern struct BBRec	buttonBBox[];
extern int	numButtons;
extern char	buttonStr[][8];

extern int	nameDspH;
extern int	nameDspW;
extern int	nameDspWinH;
extern int	nameDspWinW;

extern int	justClicked;

extern void	ParseSymPath ();
extern void	InitNames ();
extern void	UpdateDirInfo ();
extern void	UpdateSymInfo ();
extern void	CleanUpNames ();

extern void	RedrawNameScrollWin ();
extern void	RedrawDspWindow ();
extern void	RedrawNamePath ();
extern void	RedrawNameBaseWindow ();
extern char	* * MakeNameDspItemArray ();
extern void	NameScrollHandler ();
extern int	NameDspHandler ();
extern int	ControlChar ();

extern int	SelectFileName ();
extern int	SelectFileNameToImport ();
extern int	GetSymbolPath ();
extern int	NameInCurDir ();
extern int	DirInSymPath ();
extern int	SelectDomain ();
extern int	SelectSymDir ();
extern int	SelectFromLibrary ();
extern void	SetCurDir ();
extern void	SetCurImportDir ();
