*-----------------------------------------------------------------------
*     SLZTTL : PLOT TEXT BETWEEN WS-WINDOW AND MAX-DRAWING-REGION
*-----------------------------------------------------------------------
*     Copyright (C) 2000-2022 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE SLZTTL(CSIDE,CTTL,PX,PY,RSIZE,INDEX)

      CHARACTER CTTL*(*),CSIDE*(*)

      LOGICAL   LWIDE,LCHREQ
      CHARACTER CS*1

      EXTERNAL  LCHREQ,LENC


      CS=CSIDE(1:1)

      CALL STQWTR(VXMN1,VXMX1,VYMN1,VYMX1,WXMN1,WXMX1,WYMN1,WYMX1,ITR)
      IF (ITR.EQ.1) THEN
        CALL STQWRC(WXMIN,WXMAX,WYMIN,WYMAX)
      ELSE
        CALL STQWRC(WXMIN,WXMAX,WYMAX,WYMIN)
      END IF

      CALL SZQCLL(CXMIN,CXMAX,CYMIN,CYMAX,0)

      CALL STIWTR(WXMIN,WYMIN,VXMN2,VYMN2)
      CALL STIWTR(WXMAX,WYMAX,VXMX2,VYMX2)

      CALL SGRGET('XPAD',XPAD)
      CALL SGRGET('YPAD',YPAD)
      CALL SGLGET('LWIDE',LWIDE)

      CALL SZSCLL(VXMN2,VXMX2,VYMN2,VYMX2,0)

      NCHAR=LENC(CTTL)
      NLINE=1
      TLWX=RSIZE*(XPAD+NCHAR)
      TLWY=RSIZE*(YPAD+NLINE)

      IF (LWIDE) THEN
        VXMIN=VXMN2
        VXMAX=VXMX2
      ELSE
        VXMIN=VXMN1
        VXMAX=VXMX1
      END IF
      IF (LCHREQ(CS,'T')) THEN
        VYMIN=VYMX1
        VYMAX=VYMX2
      ELSE IF (LCHREQ(CS,'B')) THEN
        VYMIN=VYMN2
        VYMAX=VYMN1
      ELSE
        CALL MSGDMP('E','SLZTTL','INVALID SIDE PARAMETER.')
      END IF

      XCENT=(VXMIN+VXMAX)/2
      YCENT=(VYMIN+VYMAX)/2
      DWX=((VXMAX-VXMIN)-TLWX)/2
      DWY=((VYMAX-VYMIN)-TLWY)/2

      IF (DWX.LT.0) THEN
        CALL MSGDMP('W','SLZTTL','SPACE FOR TITLE IS NOT ENOUGH.')
        CALL MSGDMP('M','-CNT.-','PX = 0.0 IS ASSUMED.')
        DWX=0
      END IF
      IF (DWY.LT.0) THEN
        CALL MSGDMP('W','SLZTTL','SPACE FOR TITLE IS NOT ENOUGH.')
        CALL MSGDMP('M','-CNT.-','PY = 0.0 IS ASSUMED.')
        DWY=0
      END IF

      XTL=XCENT+DWX*PX
      YTL=YCENT+DWY*PY
      CALL SGTXZR(XTL,YTL,CTTL,RSIZE,0,0,INDEX)

      CALL SZSCLL(CXMIN,CXMAX,CYMIN,CYMAX,0)

      END
