!
!= ϰϤι«
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gtvarlimit.f90,v 1.8 2006/06/15 14:46:08 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060619 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼󡢴ؿ gtdata_generic  gtdata_generic#Limit
! Ȥ󶡤ޤ

subroutine GTVarLimit_iiii(var, dimord, start, count, stride, err)
  !
  !== ϰϤι« (ͤǻ)
  !
  ! ѿ *var* ϰϤ«ޤ
  ! Limit ƤӽФǤ Slice ǤϰϤγϰϤ
  ! ǤʤʤޤˤꡢѿΤǤϤʤ
  ! Slice_Next ֥롼ѤǤ褦ˤʤޤ
  !
  ! ˡϡѿ *var*  *dimord* ܤμ *start*,
  ! ʻ *count* ֳ *stride* ˸ꤷޤ
  ! ΤȤǤϡ饤1ʻҤ *start* ܤγʻҤ
  ! ؼ뤳Ȥˤʤꡢ饤Ǥγʻҿ *count* Ĥ
  ! ۤ뤳ȤǤʤʤꡢ饤Ǵְʤꤹ
  ! *stride* ĤȤλؼ뤳Ȥˤʤޤ
  !
  ! 顼硢å
  ! ƥץ϶λޤ*err* ͿƤˤ
  ! ΰ .true. ֤ꡢץϽλޤ
  !
  ! *Limit*  2 ĤΥ֥롼̾Ǥꡢ
  ! ¾ˤ {gtool4 netCDF }[link:../xref.htm#label-6] 
  ! 5.4 ޵ˡפѤƻꤹ뤳ȤǽǤ
  ! Υ֥롼򻲾ȤƤ
  !
  use gtdata_types, only: GT_VARIABLE
  use gt_map, only: map_lookup, gt_dimmap, dimrange, map_set
  use dc_error, only: dc_noerr, nf_einval, storeerror
  use dc_trace, only: beginsub, endsub, DbgMessage
  implicit none
  type(GT_VARIABLE), intent(inout):: var
  integer, intent(in)             :: dimord
  integer, intent(in) , optional  :: start, count, stride
  logical, intent(out), optional  :: err
  type(gt_dimmap), allocatable:: map(:)
  integer:: iolo, iohi, uilo, uihi, lowerlim, upperlim, dimlo, dimhi
  integer:: ndims, stat

  stat = nf_einval
  call beginsub('GTVarLimit_iiii', &
    & 'var%d-dim%d start=%d count=%d stride=%d', &
    & i=(/var%mapid, dimord, start, count, stride/))
  ! 顼å
  if (dimord < 1) then
    print *, "dimord =", dimord, " < 1"
    goto 999
  endif
  if (stride == 0) then
    print *, "stride == 0"
    goto 999
  endif
  call map_lookup(var, ndims=ndims)
  if (ndims <= 0) then
    print *, "ndims =", ndims, " <= 0"
    goto 999
  endif
  if (dimord > ndims) then
    print *, "dimrod =", dimord, " > ndims =", ndims
    goto 999
  endif
  if (allocated(map)) then
    deallocate(map)
  end if
  allocate(map(ndims))
  call map_lookup(var, map=map)
  ! (/lowerlim, upperlim/) ʻҤϰ (߽)
  lowerlim = min(start, start + (count - 1) * stride)
  upperlim = max(start, start + (count - 1) * stride)
  call dimrange(var, dimord, dimlo, dimhi)
  if (lowerlim < dimlo) then
    print *, "lowerlim = ", lowerlim, " < dimlo =", dimlo
    goto 999
  endif
  if (upperlim > dimhi) then
    print *, "upperlim = ", upperlim, " < dimhi =", dimhi
    goto 999
  endif

  call DbgMessage('@ lowerlim=%d upperlim=%d', i=(/lowerlim, upperlim/))

  ! ϰϤʻֹѤƤ
  uilo = map(dimord)%start
  iolo = 1 + map(dimord)%step * (uilo - 1) + map(dimord)%offset
  uihi = map(dimord)%start + (map(dimord)%count - 1) * map(dimord)%stride
  iohi = 1 + map(dimord)%step * (uihi - 1) + map(dimord)%offset

  call DbgMessage('@ userindex=%d %d, internal=%d %d', &
    & i=(/uilo, uihi, iolo, iohi/))
  call DbgMessage('@ DbgMessage offset %d -> %d step=%d', &
    & i=(/map(dimord)%offset, (start-1), stride/))

  ! ¤ݤoffset ѤХ桼ʻֹΰ̣Ѥ
  map(dimord)%offset = start - 1
  map(dimord)%allcount = count
  map(dimord)%step = stride

  ! ϰϤʻֹ椫桼ʻֹ᤹
  uilo = 1 + (iolo - 1 - map(dimord)%offset) / map(dimord)%step
  uihi = 1 + (iohi - 1 - map(dimord)%offset) / map(dimord)%step
  call DbgMessage('@ userindex=%d %d', i=(/uilo, uihi/))

  ! 줾 [1 .. allcount] ˤʤФʤʤ
  uilo = max(1, min(map(dimord)%allcount, uilo))
  uihi = max(1, min(map(dimord)%allcount, uihi))

  call DbgMessage('@ userindex=%d %d orig_stride=%d', &
    & i=(/uilo, uihi, map(dimord)%stride/))

  ! Υȥ饤ɤ̵뤷˸ꤹ
  map(dimord)%stride = max(1, abs(map(dimord)%stride))
  map(dimord)%start = min(uilo, uihi)
  map(dimord)%count = 1 + abs(uihi - uilo) / map(dimord)%stride

  call map_set(var, map, stat)
  if (stat /= 0) call DbgMessage("map_set fail")

999 continue
  call storeerror(stat, 'GTVarLimit_iiii', err)
  call endsub('GTVarLimit_iiii')
end subroutine GTVarLimit_iiii

! ѿ var  string ˤޥåԤ
! string ϥޤǶڤ줿ѴǤ롣
! ѴΰȼѴΤɤ餫Ǥ롣
! ΰϱѿǻϤޤΤǡ<dim>=<lower>, <dim>=<lower>:<upper>,
!   <dim>=<lower>:<upper>:<stride> Τ褦ʷǤ롣
!   ǡdim ϼֹޤϼ̾Ǥꡢ<lower>, <upper>
!    ^ ֤ɸ¨ͤޤϳʻֹǤ롣
!   <stride> ϳʻҿǤ롣
! (̤) Ѵ = ǻϤޤΤǡ
!   IGN:<dim>=<pos>
! η֤Ȥ롣

subroutine GTVarLimit(var, string, err)
  !
  !== ϰϤι« (ʸǻ)
  !
  ! ѿ *var* ϰϤ«ޤ
  ! *Limit*  2 ĤΥ֥롼̾Ǥꡢ
  ! ̤λˡ⤢ޤޤϾ嵭Υ֥롼򻲾ȤƤ
  !
  ! ˡϡ*string* 
  ! {gtool4 netCDF }[link:../xref.htm#label-6] 
  ! 5.4 ޵ˡפ˽Ҥ٤ϰϻɽѤޤ
  ! ʲ˵󤲤ޤ
  !
  !     <dim>=<lower>
  !
  !     <dim>=<lower>:<upper>
  !
  !     <dim>=<lower>:<upper>:<stride>
  !
  ! ǡ<tt><dim></tt> ϼֹޤϼ̾Ǥꡢ
  ! <tt><lower></tt>, <tt><upper></tt>
  ! Ϻɸͤޤ "<tt>^</tt>" ֤ʻֹǤ
  ! <tt><stride></tt> ϳʻҿǤ
  !
  ! 顼硢å
  ! ƥץ϶λޤ*err* ͿƤˤ
  ! ΰ .true. ֤ꡢץϽλޤ
  !
  use gtdata_types, only: GT_VARIABLE
  use dc_trace, only: beginsub, endsub
  use dc_url, only: gt_comma
  use gt_map, only: gtvar_dump
  type(GT_VARIABLE),  intent(inout):: var
  character(len = *), intent(in)   :: string
  logical, intent(out), optional   :: err
  integer:: is, ie
continue
  call beginsub('GTVarLimit', 'var=%d lim=<%c>', i=(/var%mapid/), c1=trim(string))
  call gtvar_dump(var)
  ! ޤǶڤäƲ
  is = 1
  do
    ie = index(string(is: ), gt_comma)
    if (ie == 0) exit
    call limit_one(string(is: is+ie-2))
    is = is + ie
    if (is > len(string)) exit
  enddo
  call limit_one(string(is: ))
  if (present(err)) err = .false.
  call endsub('GTVarLimit')
  return
contains

  subroutine limit_one(string)
    use dc_url,         only: gt_equal
    use dc_string,      only: strieq, stoi
    use gtdata_generic, only: del_dim, dimname_to_dimord
    use gtdata_generic, only: del_dim, dimname_to_dimord, limit
    character(len = *), intent(in):: string
    integer:: equal, dimord
    integer:: start, count, stride, strhead
    logical:: myerr

    if (string == '') return

    strhead = 4
    if (len(string) < 4) strhead = len(string)

    if (strieq(string(1:strhead), "IGN:")) then
      ! ÷ ign:<dim> ޤ ign:<dim>=<start>
      equal = index(string, gt_equal)
      if (equal == 0) then
        start = 1
      else
        start = stoi(string(equal+1: ), default=1)
      endif
      dimord = dimname_to_dimord(var, string(5: equal-1))
      call limit(var, dimord, start, 1, 1, err)
      call del_dim(var, dimord, myerr)
      return
    endif

    ! 귿 <dim>=<start>:<finish>:<stride>
    ! ޤϼХäƤ <start>:<count>:<stride> ˤʤäƤ
    !
    equal = index(string, gt_equal)
    if (equal == 0) return
    dimord = dimname_to_dimord(var, string(1: equal-1))
    if (dimord <= 0) return
    !
    call region_spec(dimord, string(equal+1: ), start, count, stride)
    call limit(var, dimord, start, count, stride, err)
  end subroutine limit_one

  !
  ! ϰϻ = ΤȤ : Ƕڤäƥޥåפˤ
  !
  subroutine region_spec(dimord, string, start, count, stride)
    use dc_types, only: token
    use dc_string, only: index_ofs, stoi
    use dc_url, only: gt_circumflex, gt_colon
    use gt_map, only: dimrange
    integer, intent(in):: dimord
    integer, intent(out):: start, count, stride
    character(len = *), intent(in):: string
    integer:: colon, prev_colon, finish, dimlo, dimhi
    character(len = token):: val(3)
  continue
    colon = index(string, gt_colon)
    if (colon == 0) then
      ! 󤬤ʤϾ岼üƱ
      val(1) = string(1: )
      val(2) = val(1)
      val(3) = ""
    else
      val(1) = string(1: colon - 1)
      prev_colon = colon
      colon = index_ofs(string, colon + 1, gt_colon)
      if (colon > 0) then
        val(2) = string(prev_colon + 1: colon - 1)
        val(3) = string(colon + 1: )
      else
        val(2) = string(prev_colon + 1: )
        val(3) = ""
      endif
    endif
    if (val(3) == "") val(3) = "^1"

    if (val(1)(1:1) == gt_circumflex) then
      start = stoi(val(1)(2: ))
    else if (val(1) == val(2)) then
      start = nint(value_to_index(dimord, val(1)))
    else
      start = floor(value_to_index(dimord, val(1)))
    endif
    if (val(2) == val(1)) then
      finish = start
    else if (val(2)(1:1) == gt_circumflex) then
      finish = stoi(val(2)(2: ))
    else
      finish = ceiling(value_to_index(dimord, val(2)))
    endif

    call dimrange(var, dimord, dimlo, dimhi)
    start = min(max(dimlo, start), dimhi)
    finish = min(max(dimlo, finish), dimhi)
    count = abs(finish - start) + 1

    if (val(3)(1:1) == gt_circumflex) then
      stride = stoi(val(3)(2: ))
    else
      stride = stoi(val(3))
    endif
    stride = sign(stride, finish - start)
  end subroutine region_spec

  real function value_to_index(dimord, value) result(result)
    !
    ! GTVarLimit ΰ *var* ˳Ǽѿμ *dimord*
    ! ˳ǼǡΤ, *value* Ǽ
    ! ʻֹͤˤ֤ޤ.
    !
    ! 㤨м˰ʲΥǡǼƤȤޤ.
    !
    !     0.05  0.1  0.15  0.20  0.25  0.30
    !
    ! ξ, *value*  0.15 Ϳͤ 3. Ȥʤޤ.
    ! ޤ *value*  0.225 Ϳͤ 4.5 Ȥʤޤ.
    !
    !
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get, open, close
    use dc_string, only: stod
    use dc_trace, only: beginsub, endsub, DbgMessage
    integer, intent(in):: dimord
    character(len = *), intent(in):: value
    type(GT_VARIABLE):: axisvar
    real, pointer:: axisval(:) => null()
    real:: val
    integer:: i
  continue

    call beginsub('value_to_index', 'var=%d dimord=%d value=%c', &
      & i=(/var%mapid, dimord/), c1=trim(value))

    call Open(axisvar, var, dimord, count_compact=.true.)
    nullify(axisval)
    call Get(axisvar, axisval)
    call Close(axisvar)
    if (.not. associated(axisval)) then
      result = -1.0
      return
    else if (size(axisval) < 2) then
      result = 1.0
      goto 900
    endif

    val = stod(value)

    ! call DbgMessage('value=%f axis=(/%*r/)', r=(/val, axisval(:)/), &
    !    & n=(/size(axisval)/))

    do, i = 1, size(axisval) - 1
      if (axisval(i + 1) == axisval(i)) then
        result = real(i) + 0.5
        goto 900
      endif
      result = i + (val - axisval(i)) / (axisval(i + 1) - axisval(i))
      if (result <= (i + 1)) goto 900
    enddo

900 continue
    call endsub('value_to_index', '(%c) = %r', &
      & c1=trim(value), r=(/result/))
    deallocate(axisval)
  end function value_to_index

end subroutine GTVarLimit
