--- src/cggev.f	Thu Dec  5 19:51:34 2002
+++ debian/updates/src/cggev.f	Wed Dec  4 15:23:42 2002
@@ -5,6 +5,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVL, JOBVR
@@ -113,10 +114,9 @@
 *          The dimension of the array WORK.  LWORK >= max(1,2*N).
 *          For good performance, LWORK must generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  RWORK   (workspace/output) REAL array, dimension (8*N)
 *
@@ -133,6 +133,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
       COMPLEX            CZERO, CONE
@@ -140,7 +142,7 @@
      $                   CONE = ( 1.0E0, 0.0E0 ) )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            ILASCL, ILBSCL, ILV, ILVL, ILVR, LQUERY
+      LOGICAL            ILASCL, ILBSCL, ILV, ILVL, ILVR
       CHARACTER          CHTEMP
       INTEGER            ICOLS, IERR, IHI, IJOBVL, IJOBVR, ILEFT, ILO,
      $                   IN, IRIGHT, IROWS, IRWRK, ITAU, IWRK, JC, JR,
@@ -202,7 +204,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       IF( IJOBVL.LE.0 ) THEN
          INFO = -1
       ELSE IF( IJOBVR.LE.0 ) THEN
@@ -228,25 +229,21 @@
 *       computed assuming ILO = 1 and IHI = N, the worst case.)
 *
       LWKMIN = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          LWKOPT = N + N*ILAENV( 1, 'CGEQRF', ' ', N, 1, N, 0 )
          LWKMIN = MAX( 1, 2*N )
          WORK( 1 ) = LWKOPT
+         IF( LWORK.LT.LWKMIN .AND. LWORK.NE.LQUERV )
+     $      INFO = -15
       END IF
 *
-      IF( LWORK.LT.LWKMIN .AND. .NOT.LQUERY )
-     $   INFO = -15
+*     Quick returns
 *
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGGEV ', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
-      WORK( 1 ) = LWKOPT
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 )
      $   RETURN
 *
