--- src/dgges.f	Thu Dec  5 19:51:35 2002
+++ debian/updates/src/dgges.f	Wed Dec  4 15:23:42 2002
@@ -6,6 +6,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVSL, JOBVSR, SORT
@@ -158,10 +159,9 @@
 *  LWORK   (input) INTEGER
 *          The dimension of the array WORK.  LWORK >= 8*N+16.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  BWORK   (workspace) LOGICAL array, dimension (N)
 *          Not referenced if SORT = 'N'.
@@ -184,12 +184,14 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       DOUBLE PRECISION   ZERO, ONE
       PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
 *     ..
 *     .. Local Scalars ..
       LOGICAL            CURSL, ILASCL, ILBSCL, ILVSL, ILVSR, LASTSL,
-     $                   LQUERY, LST2SL, WANTST
+     $                   LST2SL, WANTST
       INTEGER            I, ICOLS, IERR, IHI, IJOBVL, IJOBVR, ILEFT,
      $                   ILO, IP, IRIGHT, IROWS, ITAU, IWRK, MAXWRK,
      $                   MINWRK
@@ -245,7 +247,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       IF( IJOBVL.LE.0 ) THEN
          INFO = -1
       ELSE IF( IJOBVR.LE.0 ) THEN
@@ -272,7 +273,7 @@
 *       following subroutine, as returned by ILAENV.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MINWRK = 7*( N+1 ) + 16
          MAXWRK = 7*( N+1 ) + N*ILAENV( 1, 'DGEQRF', ' ', N, 1, N, 0 ) +
      $            16
@@ -281,19 +282,18 @@
      $               ILAENV( 1, 'DORGQR', ' ', N, 1, N, -1 ) )
          END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -19
       END IF
 *
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
-     $   INFO = -19
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'DGGES ', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV )
+     $   RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
