--- src/cgeesx.f	Thu Dec  5 20:18:05 2002
+++ debian/updates/src/cgeesx.f	Wed Dec  4 15:23:42 2002
@@ -6,6 +6,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Do WS calculations if LWORK = -1 (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVS, SENSE, SORT
@@ -119,6 +120,10 @@
 *          this routine.  Note that 2*SDIM*(N-SDIM) <= N*N/2.
 *          For good performance, LWORK must generally be larger.
 *
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
+*
 *  RWORK   (workspace) REAL array, dimension (N)
 *
 *  BWORK   (workspace) LOGICAL array, dimension (N)
@@ -144,6 +149,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
 *     ..
@@ -211,7 +218,7 @@
 *       in the code.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = N + N*ILAENV( 1, 'CGEHRD', ' ', N, 1, N, 0 )
          MINWRK = MAX( 1, 2*N )
          IF( .NOT.WANTVS ) THEN
@@ -229,18 +236,24 @@
             HSWORK = MAX( K*( K+2 ), 2*N )
             MAXWRK = MAX( MAXWRK, HSWORK, 1 )
          END IF
+*
+*        Estimate the workspace needed by CTRSEN.
+*
+         IF( WANTST ) THEN
+            MAXWRK = MAX( MAXWRK, (N*N+1)/2 )
+         END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     &      INFO = -15
       END IF
-      IF( LWORK.LT.MINWRK ) THEN
-         INFO = -15
-      END IF
+*
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGEESX', -INFO )
          RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
