--- src/zgelsd.f	Thu Dec  5 19:51:39 2002
+++ debian/updates/src/zgelsd.f	Wed Dec  4 15:23:42 2002
@@ -4,7 +4,8 @@
 *  -- LAPACK driver routine (version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -62,9 +63,10 @@
 *          The number of right hand sides, i.e., the number of columns
 *          of the matrices B and X. NRHS >= 0.
 *
-*  A       (input) COMPLEX*16 array, dimension (LDA,N)
+*  A       (input/output) COMPLEX*16 array, dimension (LDA,N)
 *          On entry, the M-by-N matrix A.
-*          On exit, A has been destroyed.
+*          On exit, the first min(m,n) rows of A are overwritten with
+*          its right singular vectors, stored rowwise.
 *
 *  LDA     (input) INTEGER
 *          The leading dimension of the array A. LDA >= max(1,M).
@@ -96,31 +98,24 @@
 *          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
 *
 *  LWORK   (input) INTEGER
-*          The dimension of the array WORK. LWORK must be at least 1.
+*          The dimension of the array WORK. LWORK >= 1.
 *          The exact minimum amount of workspace needed depends on M,
-*          N and NRHS. As long as LWORK is at least
-*              2 * N + N * NRHS
-*          if M is greater than or equal to N or
-*              2 * M + M * NRHS
-*          if M is less than N, the code will execute correctly.
+*          N and NRHS.
+*          If M >= N, LWORK >= 2*N + N*NRHS.
+*          If M < N, LWORK >= 2*M + M*NRHS.
 *          For good performance, LWORK should generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
-*
-*  RWORK   (workspace) DOUBLE PRECISION array, dimension at least
-*             10*N + 2*N*SMLSIZ + 8*N*NLVL + 3*SMLSIZ*NRHS +
-*             (SMLSIZ+1)**2
-*          if M is greater than or equal to N or
-*             10*M + 2*M*SMLSIZ + 8*M*NLVL + 3*SMLSIZ*NRHS +
-*             (SMLSIZ+1)**2
-*          if M is less than N, the code will execute correctly.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
+*
+*  RWORK   (workspace) DOUBLE PRECISION array, dimension (LRWORK)
+*          If M >= N, LRWORK >= 8*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS.
+*          If M < N, LRWORK >= 8*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS.
 *          SMLSIZ is returned by ILAENV and is equal to the maximum
 *          size of the subproblems at the bottom of the computation
 *          tree (usually about 25), and
-*             NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )
+*              NLVL = INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1
 *
 *  IWORK   (workspace) INTEGER array, dimension (LIWORK)
 *          LIWORK >= 3 * MINMN * NLVL + 11 * MINMN,
@@ -144,13 +139,14 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       DOUBLE PRECISION   ZERO, ONE
       PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
       COMPLEX*16         CZERO
       PARAMETER          ( CZERO = ( 0.0D+0, 0.0D+0 ) )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            LQUERY
       INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
      $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
      $                   MNTHR, NRWORK, NWORK, SMLSIZ
@@ -177,7 +173,6 @@
       MINMN = MIN( M, N )
       MAXMN = MAX( M, N )
       MNTHR = ILAENV( 6, 'ZGELSD', ' ', M, N, NRHS, -1 )
-      LQUERY = ( LWORK.EQ.-1 )
       IF( M.LT.0 ) THEN
          INFO = -1
       ELSE IF( N.LT.0 ) THEN
@@ -261,20 +256,18 @@
          END IF
          MINWRK = MIN( MINWRK, MAXWRK )
          WORK( 1 ) = DCMPLX( MAXWRK, 0 )
-         IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY ) THEN
-            INFO = -12
-         END IF
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -12
       END IF
 *
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'ZGELSD', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         GO TO 10
       END IF
-*
-*     Quick return if possible.
-*
+      IF( LWORK.EQ.LQUERV )
+     $   RETURN
       IF( M.EQ.0 .OR. N.EQ.0 ) THEN
          RANK = 0
          RETURN
