package cuda

/*
 THIS FILE IS AUTO-GENERATED BY CUDA2GO.
 EDITING IS FUTILE.
*/

import (
	"github.com/mumax/3/cuda/cu"
	"github.com/mumax/3/timer"
	"sync"
	"unsafe"
)

// CUDA handle for reducemaxabs kernel
var reducemaxabs_code cu.Function

// Stores the arguments for reducemaxabs kernel invocation
type reducemaxabs_args_t struct {
	arg_src     unsafe.Pointer
	arg_dst     unsafe.Pointer
	arg_initVal float32
	arg_n       int
	argptr      [4]unsafe.Pointer
	sync.Mutex
}

// Stores the arguments for reducemaxabs kernel invocation
var reducemaxabs_args reducemaxabs_args_t

func init() {
	// CUDA driver kernel call wants pointers to arguments, set them up once.
	reducemaxabs_args.argptr[0] = unsafe.Pointer(&reducemaxabs_args.arg_src)
	reducemaxabs_args.argptr[1] = unsafe.Pointer(&reducemaxabs_args.arg_dst)
	reducemaxabs_args.argptr[2] = unsafe.Pointer(&reducemaxabs_args.arg_initVal)
	reducemaxabs_args.argptr[3] = unsafe.Pointer(&reducemaxabs_args.arg_n)
}

// Wrapper for reducemaxabs CUDA kernel, asynchronous.
func k_reducemaxabs_async(src unsafe.Pointer, dst unsafe.Pointer, initVal float32, n int, cfg *config) {
	if Synchronous { // debug
		Sync()
		timer.Start("reducemaxabs")
	}

	reducemaxabs_args.Lock()
	defer reducemaxabs_args.Unlock()

	if reducemaxabs_code == 0 {
		reducemaxabs_code = fatbinLoad(reducemaxabs_map, "reducemaxabs")
	}

	reducemaxabs_args.arg_src = src
	reducemaxabs_args.arg_dst = dst
	reducemaxabs_args.arg_initVal = initVal
	reducemaxabs_args.arg_n = n

	args := reducemaxabs_args.argptr[:]
	cu.LaunchKernel(reducemaxabs_code, cfg.Grid.X, cfg.Grid.Y, cfg.Grid.Z, cfg.Block.X, cfg.Block.Y, cfg.Block.Z, 0, stream0, args)

	if Synchronous { // debug
		Sync()
		timer.Stop("reducemaxabs")
	}
}

// maps compute capability on PTX code for reducemaxabs kernel.
var reducemaxabs_map = map[int]string{0: "",
	50: reducemaxabs_ptx_50,
	52: reducemaxabs_ptx_52,
	53: reducemaxabs_ptx_53,
	60: reducemaxabs_ptx_60,
	61: reducemaxabs_ptx_61,
	62: reducemaxabs_ptx_62,
	70: reducemaxabs_ptx_70,
	72: reducemaxabs_ptx_72,
	75: reducemaxabs_ptx_75,
	80: reducemaxabs_ptx_80,
	86: reducemaxabs_ptx_86,
	87: reducemaxabs_ptx_87,
	89: reducemaxabs_ptx_89,
	90: reducemaxabs_ptx_90}

// reducemaxabs PTX code for various compute capabilities.
const (
	reducemaxabs_ptx_50 = `
.version 8.5
.target sm_50
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_52 = `
.version 8.5
.target sm_52
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_53 = `
.version 8.5
.target sm_53
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_60 = `
.version 8.5
.target sm_60
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_61 = `
.version 8.5
.target sm_61
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_62 = `
.version 8.5
.target sm_62
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_70 = `
.version 8.5
.target sm_70
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_72 = `
.version 8.5
.target sm_72
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_75 = `
.version 8.5
.target sm_75
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_80 = `
.version 8.5
.target sm_80
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_86 = `
.version 8.5
.target sm_86
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_87 = `
.version 8.5
.target sm_87
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_89 = `
.version 8.5
.target sm_89
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
	reducemaxabs_ptx_90 = `
.version 8.5
.target sm_90
.address_size 64

	// .globl	reducemaxabs

.visible .entry reducemaxabs(
	.param .u64 reducemaxabs_param_0,
	.param .u64 reducemaxabs_param_1,
	.param .f32 reducemaxabs_param_2,
	.param .u32 reducemaxabs_param_3
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<39>;
	.reg .b64 	%rd<17>;
	// demoted variable
	.shared .align 4 .b8 _ZZ12reducemaxabsE5sdata[2048];

	ld.param.u64 	%rd8, [reducemaxabs_param_0];
	ld.param.u64 	%rd7, [reducemaxabs_param_1];
	ld.param.f32 	%f50, [reducemaxabs_param_2];
	ld.param.u32 	%r17, [reducemaxabs_param_3];
	cvta.to.global.u64 	%rd1, %rd8;
	mov.u32 	%r38, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r36, %r18, %r38, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r38;
	setp.ge.s32 	%p1, %r36, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r36, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r35, %r24, 3;
	setp.eq.s32 	%p2, %r35, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd9, %r36, 4;
	add.s64 	%rd16, %rd1, %rd9;
	mul.wide.s32 	%rd3, %r4, 4;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd16];
	abs.f32 	%f11, %f10;
	max.f32 	%f50, %f50, %f11;
	add.s32 	%r36, %r36, %r4;
	add.s64 	%rd16, %rd16, %rd3;
	add.s32 	%r35, %r35, -1;
	setp.ne.s32 	%p3, %r35, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd6, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd10, %r36, 4;
	add.s64 	%rd11, %rd1, %rd10;
	ld.global.nc.f32 	%f12, [%rd11];
	abs.f32 	%f13, %f12;
	max.f32 	%f14, %f50, %f13;
	add.s64 	%rd12, %rd11, %rd6;
	ld.global.nc.f32 	%f15, [%rd12];
	abs.f32 	%f16, %f15;
	max.f32 	%f17, %f14, %f16;
	add.s32 	%r25, %r36, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd13, %rd12, %rd6;
	ld.global.nc.f32 	%f18, [%rd13];
	abs.f32 	%f19, %f18;
	max.f32 	%f20, %f17, %f19;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd14, %rd13, %rd6;
	ld.global.nc.f32 	%f21, [%rd14];
	abs.f32 	%f22, %f21;
	max.f32 	%f50, %f20, %f22;
	add.s32 	%r36, %r27, %r4;
	setp.lt.s32 	%p5, %r36, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ12reducemaxabsE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r38, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r38, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	max.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r38, 131;
	mov.u32 	%r38, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	max.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	max.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	max.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	max.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	max.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	max.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ12reducemaxabsE5sdata];
	abs.f32 	%f45, %f44;
	mov.b32 	%r32, %f45;
	cvta.to.global.u64 	%rd15, %rd7;
	atom.global.max.s32 	%r33, [%rd15], %r32;

$L__BB0_15:
	ret;

}

`
)
