Version 0.15.0 has been released on 2021-01-24, 6 months after 0.14.0, bringing
many new features and bugfixes.

As usual, [prebuilt binaries](https://elv.sh/get) are offered for most common
platforms.

# Breaking changes

-   Builtin functions and subnamespaces of `edit:` are now read-only.

-   Introspection for rest arguments has changed:

    -   The rest argument is now contained in the `arg-names` field of a
        closure.

    -   The `rest-arg` field now contains the index of the rest argument,
        instead of the name.

-   The `-source` command now runs in a temporary namespace and can no longer
    affect the local scope of its caller.

-   Key modifiers are no longer case insensitive. For example, `Alt` is still
    recognized but `alt` is not. This makes key modifier parsing consistent with
    key names. See [#1163](https://b.elv.sh/1163).

# Deprecated features

Deprecated features will be removed in 0.16.0.

The following deprecated features trigger a warning whenever the code is parsed
or compiled, even if it is not executed:

-   Using the syntax of temporary assignment (`var=value`) for non-temporary
    assignment is now deprecated. The syntax is still valid for temporary
    assignment. For example, using `foo=bar` as a standalone command is
    deprecated, but using it as part of command, like `foo=bar ls`, is not
    deprecated.

-   The `chr` command is now deprecated. Use `str:from-codepoints` instead.

-   The `ord` command is now deprecated. Use `str:to-codepoints` instead.

-   The `has-prefix` command is now deprecated. Use `str:has-prefix` instead.

-   The `has-suffix` command is now deprecated. Use `str:has-suffix` instead.

-   The `-source` command is now deprecated. Use `eval` instead.

-   The undocumented `esleep` command is now deprecated. Use `sleep` instead.

-   The `eval-symlinks` command is deprecated. Use `path:eval-symlinks` instead.

-   The `path-abs` command is deprecated. Use `path:abs` instead.

-   The `path-base` command is deprecated. Use `path:base` instead.

-   The `path-clean` command is deprecated. Use `path:clean` instead.

-   The `path-dir` command is deprecated. Use `path:dir` instead.

-   The `path-ext` command is deprecated. Use `path:ext` instead.

-   The `-is-dir` command is deprecated. Use `path:is-dir` instead.

The following deprecated features trigger a warning when the code is evaluated:

-   Using `:` in slice indices is deprecated. Use `..` instead.

-   The mechanism of assigning to `$-exports-` in `rc.elv` to export variables
    to the REPL namespace is deprecated. Use `edit:add-vars` instead.

# Notable new features

New features in the language:

-   A new `var` special command can be used to explicitly declare variables, and
    optionally assign them initial values.

-   A new `set` special command can be used to set the values of variables or
    elements.

-   Slice indices can now use `..` for left-closed, right-open ranges, and `..=`
    for closed ranges.

-   Rest variables and rest arguments are no longer restricted to the last
    variable.

-   Variables containing any character can now be assigned and used by quoting
    their name, for example `'name!' = foo; put $'name!'`.

New features in the standard library:

-   A new `eval` command supports evaluating a dynamic piece of code in a
    restricted namespace.

-   A new `sleep` command.

-   A new `path:` module has been introduced for manipulating and testing
    filesystem paths.

-   A new `deprecate` command.

New features in the interactive editor:

-   The new commands `edit:add-var` and `edit:add-vars` provide an API for
    manipulating the REPL's namespace from anywhere.

-   SGR escape sequences written from the prompt callback are now supported.

New features in the main program:

-   When using `-compileonly` to check Elvish sources that contain parse errors,
    Elvish will still try to compile the source code and print out compilation
    errors.

# Notable bugfixes

-   Using large lists that contain `$nil` no longer crashes Elvish.
