/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.opensolaris.os.dtrace.Distribution;
import org.opensolaris.os.dtrace.LocalConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogDistribution
extends Distribution
implements Serializable,
Comparable<LogDistribution> {
    static final long serialVersionUID = -1279719751212721961L;
    static final int ZERO_BUCKET_INDEX = 63;

    private LogDistribution(long[] buckets) {
        super(0L, 2L, buckets);
    }

    public LogDistribution(List<Distribution.Bucket> frequencies) {
        super(frequencies);
        this.initialize();
    }

    @Override
    long[] getBucketRange(int i, int len, long base, long constant) {
        long min = LocalConsumer._quantizeBucket(i);
        long max = LocalConsumer._quantizeBucket(i + 1) - 1L;
        long[] range = new long[]{min, max};
        return range;
    }

    @Override
    long[] getBucketRange(int i, int len) {
        return this.getBucketRange(i, len, 0L, 2L);
    }

    @Override
    public Number getValue() {
        double total = 0.0;
        List<Distribution.Bucket> buckets = this.getBuckets();
        for (Distribution.Bucket bucket : buckets) {
            total += (double)bucket.getFrequency() * (double)bucket.getMin();
        }
        return new Double(total);
    }

    private long getZeroBucketValue() {
        Distribution.Bucket b = this.get(63);
        return b.getFrequency();
    }

    @Override
    public int compareTo(LogDistribution d) {
        int cmp;
        double d2;
        Number v1 = this.getValue();
        Number v2 = d.getValue();
        double d1 = v1.doubleValue();
        int n = d1 < (d2 = v2.doubleValue()) ? -1 : (cmp = d1 > d2 ? 1 : 0);
        if (cmp == 0) {
            long z2;
            long z1 = this.getZeroBucketValue();
            cmp = z1 < (z2 = d.getZeroBucketValue()) ? -1 : (z1 > z2 ? 1 : 0);
        }
        return cmp;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.initialize();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(LogDistribution.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"buckets"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

