!----------------------------------------------------------------------
! COPYRIGHT (c) 2007-2010 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!      2 
!
!  2007/12/28  ݹ
!      2010/12/21  ʿ dc_test Ѥ褦˽
!                  Tau ˡΥƥȤ
!
program au_test_boundary2d

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use au_module
  implicit none

  integer, parameter :: im=8, km=8, nm=2
  real(8), parameter :: ra=2.0D0

  real(8), dimension(nm,0:im) :: ag_a
  real(8), dimension(nm,0:im) :: ag_dadx
  real(8), dimension(nm,0:km) :: au_a
  real(8), dimension(nm)      :: amin

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  amin(:) = (/0.0D0,1.0D0/)

  call MessageNotify('M','au_test_boundary2d',    &
    'au_module 2-dim boundary condition solver tests')

  call au_initial(im,km,ra,(/1,2/))

  ag_a(1,:) = sin(g_R)
  ag_a(2,:) = cos(g_R)
  ag_a(1,:) = g_R
  ag_a(2,:) = g_R**2
  au_a = au_ag(ag_a)

!----- au_BoundaryGrid_D ------
  call au_BoundaryGrid_D(au_a,amin)
  ag_a = ag_au(au_a)

  call AssertEqual(&
    message='Test of au_BoundaryGrid_D',                      &
    answer = amin(:),                                         &
    check = ag_a(:,0),                                        &
    significant_digits = check_digits, ignore_digits = ignore &
    )

!----- au_BoundaryTau_D ------
  call au_BoundaryTau_D(au_a,amin)
  ag_a = ag_au(au_a)

  call AssertEqual(&
    message='Test of au_BoundaryTau_D',                       &
    answer = amin(:),                                         &
    check = ag_a(:,0),                                        &
    significant_digits = check_digits, ignore_digits = ignore &
    )


!----- au_BoundaryGrid_N ------
  call au_BoundaryGrid_N(au_a,amin)
  ag_a = ag_au(au_a)
  ag_dadx = ag_Dr_au(au_ag(ag_a))

  call AssertEqual(&
    message='Test of au_BoundaryGrid_N',                      &
    answer = amin(:),                                         &
    check = ag_dadx(:,0),                                     &
    significant_digits = check_digits, ignore_digits = ignore &
    )

!----- au_BoundaryTau_N ------
  call au_BoundaryTau_N(au_a,amin)
  ag_a = ag_au(au_a)
  ag_dadx = ag_Dr_au(au_ag(ag_a))

  call AssertEqual(&
    message='Test of au_BoundaryTau_N',                       &
    answer = amin(:),                                         &
    check = ag_dadx(:,0),                                     &
    significant_digits = check_digits, ignore_digits = ignore &
    )

  call MessageNotify('M','au_test_boundary_grid2d', &
    'au_module 2-dim boundary condition solver tests succeeded!')

end program au_test_boundary2d
