# 3D Sound Game Demo

Walk around the 3D world with 3D (spatial) sound attached to some objects.

**History:** Initial version of this demo was a first test of using OpenAL with _Castle Game Engine_,
done on 2003-11, attaching sounds to various moving 3D objects.
It was also the first (and the last, for now) program where I used lightmaps
generated by our own genLightMap --- the point was to bake shadows
on the ground texture base_shadowed.png. (since then we switched to using Blender baking when needed.)
This demo was modified many times since then,
to simplify and take advantage of TCastleTransform,
TCastleViewport, editor, TCastleSoundSource and many other CGE features.

Ideas for improvements (TODOs):

- add collisions between rat and tnts and level main scene
- more interesting rat movement track. Maybe use AI from TCastleMoveAttack once done
- more elaborate level (initially, some house and more lamps were planned)
- better rat sound

Using [Castle Game Engine](https://castle-engine.io/).

## Building

Compile by:

- [CGE editor](https://castle-engine.io/editor). Just use menu items _"Compile"_ or _"Compile And Run"_.

- Or use [CGE command-line build tool](https://castle-engine.io/build_tool). Run `castle-engine compile` in this directory.

- Or use [Lazarus](https://www.lazarus-ide.org/). Open in Lazarus `game_3d_sound_standalone.lpi` file and compile / run from Lazarus. Make sure to first register [CGE Lazarus packages](https://castle-engine.io/lazarus).

- Or use [Delphi](https://www.embarcadero.com/products/Delphi). Open in Delphi `game_3d_sound_standalone.dproj` file and compile / run from Delphi. See [CGE and Delphi](https://castle-engine.io/delphi) documentation for details.
