{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector2;
    procedure SetCenter(const Value: TVector2);
    function GetRotation: Single;
    procedure SetRotation(const Value: Single);
    function GetScale: TVector2;
    procedure SetScale(const Value: TVector2);
    function GetTranslation: TVector2;
    procedure SetTranslation(const Value: TVector2);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCenter: TSFVec2f;
    { Internal wrapper for property @code(Center). This wrapper API may change, we advise to access simpler @code(Center) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenter: TSFVec2f read FFdCenter;
    {  }
    property Center: TVector2 read GetCenter write SetCenter;

    strict private FFdRotation: TSFFloat;
    { Internal wrapper for property @code(Rotation). This wrapper API may change, we advise to access simpler @code(Rotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotation: TSFFloat read FFdRotation;
    {  }
    property Rotation: Single read GetRotation write SetRotation;

    strict private FFdScale: TSFVec2f;
    { Internal wrapper for property @code(Scale). This wrapper API may change, we advise to access simpler @code(Scale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScale: TSFVec2f read FFdScale;
    {  }
    property Scale: TVector2 read GetScale write SetScale;

    strict private FFdTranslation: TSFVec2f;
    { Internal wrapper for property @code(Translation). This wrapper API may change, we advise to access simpler @code(Translation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTranslation: TSFVec2f read FFdTranslation;
    {  }
    property Translation: TVector2 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureTransformNode ----------------------------------------------- }

function TTextureTransformNode.GetCenter: TVector2;
begin
  Result := FdCenter.Value;
end;

procedure TTextureTransformNode.SetCenter(const Value: TVector2);
begin
  FdCenter.Send(Value);
end;

function TTextureTransformNode.GetRotation: Single;
begin
  Result := FdRotation.Value;
end;

procedure TTextureTransformNode.SetRotation(const Value: Single);
begin
  FdRotation.Send(Value);
end;

function TTextureTransformNode.GetScale: TVector2;
begin
  Result := FdScale.Value;
end;

procedure TTextureTransformNode.SetScale(const Value: TVector2);
begin
  FdScale.Send(Value);
end;

function TTextureTransformNode.GetTranslation: TVector2;
begin
  Result := FdTranslation.Value;
end;

procedure TTextureTransformNode.SetTranslation(const Value: TVector2);
begin
  FdTranslation.Send(Value);
end;

class function TTextureTransformNode.ClassX3DType: String;
begin
  Result := 'TextureTransform';
end;

procedure TTextureTransformNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec2f.Create(Self, True, 'center', Vector2(0, 0));
   FdCenter.ChangeAlways := chTextureTransform;
  AddField(FFdCenter);

  FFdRotation := TSFFloat.Create(Self, True, 'rotation', 0);
   FdRotation.ChangeAlways := chTextureTransform;
   FdRotation.Angle := true;
  AddField(FFdRotation);

  FFdScale := TSFVec2f.Create(Self, True, 'scale', Vector2(1, 1));
   FdScale.ChangeAlways := chTextureTransform;
  AddField(FFdScale);

  FFdTranslation := TSFVec2f.Create(Self, True, 'translation', Vector2(0, 0));
   FdTranslation.ChangeAlways := chTextureTransform;
  AddField(FFdTranslation);
end;

{$endif read_implementation}
