{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetStatus: Boolean;
    procedure SetStatus(const Value: Boolean);
    function GetNotStatus: Boolean;
    procedure SetNotStatus(const Value: Boolean);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdStatus: TSFBool;
    { Internal wrapper for property @code(Status). This wrapper API may change, we advise to access simpler @code(Status) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStatus: TSFBool read FFdStatus;
    { Stored Boolean value. }
    property Status: Boolean read GetStatus write SetStatus;

    strict private FFdNotStatus: TSFBool;
    { Internal wrapper for property @code(NotStatus). This wrapper API may change, we advise to access simpler @code(NotStatus) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNotStatus: TSFBool read FFdNotStatus;
    { Always the negated value of @link(Status). You can set either @link(Status) or @link(NotStatus), changing one changes also the other to keep them being negated values of each other. Also events (like @link(EventToggle)) change both properties. }
    property NotStatus: Boolean read GetNotStatus write SetNotStatus;

    strict private FEventToggle: TXFAnyEvent;
    { Send any value to this event (the value is ignored) to toggle @link(Status) between @true and @false. }
    public property EventToggle: TXFAnyEvent read FEventToggle;

    strict private FEventSet: TXFAnyEvent;
    { Send any value to this event (the value is ignored) to set @link(Status) to @true. }
    public property EventSet: TXFAnyEvent read FEventSet;

    strict private FEventReset: TXFAnyEvent;
    { Send any value to this event (the value is ignored) to set @link(Status) to @false. }
    public property EventReset: TXFAnyEvent read FEventReset;

    strict private FEventChanged: TSFBoolEvent;
    { Outputs a @true value whenever the @link(Status) changed. }
    public property EventChanged: TSFBoolEvent read FEventChanged;

    strict private FEventOn: TSFBoolEvent;
    { Outputs a @true value whenever the @link(Status) changed to @true. }
    public property EventOn: TSFBoolEvent read FEventOn;

    strict private FEventOff: TSFBoolEvent;
    { Outputs a @true value whenever the @link(Status) changed to @false. }
    public property EventOff: TSFBoolEvent read FEventOff;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    { When the node is disabled, input events are ignored (this includes @link(EventToggle), @link(EventSet), @link(EventReset) but also sending new values to @link(Status) and @link(NotStatus)) and output events (@link(EventOn), @link(EventOff), @link(EventChanged)) are never generated. }
    property Enabled: Boolean read GetEnabled write SetEnabled;

{$endif read_interface}

{$ifdef read_implementation}

{ TTogglerNode ----------------------------------------------- }

function TTogglerNode.GetStatus: Boolean;
begin
  Result := FdStatus.Value;
end;

procedure TTogglerNode.SetStatus(const Value: Boolean);
begin
  FdStatus.Send(Value);
end;

function TTogglerNode.GetNotStatus: Boolean;
begin
  Result := FdNotStatus.Value;
end;

procedure TTogglerNode.SetNotStatus(const Value: Boolean);
begin
  FdNotStatus.Send(Value);
end;

function TTogglerNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TTogglerNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

class function TTogglerNode.ClassX3DType: String;
begin
  Result := 'Toggler';
end;

procedure TTogglerNode.CreateNode;
begin
  inherited;

  FFdStatus := TSFBool.Create(Self, True, 'status', false);
   FdStatus.ChangeAlways := chNone;
  AddField(FFdStatus);

  FFdNotStatus := TSFBool.Create(Self, True, 'notStatus', true);
   FdNotStatus.ChangeAlways := chNone;
  AddField(FFdNotStatus);

  FEventToggle := TXFAnyEvent.Create(Self, 'toggle', true);
  AddEvent(FEventToggle);

  FEventSet := TXFAnyEvent.Create(Self, 'set', true);
  AddEvent(FEventSet);

  FEventReset := TXFAnyEvent.Create(Self, 'reset', true);
  AddEvent(FEventReset);

  FEventChanged := TSFBoolEvent.Create(Self, 'changed', false);
  AddEvent(FEventChanged);

  FEventOn := TSFBoolEvent.Create(Self, 'on', false);
  AddEvent(FEventOn);

  FEventOff := TSFBoolEvent.Create(Self, 'off', false);
  AddEvent(FEventOff);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chNone;
  AddField(FFdEnabled);
end;

{$endif read_implementation}
