{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdGroundAngle: TMFFloat;
    { Internal wrapper for property @code(GroundAngle). This wrapper API may change, we advise to access simpler @code(GroundAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGroundAngle: TMFFloat read FFdGroundAngle;
    {  }
    procedure SetGroundAngle(const Value: array of Single); overload;
    {  }
    procedure SetGroundAngle(const Value: TSingleList); overload;

    strict private FFdGroundColor: TMFColor;
    { Internal wrapper for property @code(GroundColor). This wrapper API may change, we advise to access simpler @code(GroundColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGroundColor: TMFColor read FFdGroundColor;
    {  }
    procedure SetGroundColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetGroundColor(const Value: TVector3List); overload;

    strict private FFdSkyAngle: TMFFloat;
    { Internal wrapper for property @code(SkyAngle). This wrapper API may change, we advise to access simpler @code(SkyAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkyAngle: TMFFloat read FFdSkyAngle;
    {  }
    procedure SetSkyAngle(const Value: array of Single); overload;
    {  }
    procedure SetSkyAngle(const Value: TSingleList); overload;

    strict private FFdSkyColor: TMFColor;
    { Internal wrapper for property @code(SkyColor). This wrapper API may change, we advise to access simpler @code(SkyColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSkyColor: TMFColor read FFdSkyColor;
    {  }
    procedure SetSkyColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetSkyColor(const Value: TVector3List); overload;

    strict private FFdTransparency: TSFFloat;
    { Internal wrapper for property @code(Transparency). This wrapper API may change, we advise to access simpler @code(Transparency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransparency: TSFFloat read FFdTransparency;
    {  }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstract3DBackgroundNode ----------------------------------------------- }

procedure TAbstract3DBackgroundNode.SetGroundAngle(const Value: array of Single);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundAngle(const Value: TSingleList);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundColor(const Value: array of TCastleColorRGB);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundColor(const Value: TVector3List);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyAngle(const Value: array of Single);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyAngle(const Value: TSingleList);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyColor(const Value: array of TCastleColorRGB);
begin
  FdSkyColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyColor(const Value: TVector3List);
begin
  FdSkyColor.Send(Value);
end;

function TAbstract3DBackgroundNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TAbstract3DBackgroundNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TAbstract3DBackgroundNode.ClassX3DType: String;
begin
  Result := 'X3D3DBackgroundNode';
end;

procedure TAbstract3DBackgroundNode.CreateNode;
begin
  inherited;

  FFdGroundAngle := TMFFloat.Create(Self, True, 'groundAngle', []);
   FdGroundAngle.ChangeAlways := chBackground;
   FdGroundAngle.Angle := true;
  AddField(FFdGroundAngle);

  FFdGroundColor := TMFColor.Create(Self, True, 'groundColor', []);
   FdGroundColor.ChangeAlways := chBackground;
  AddField(FFdGroundColor);

  FFdSkyAngle := TMFFloat.Create(Self, True, 'skyAngle', []);
   FdSkyAngle.ChangeAlways := chBackground;
   FdSkyAngle.Angle := true;
  AddField(FFdSkyAngle);

  FFdSkyColor := TMFColor.Create(Self, True, 'skyColor', Vector3(0, 0, 0));
   FdSkyColor.ChangeAlways := chBackground;
  AddField(FFdSkyColor);

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chBackground;
   FdTransparency.MustBeNonnegative := true;
  AddField(FFdTransparency);
end;

{$endif read_implementation}
