// Tres en raya (Multijugador) - Fenix Proyecto 1.0
// Programado por Titonus usando librera net.dll (programada por MaQ)

// Dinmica del juego:
// Gana la partida aquel que consiga formar una lnea horizontal, vertical o diagonal con 3 de sus figuras.
// Las figuras del servidor son circulos y la del cliente rectangulos.

// La dinmica de envo/recepcin de datos consiste en que cada mensaje que enve el emisor (servidor o cliente) 
// ha de ser confirmado de que ha sido recibido por el receptor (servidor o cliente) salvo en el caso de que uno de 
// los dos jugadores desconecte de forma manual, salvo este caso, si un mensaje no es confirmado por el receptor 
// o uno de los dos jugadores no obtiene respuesta del otro al esperar un tiempo, la partida es finalizada.

// *Notas: 
// 1. La direccin IP/Host a la que ha de conectarse el cliente est reflejada en el archivo de texto 'ipservidor.txt'
// 2. Para el correcto funcionamiento es necesario tener abiertos y correctamente configurados los puertos siguientes:
// Por defecto el puerto 33333 (definido en la seccin constantes) y el siguiente a ste, que es el 33334

PROGRAM TRES_EN_RAYA;

import "net"; // Importamos librera "net.dll"

// Tipos de datos a usar para los paquetes UDP
type _IPaddress
int host; // Host o IP de tipo entero
word port; // Puerto de tipo palabra (word)
end;

type _UDPpacket
int channel; // Canal en el que se enva el paquete de tipo entero
byte pointer data; // Informacin a enviar o recibir que es un puntero de tipo byte
int len; // Longitud de tipo entero del paquete
int maxlen; // Longitud mxima de tipo entero del paquete
int status; // Estado del paquete
_IPaddress address; // Direccin (tanto Host/IP como puerto de tipo _IPaddress antes especificado)
end;

CONST
puerto=33333; // Puerto a usar 33333 (por defecto)

GLOBAL
// Variables
_UDPpacket pointer info; // Puntero 'info' de tipo _UDPpacket (El campo data (informacion) a veces contendr informacin sobre el estado del juego o de la casilla (de las 9 que hay, del 7 al 15 son representadas) seleccionada)
_UDPpacket pointer temporal; // Puntero 'temporal' de tipo _UDPpacket para conseguir direccin IP del cliente
int turno; // Contiene informacin sobre estado del juego (0 turno del oponente - 1 turno del jugador - 2 desconexion/error - 3 fin partida (ha ganado uno, dependiendo de a quien le corresponda el turno, esta informacin la enviar el servidor o el cliente) - 4 peticion para jugar - 5 peticion aceptada - 6 'ping' para comprobar que tanto el servidor y cliente siguen disponibles)
int imagen_raton; // Para cargar imagen raton
int fichero_ip; // Variable que maneja el fichero donde se encuentra la direccin IP/Host (usada por el cliente para conectar al servidor)
string ip; // Direccin IP/Host (usada por el cliente para conectar al servidor)
int figuras_tablero[2][2]; // 9 posibles figuras a dibujar en el tablero (1 indica que ya est ocupada la posicin)
int figuras_propias[2][2]; // En este array bidimensional se marcan a 1 slamente las figuras propias
int i,j; // Para bucles for
BEGIN
full_screen=false; // Modo ventana
net_init(); // Iniciamos librera net.dll
graph_mode=mode_16bits; // Modo 16 bits
// Lectura del fichero de texto
fichero_ip=fopen("ipservidor.txt",o_read); // Abrimos archivo de texto para leer direccin IP/Host
ip=fgets(fichero_ip); // Conseguimos IP/Host
fclose(fichero_ip); // Cerramos el archivo
//..
imagen_raton=load_png("raton.png"); // Cargamos imagen del raton
set_title("Tres en raya (Multijugador)"); // Ttulo ventana
say("Tres en raya (Multijugador) iniciado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
say(""); // Mensaje consola
set_mode(m320x240); // Resolucin pantalla
menu(); // Llamamos al proceso menu
END;

PROCESS menu()
PRIVATE
int opcion_elegida=0;// Para el bucle while (0 no se ha elegido opcion, 1 si)
BEGIN
turno=0;
// Reiniciamos las figuras del tablero a 0
for (i=0;i<=2;i++)
	for (j=0;j<=2;j++)
	figuras_tablero[i][j]=0;
	figuras_propias[i][j]=0;
	end
end;
clear_screen(); // Limpiamos la pantalla
drawing_map(0,0); // Cualquier primitiva ser dibujada en el fondo de la pantalla (para as poder eliminarlas con clear_screen)
mouse.graph=0; // Sin grfico el ratn
// Texto para elegir una opcin (Men)
delete_Text(0);
write(0,160,60,4,"Tres en raya (Multijugador)");
write(0,160,100,4,"1. Jugar (Actuar como Servidor)");
write(0,160,120,4,"2. Jugar (Actuar como Cliente)");
write(0,160,140,4,"3. Abandonar el juego");

	while (!opcion_elegida) // Esperamos a que se eliga una opcin	
		if key(_1): opcion_elegida=1;
				delete_text(0);
				net_udp_open(0,puerto); // Abrimos el socket 0 para escucha (cliente) en el puerto 'puerto'
				net_udp_bind(0,1,"localhost",puerto); // "Bindeamos" el socket 0 con el canal 1 en el puerto de escucha
				net_udp_allocpacket(0,4); // Paquete 0 para enviar/recibir de 4 bytes
				info=net_udp_getpacket(0); // Asignamos variable al paquete 0
				info.len=4; // Longitud del paquete (4 bytes)
				say("Actuando como servidor en: localhost:"+puerto+" ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Esperando conexin de un jugador ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				servidor(); // Llamamos al proceso servidor
				end;
		if key(_2): opcion_elegida=1;
				delete_text(0);
				net_udp_open(0,0); // Abrimos el socket 0 para envo (cliente) en el puerto 0
				net_udp_bind(0,1,ip,puerto); // "Bindeamos" el socket 0 con el canal 1 en el puerto de escucha y direccin del servidor "ip"
				net_udp_allocpacket(0,4); // Paquete 0 para enviar/recibir de 4 bytes
				info=net_udp_getpacket(0); // Asignamos variable al paquete 0
				info.len=4; // Longitud del paquete (4 bytes)
				say("Actuando como cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Conectando con: "+ip+":"+puerto+" ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Peticin para jugar enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				cliente(); // Llamamos al proceso servidor
				end;
		if key(_3): net_quit();exit (1,"Salir"); // Cerramos librera y salimos
		end;
	frame;
	end;
END

PROCESS servidor()
PRIVATE
int cliente_conectado=0; // Para bucle while (0 no ha conectado un cliente, 1 si)
int texto; // Para borrar texto en pantalla de turno del oponente
int estado_oponente; // Aqu guardamos la informacin que recibimos del oponente (2 desconexin/error - 3 fin partida - 6 'ping' - 7-15 casilla seleccionada)
int haciendo_ping; // Si est a 1 es que estamos realizando un 'ping' (6)
int seleccionada; // Indica la casilla que hemos podido seleccionar una casilla y se procede a enviar datos (1 a 9) - Se pone a valor 10 para esperar la confirmacin de que se ha recibido el mensaje
int casilla; // De 7 a 15 (para enviarlo en un paquete)
int linea; // Vale 3 si se ha formado una lnea horizontal, vertical o diagonal
int empate; // Vale 1 si ha habido empate
BEGIN
	timer[0]=0; // Contador a 0
	write(0,160,120,4,"Esperando conexin de un jugador ...");
		
		while (!cliente_conectado and !key(_esc)) // Esperamos conexin de algun cliente hasta que se haya conectado alguno o cancelemos pulsando escape
			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(0);end;
			if (timer[0]>100) timer[0]=0;write(0,160,120,4,"Esperando conexin de un jugador ...");end;
			//..
			if (net_udp_recv(0,0)>0) // Llegada de algn paquete
			memcopy(&turno,info.data,4);
			
				if (turno==4) 
				temporal=info;
				net_udp_open(1,0); // Abrimos el socket 1 en el puerto 0 para enviar datos a dicho cliente
				net_udp_bind2(1,1,temporal.address.host,puerto+1); // "Bindeamos" el socket 1 con el canal 1 en el puerto de envio
				say("Peticin para jugar recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				say("Peticin para jugar aceptada, comienza la partida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				cliente_conectado=1;
				turno=5;
				memcopy(info.data,&turno,4);
				net_udp_send(1,1,0); /* Enviamos confirmacin de que la peticin del cliente ha sido aceptada 
				(puede resultar poco preciso no asegurarse de que el cliente recibe este paquete, pero lo hacemos as porque cuando 
				finalizemos y enviemos el movimiento de nuestra primera jugada (y cualquiera) esperamos confirmacin de que lo ha recibido
				en caso negativo la partida se finaliza */
				turno=1; // Es el turno del servidor
				else;
				say("Peticin errnea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				end
			end;
		frame;
		end;
		
		if (cliente_conectado==0) 
		say ("Servidor cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
		net_udp_freepacket(0); // Vaciamos paquete 0
		net_udp_close(0); // Cerramos socket 0 (escucha)
		menu(); // Llamamos al proceso menu();
		return;end
		
		// Comienza la partida
		delete_text(0);
		write(0,160,5,4,"Tres en raya (Servidor)");
		timer[0]=0;timer[1]=0;
		// Dibujando tablero
		draw_line(120,45,120,195);
		draw_line(200,45,200,195);
		draw_line(60,80,260,80);
		draw_line(60,160,260,160);
LOOP
		if (net_udp_recv(0,0)>0) // Llegada de algn paquete
			estado_oponente=0;
			memcopy(&estado_oponente,info.data,4);
				if (estado_oponente==2) 
				say("El cliente ha desconectado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (escucha)
				net_udp_close(1); // Cerramos socket 1 (envio)
				menu(); // Llamamos al proceso menu()
				return;				
				else 
					if (estado_oponente==3) 
					say("Partida finalizada, has perdido ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (escucha)
					net_udp_close(1); // Cerramos socket 1 (envio)
					menu(); // Llamamos al proceso menu()
					return;					
					end;
					if (estado_oponente<0 and estado_oponente>15);
					say("Peticin errnea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					end;
				end
		end;

		if (key(_esc)) // Cancelando partida
		say ("Servidor cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
		turno=2; // Desconexin/error
		memcopy(info.data,&turno,4);
		net_udp_send(1,1,0); // Enviamos desconexin/error (no esperamos que lo haya recibido por ello si el destinatario no la recibe, habra de esperar hasta que l detecte que ya no hay partida)
		net_udp_freepacket(0); // Vaciamos paquete 0
		net_udp_close(0); // Cerramos socket 0 (escucha)
		net_udp_close(1); // Cerramos socket 1 (envio)
		menu(); // Llamamos al proceso menu();
		return;
		end
		
			if (turno==0) // Turno del oponente
			mouse.graph=0;
			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(texto);end;
			if (timer[0]>100) timer[0]=0;texto=write(0,160,225,4,"Turno del oponente");end;
			//..

			// Marcando casilla del oponente, recibiendo datos
			if (estado_oponente>6 and estado_oponente<16) // Se ha recibido una casilla seleccionada por el cliente
			timer[0]=0;timer[1]=0;
			if (texto>0) delete_text(texto);end// Eliminar texto que pueda permanecer en pantalla
			say("Casilla seleccionada por el cliente recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			turno=1;
			memcopy(info.data,&turno,4); // Mandamos confirmacin de que hemos recibido el mensaje (ahora es el turno del servidor)
			net_udp_send(1,1,0);
				switch (estado_oponente)
					case (7):
					figuras_tablero[0][0]=1;draw_rect(65,50,115,75);
					end;
					case (8):
					figuras_tablero[0][1]=1;draw_rect(125,50,195,75);
					end;
					case (9):
					figuras_tablero[0][2]=1;draw_rect(205,50,255,75);
					end;
					case (10):
					figuras_tablero[1][0]=1;draw_rect(65,85,115,155);
					end;
					case (11):
					figuras_tablero[1][1]=1;draw_rect(125,85,195,155);
					end;
					case (12):
					figuras_tablero[1][2]=1;draw_rect(205,85,255,155);
					end;
					case (13):
					figuras_tablero[2][0]=1;draw_rect(65,165,115,190);
					end;
					case (14):
					figuras_tablero[2][1]=1;draw_rect(125,165,195,190);
					end;
					case (15):
					figuras_tablero[2][2]=1;draw_rect(205,165,255,190);
					end;	
				end;
				
				// Comprobacion de si hay un empate
				for (i=0;i<=2;i++)
					for (j=0;j<=2;j++)
					if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
					end;
					if (empate==0) break;end
				end;
				
				if (empate==1) // Hay un empate
				say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (escucha)
				net_udp_close(1); // Cerramos socket 1 (envio)
				menu(); // Llamamos al proceso menu()
				return;
				end;
			end;
			//..
			
			/* Si en 30 segundos no hemos recibido informacin (seal) del oponente es por dos causas:
				1. El oponente se est pensando mucho la jugada :-)
				2. El oponente no tiene conexin o cualquier otro error similar (ha desconectado y no nos ha llegado dicho mensaje)
			Por ello enviamos un 'ping' (6) para saber si an sigue ah, prorrogando el tiempo en caso afirmativo, 
			en caso de no obtener respuesta, se produce una desconexin (finalizacin de la partida).
			*/
			if (timer[1]>3000)
			timer[1]=0;
			haciendo_ping=1;
			estado_oponente=6;
			say("Peticin de ping enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&estado_oponente,4);
			net_udp_send(1,1,0);			
			estado_oponente=0;
			end
			
			if (haciendo_ping)
				if (estado_oponente==6)
				say ("Peticin de ping recibida por el cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				haciendo_ping=0;
				timer[1]=0;
				else
				if (timer[1]>300)
				timer[1]=0;haciendo_ping=0;
				say("El cliente no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (escucha)
				net_udp_close(1); // Cerramos socket 1 (envio)
				menu(); // Llamamos al proceso menu()
				return;		
				end;
				end;
			end;
			//..			
			end
			
			if (turno==1) // Nuestro turno
			mouse.graph=imagen_raton; // Fijamos la imagen del raton
			
			// Seleccionando una casilla y envo, recepcin de datos
			if (seleccionada==0 and mouse.left and mouse.x>=60 and mouse.x<=260 and mouse.y>=45 and mouse.y<=195)
				if (mouse.x<120)
					if (mouse.y<80 and !figuras_tablero[0][0])
					figuras_tablero[0][0]=1;figuras_propias[0][0]=1;seleccionada=1;draw_circle(90,55,15);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][0])
					figuras_tablero[1][0]=1;figuras_propias[1][0]=1;seleccionada=4;draw_circle(90,120,15);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][0])
					figuras_tablero[2][0]=1;figuras_propias[2][0]=1;seleccionada=7;draw_circle(90,180,15);end					
				end;
				if (mouse.x>120 and mouse.x<200)
					if (mouse.y<80 and !figuras_tablero[0][1])
					figuras_tablero[0][1]=1;figuras_propias[0][1]=1;seleccionada=2;draw_circle(160,55,15);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][1])
					figuras_tablero[1][1]=1;figuras_propias[1][1]=1;seleccionada=5;draw_circle(160,120,15);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][1])
					figuras_tablero[2][1]=1;figuras_propias[2][1]=1;seleccionada=8;draw_circle(160,180,15);end					
				end;				
				if (mouse.x>200 and mouse.x<260)
					if (mouse.y<80 and !figuras_tablero[0][2])
					figuras_tablero[0][2]=1;figuras_propias[0][2]=1;seleccionada=3;draw_circle(230,55,15);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][2])
					figuras_tablero[1][2]=1;figuras_propias[1][2]=1;seleccionada=6;draw_circle(230,120,15);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][2])
					figuras_tablero[2][2]=1;figuras_propias[2][2]=1;seleccionada=9;draw_circle(230,180,15);end					
				end;				
			end;
			
			if (seleccionada>0 and seleccionada!=10)
			timer[1]=0;
			casilla=seleccionada+6;
			say("Casilla seleccionada enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&casilla,4);
			net_udp_send(1,1,0);
			seleccionada=10;
			end;
			
			if (seleccionada==10)
			/* Hemos de recibir la confirmacin del mensaje enviado (casilla seleccionada), si esta no llegase en 3 segundos, la partida finaliza
			El dato que hemos de recibir es un 1, que indica que ahora es el turno del oponente */
				if (estado_oponente==1)
				seleccionada=0;timer[1]=0;timer[0]=0;
				texto=write(0,160,225,4,"Turno del oponente");
				say("El cliente ha recibido la casilla seleccionada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				turno=0;
					
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
						if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
					say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (escucha)
					net_udp_close(1); // Cerramos socket 1 (envio)
					menu(); // Llamamos al proceso menu()
					return;
					end;
				
					// Comprobamos si el servidor ha ganado
					for (i=0;i<=2;i++) // Lneas horizontales
						linea=0;
						for (j=0;j<=2;j++)
						if (figuras_propias[i][j]) linea++;end				
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					for (j=0;j<=2;j++) // Lneas verticales
						linea=0;
						for (i=0;i<=2;i++)
						if (figuras_propias[i][j]) linea++;end
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					if (figuras_propias[0][0] and figuras_propias[1][1] and figuras_propias[2][2]) turno=3;end
					if (figuras_propias[0][2] and figuras_propias[1][1] and figuras_propias[2][0]) turno=3;end
					
					if (turno==3) // En caso afirmativo, acabamos la partida y enviamos el mensaje
					memcopy(info.data,&turno,4);
					net_udp_send(1,1,0);
					say("Partida finalizada, has ganado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (escucha)
					net_udp_close(1); // Cerramos socket 1 (envio)
					menu(); // Llamamos al proceso menu()
					return;				
					end;
					//..

				else if (timer[1]>300)
				timer[1]=0;
				say("El cliente no responde (no ha recibido la casilla seleccionada) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (escucha)
				net_udp_close(1); // Cerramos socket 1 (envio)
				menu(); // Llamamos al proceso menu()
				return;
				end;
				end
			end;
			
			//..
			
			// Respondiendo a peticin de ping
			if (estado_oponente==6)
			timer[1]=0;
			say("Respondiendo peticin de ping al cliente ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&estado_oponente,4);
			net_udp_send(1,1,0);
			estado_oponente=0;
			end;
			
			// Si en 35 segundos (el oponente que no tiene su turno enva un ping cada 30 segundos) no 
			// hemos recibido una peticin para responder a un ping finalizaremos la partida
			if (timer[1]>3500)
			timer[1]=0;
			say("El cliente no responde (no ha enviado peticin de ping) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
			net_udp_freepacket(0); // Vaciamos paquete 0
			net_udp_close(0); // Cerramos socket 0 (escucha)
			net_udp_close(1); // Cerramos socket 1 (envio)
			menu(); // Llamamos al proceso menu()
			return;				
			end;
			
			end;						
FRAME;
END;
END;

PROCESS cliente()
PRIVATE
int conectado=0; // Para bucle while (0 no hay seal del servidor, 1 si)
int reintentos=0; // Controla el n de intetos para conectar al servidor (hay 3 intentos fijados en el cdigo para conectar con el servidor, con 3 segundos entre cada uno)
int texto; // Para borrar texto en pantalla de turno del oponente
int estado_oponente; // Aqu guardamos la informacin que recibimos del oponente (2 desconexin/error - 3 fin partida - 6 'ping' - 7-15 casilla seleccionada)
int haciendo_ping; // Si est a 1 es que estamos realizando un 'ping' (6)
int seleccionada; // Indica la casilla que hemos podido seleccionar una casilla y se procede a enviar datos (1 a 9) - Se pone a valor 10 para esperar la confirmacin de que se ha recibido el mensaje
int casilla; // De 7 a 15 (para enviarlo en un paquete)
int linea; // Vale 3 si se ha formado una lnea horizontal, vertical o diagonal
int empate; // Vale 1 si ha habido empate
BEGIN
	turno=4; // Peticin para jugar (si cambiamos por ejemplo esto a 5, el servidor no aceptara)
	memcopy(info.data,&turno,4);
	net_udp_send(0,1,0); // Enviamos paquete para conectar al servidor
	net_udp_open(1,puerto+1); // Abrimos el socket 1 para escucha (servidor) en el puerto 'puerto'+1
	net_udp_bind(1,1,"127.0.0.1",puerto+1); // "Bindeamos" el socket 1 con el canal 1 en el puerto de escucha
	timer[0]=0; // Contador a 0
	timer[1]=1; // Contador a 0
	write(0,160,120,4,"Conectando con el servidor ...");
		
		while (!conectado and !key(_esc)) // Esperamos conexin con el servidor o cancelamos pulsando escape
			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(0);end;
			if (timer[0]>100) timer[0]=0;write(0,160,120,4,"Conectando con el servidor ...");end;
			//..
			if (timer[1]>300 and conectado==0) 
				reintentos++;
				if (reintentos!=3) // Si no se han cumplido aun los 3 intentos, volvemos a intentar conectar
				say("Peticin para jugar enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				net_udp_send(0,1,0); // Enviamos paquete para conectar al servidor
				timer[1]=0;
				else; // Si no, cancelamos y volvemos al men
				say ("El servidor no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (envio)
				net_udp_close(1); // Cerramos socket 1 (escucha)
				menu(); // Llamamos al proceso menu()
				return;
				end;			
			end;
			if (net_udp_recv(1,0)>0) // Llegada de algn paquete
			turno=0;
			memcopy(&turno,info.data,4);
				if (turno==5) 
				say("Peticin para jugar aceptada, comienza la partida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				conectado=1;
				turno=0; // Es el turno del servidor (oponente)
				else;
				say("Peticin errnea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				end
			end;
		frame;
		end;
		
		if (conectado==0) 
		say ("Cliente cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
		net_udp_freepacket(0); // Vaciamos paquete 0
		net_udp_close(0); // Cerramos socket 0 (envio)
		net_udp_close(1); // Cerramos socket 1 (escucha)
		menu(); // Llamamos al proceso menu()
		return;end
		
		// Comienza la partida
		delete_text(0);
		write(0,160,5,4,"Tres en raya (Cliente)");
		texto=write(0,160,225,4,"Turno del oponente");
		timer[0]=0;timer[1]=0;
		// Dibujando tablero
		draw_line(120,45,120,195);
		draw_line(200,45,200,195);
		draw_line(60,80,260,80);
		draw_line(60,160,260,160);		
LOOP
		if (net_udp_recv(1,0)>0) // Llegada de algn paquete
			estado_oponente=0;
			memcopy(&estado_oponente,info.data,4);
				if (estado_oponente==2) 
				say("El servidor ha desconectado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (envio)
				net_udp_close(1); // Cerramos socket 1 (escucha)
				menu(); // Llamamos al proceso menu()
				return;				
				else if (estado_oponente==3) 
					say("Partida finalizada, has perdido ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (envio)
					net_udp_close(1); // Cerramos socket 1 (escucha)
					menu(); // Llamamos al proceso menu()					
					return;
					end;
					if (estado_oponente<0 and estado_oponente>15);
					say("Peticin errnea o desconocida recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					end;
				end
		end;

		if (key(_esc)) // Cancelando partida
		say ("Cliente cancelado/finalizado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
		turno=2; // Desconexin/error
		memcopy(info.data,&turno,4);
		net_udp_send(0,1,0); // Enviamos desconexin/error (no esperamos que lo haya recibido por ello si el destinatario no la recibe, habra de esperar hasta que l detecte que ya no hay partida)
		net_udp_freepacket(0); // Vaciamos paquete 0
		net_udp_close(0); // Cerramos socket 0 (envio)
		net_udp_close(1); // Cerramos socket 1 (escucha)
		menu(); // Llamamos al proceso menu();
		return;
		end

			if (turno==0) // Turno del oponente
			mouse.graph=0;
			// 'Parpadeo del mensaje de texto'
			if (timer[0]>50) delete_text(texto);end;
			if (timer[0]>100) timer[0]=0;texto=write(0,160,225,4,"Turno del oponente");end;
			//..

			// Marcando casilla del oponente, recibiendo datos
			if (estado_oponente>6 and estado_oponente<16) // Se ha recibido una casilla seleccionada por el servidor
			timer[0]=0;timer[1]=0;
			if (texto>0) delete_text(texto);end // Eliminar texto que pueda permanecer en pantalla
			say("Casilla seleccionada por el servidor recibida ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			turno=1;
			memcopy(info.data,&turno,4); // Mandamos confirmacin de que hemos recibido el mensaje (ahora es el turno del cliente)
			net_udp_send(0,1,0);
				switch (estado_oponente)
					case (7):
					figuras_tablero[0][0]=1;draw_circle(90,55,15);
					end;
					case (8):
					figuras_tablero[0][1]=1;draw_circle(160,55,15);
					end;
					case (9):
					figuras_tablero[0][2]=1;draw_circle(230,55,15);
					end;
					case (10):
					figuras_tablero[1][0]=1;draw_circle(90,120,15);
					end;
					case (11):
					figuras_tablero[1][1]=1;draw_circle(160,120,15);
					end;
					case (12):
					figuras_tablero[1][2]=1;draw_circle(230,120,15);
					end;
					case (13):
					figuras_tablero[2][0]=1;draw_circle(90,180,15);
					end;
					case (14):
					figuras_tablero[2][1]=1;draw_circle(160,180,15);
					end;
					case (15):
					figuras_tablero[2][2]=1;draw_circle(230,180,15);
					end;				
				end;
				
				// Comprobacion de si hay un empate
				for (i=0;i<=2;i++)
					for (j=0;j<=2;j++)
					if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
					end;
					if (empate==0) break;end
				end;
				
				if (empate==1) // Hay un empate
				say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (envio)
				net_udp_close(1); // Cerramos socket 1 (escucha)
				menu(); // Llamamos al proceso menu()
				return;
				end;
			end;
			//..
			
			/* Si en 30 segundos no hemos recibido informacin (seal) del oponente es por dos causas:
				1. El oponente se est pensando mucho la jugada :-)
				2. El oponente no tiene conexin o cualquier otro error similar (ha desconectado y no nos ha llegado dicho mensaje)
			Por ello enviamos un 'ping' (6) para saber si an sigue ah, prorrogando el tiempo en caso afirmativo, 
			en caso de no obtener respuesta, se produce una desconexin (finalizacin de la partida).
			*/
			if (timer[1]>3000)
			timer[1]=0;
			haciendo_ping=1;
			estado_oponente=6;
			say("Peticin de ping enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&estado_oponente,4);
			net_udp_send(0,1,0);			
			estado_oponente=0;
			end
			
			if (haciendo_ping)
				if (estado_oponente==6)
				say ("Peticin de ping recibida por el servidor ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
				haciendo_ping=0;
				timer[1]=0;
				else
				if (timer[1]>300)
				timer[1]=0;
				say("El servidor no responde ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (envio)
				net_udp_close(1); // Cerramos socket 1 (escucha)
				menu(); // Llamamos al proceso menu()
				return;		
				end;
				end;
			end;
			//..
			
			end
			
			if (turno==1) // Nuestro turno
			mouse.graph=imagen_raton; // Fijamos la imagen del raton

			// Seleccionando una casilla y envo, recepcin de datos
			if (seleccionada==0 and mouse.left and mouse.x>=60 and mouse.x<=260 and mouse.y>=45 and mouse.y<=195)
				if (mouse.x<120)
					if (mouse.y<80 and !figuras_tablero[0][0])
					figuras_tablero[0][0]=1;figuras_propias[0][0]=1;seleccionada=1;draw_rect(65,50,115,75);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][0])
					figuras_tablero[1][0]=1;figuras_propias[1][0]=1;seleccionada=4;draw_rect(65,85,115,155);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][0])
					figuras_tablero[2][0]=1;figuras_propias[2][0]=1;seleccionada=7;draw_rect(65,165,115,190);end					
				end;
				if (mouse.x>120 and mouse.x<200)
					if (mouse.y<80 and !figuras_tablero[0][1])
					figuras_tablero[0][1]=1;figuras_propias[0][1]=1;seleccionada=2;draw_rect(125,50,195,75);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][1])
					figuras_tablero[1][1]=1;figuras_propias[1][1]=1;seleccionada=5;draw_rect(125,85,195,155);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][1])
					figuras_tablero[2][1]=1;figuras_propias[2][1]=1;seleccionada=8;draw_rect(125,165,195,190);end					
				end;				
				if (mouse.x>200 and mouse.x<260)
					if (mouse.y<80 and !figuras_tablero[0][2])
					figuras_tablero[0][2]=1;figuras_propias[0][2]=1;seleccionada=3;draw_rect(205,50,255,75);end
					if (mouse.y>80 and mouse.y<160 and !figuras_tablero[1][2])
					figuras_tablero[1][2]=1;figuras_propias[1][2]=1;seleccionada=6;draw_rect(205,85,255,155);end
					if (mouse.y>160 and mouse.y<195 and !figuras_tablero[2][2])
					figuras_tablero[2][2]=1;figuras_propias[2][2]=1;seleccionada=9;draw_rect(205,165,255,190);end					
				end;				
			end;
			
			if (seleccionada>0 and seleccionada!=10)
			timer[1]=0;
			casilla=seleccionada+6;
			say("Casilla seleccionada enviada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&casilla,4);
			net_udp_send(0,1,0);
			seleccionada=10;
			end;
			
			if (seleccionada==10)
			/* Hemos de recibir la confirmacin del mensaje enviado (casilla seleccionada), si esta no llegase en 3 segundos, la partida finaliza
			El dato que hemos de recibir es un 1, que indica que ahora es el turno del oponente */
				if (estado_oponente==1)
				seleccionada=0;
				texto=write(0,160,225,4,"Turno del oponente");
				say("El servidor ha recibido la casilla seleccionada ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				turno=0;
				
					// Comprobacion de si hay un empate
					for (i=0;i<=2;i++)
						for (j=0;j<=2;j++)
						if (figuras_tablero[i][j]) empate=1;else empate=0;break;end
						end;
						if (empate==0) break;end
					end;
				
					if (empate==1) // Hay un empate
					say("Partida finalizada, ha habido empate ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (envio)
					net_udp_close(1); // Cerramos socket 1 (escucha)
					menu(); // Llamamos al proceso menu()
					return;
					end;
				
					// Comprobamos si el cliente ha ganado
					for (i=0;i<=2;i++) // Lneas horizontales
						linea=0;
						for (j=0;j<=2;j++)
						if (figuras_propias[i][j]) linea++;end				
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					for (j=0;j<=2;j++) // Lneas verticales
						linea=0;
						for (i=0;i<=2;i++)
						if (figuras_propias[i][j]) linea++;end
						end;
						if (linea==3) turno=3;break;end						
					end;
					
					if (figuras_propias[0][0] and figuras_propias[1][1] and figuras_propias[2][2]) turno=3;end
					if (figuras_propias[0][2] and figuras_propias[1][1] and figuras_propias[2][0]) turno=3;end
					
					if (turno==3) // En caso afirmativo, acabamos la partida y enviamos el mensaje
					memcopy(info.data,&turno,4);
					net_udp_send(0,1,0);
					say("Partida finalizada, has ganado ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
					net_udp_freepacket(0); // Vaciamos paquete 0
					net_udp_close(0); // Cerramos socket 0 (envio)
					net_udp_close(1); // Cerramos socket 1 (escucha)
					menu(); // Llamamos al proceso menu()
					return;				
					end;
					//..
					
				else if (timer[1]>300)
				timer[1]=0;
				say("El servidor no responde (no ha recibido la casilla seleccionada) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
				net_udp_freepacket(0); // Vaciamos paquete 0
				net_udp_close(0); // Cerramos socket 0 (envio)
				net_udp_close(1); // Cerramos socket 1 (escucha)
				menu(); // Llamamos al proceso menu()
				return;
				end;
				end
			end;
			//..
			
			// Respondiendo a peticin de ping
			if (estado_oponente==6)
			timer[1]=0;
			say("Respondiendo peticin de ping al servidor ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola
			memcopy(info.data,&estado_oponente,4);
			net_udp_send(0,1,0);
			estado_oponente=0;
			end;
			
			// Si en 35 segundos (el oponente que no tiene su turno enva un ping cada 30 segundos) no 
			// hemos recibido una peticin para responder a un ping finalizaremos la partida
			if (timer[1]>3500)
			timer[1]=0;
			say("El servidor no responde (no ha enviado peticin de ping) ..."+ftime(" [%d/%m/%y - %H:%M:%S]",time())); // Mensaje consola			
			net_udp_freepacket(0); // Vaciamos paquete 0
			net_udp_close(0); // Cerramos socket 0 (envio)
			net_udp_close(1); // Cerramos socket 1 (escucha)
			menu(); // Llamamos al proceso menu()
			return;				
			end;
			
			end;			
FRAME;
END;
END;