# frozen_string_literal: true

class AsyncIdxVulnerabilityOccurencesOnPrimIdenId < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  NEW_INDEX_NAME = 'index_vulnerability_occurrences_prim_iden_id_and_vuln_id'
  TABLE_NAME = :vulnerability_occurrences

  # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
  def up
    prepare_async_index TABLE_NAME, [:primary_identifier_id, :vulnerability_id], name: NEW_INDEX_NAME
  end
  # rubocop:enable Migration/PreventIndexCreation

  def down
    unprepare_async_index_by_name TABLE_NAME, NEW_INDEX_NAME
  end
end
