/* gmpc-favorites.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-favorites.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
/****************************************************************************************
         * "Public" api.  
         ****************************************************************************************/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <libmpd/libmpd.h>
#include <glib/gi18n-lib.h>
#include <libmpd/libmpdclient.h>
#include <misc.h>
#include <libmpd/libmpd-internal.h>
#include <plugin.h>
#include <main.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>

#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block37Data Block37Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GmpcFavoritesListPrivate {
	MpdData* list;
	gboolean _disable;
};

struct _GmpcFavoritesButtonPrivate {
	mpd_Song* song;
	GtkImage* image;
	gboolean fstate;
	GdkPixbuf* pb;
};

struct _Block37Data {
	int _ref_count_;
	GmpcFavoritesButton * self;
	gchar* pp;
};


GmpcFavoritesList* favorites = NULL;
static gpointer gmpc_favorites_list_parent_class = NULL;
static gpointer gmpc_favorites_button_parent_class = NULL;

#define some_unique_name_fav VERSION
#define use_transition_fav TRUE
#define LOG_DOMAIN_FAV "Gmpc.Favorites"
#define GMPC_FAVORITES_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_FAVORITES_TYPE_LIST, GmpcFavoritesListPrivate))
enum  {
	GMPC_FAVORITES_LIST_DUMMY_PROPERTY,
	GMPC_FAVORITES_LIST_DISABLE
};
static void gmpc_favorites_list_con_changed (GmpcFavoritesList* self, GmpcConnection* conn, MpdObj* server, gint connect);
static void gmpc_favorites_list_status_changed (GmpcFavoritesList* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what);
static GObject * gmpc_favorites_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gmpc_favorites_list_con_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self);
static void _gmpc_favorites_list_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static void gmpc_favorites_list_finalize (GObject* obj);
static void _vala_gmpc_favorites_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gmpc_favorites_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GMPC_FAVORITES_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_FAVORITES_TYPE_BUTTON, GmpcFavoritesButtonPrivate))
enum  {
	GMPC_FAVORITES_BUTTON_DUMMY_PROPERTY
};
static gboolean gmpc_favorites_button_button_press_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventButton* event);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (Block37Data* _data37_);
static void _lambda38_ (GtkMenuItem* source, Block37Data* _data37_);
static void __lambda38__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean gmpc_favorites_button_enter_notify_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventCrossing* motion);
static gboolean gmpc_favorites_button_leave_notify_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventCrossing* motion);
static void gmpc_favorites_button_update (GmpcFavoritesButton* self, GmpcFavoritesList* list);
static GObject * gmpc_favorites_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda39_ (GParamSpec* source, GmpcFavoritesButton* self);
static void __lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _gmpc_favorites_button_update_gmpc_favorites_list_updated (GmpcFavoritesList* _sender, gpointer self);
static gboolean _gmpc_favorites_button_button_press_event_callback_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _gmpc_favorites_button_enter_notify_event_callback_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _gmpc_favorites_button_leave_notify_event_callback_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void gmpc_favorites_button_finalize (GObject* obj);


/**
         * If disconnected from mpd, clear the list.
         * On connect fill 
         */
static void gmpc_favorites_list_con_changed (GmpcFavoritesList* self, GmpcConnection* conn, MpdObj* server, gint connect) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (connect == 1) {
		const gchar* _tmp0_ = NULL;
		MpdData* _tmp1_ = NULL;
		g_log (LOG_DOMAIN_FAV, G_LOG_LEVEL_DEBUG, "gmpc-favorites.vala:57: Update list");
		_tmp0_ = _ ("Favorites");
		_tmp1_ = mpd_database_get_playlist_content (server, _tmp0_);
		_mpd_data_free0 (self->priv->list);
		self->priv->list = _tmp1_;
		gmpc_favorites_list_set_disable (self, FALSE);
		g_signal_emit_by_name (self, "updated");
	} else {
		_mpd_data_free0 (self->priv->list);
		self->priv->list = NULL;
	}
}


/**
         * If playlist changed update the list
         */
static void gmpc_favorites_list_status_changed (GmpcFavoritesList* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (!self->priv->_disable) {
		_tmp0_ = (what & MPD_CST_STORED_PLAYLIST) == MPD_CST_STORED_PLAYLIST;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		MpdData* _tmp2_ = NULL;
		g_log (LOG_DOMAIN_FAV, G_LOG_LEVEL_DEBUG, "gmpc-favorites.vala:75: Update list");
		_tmp1_ = _ ("Favorites");
		_tmp2_ = mpd_database_get_playlist_content (server, _tmp1_);
		_mpd_data_free0 (self->priv->list);
		self->priv->list = _tmp2_;
		g_signal_emit_by_name (self, "updated");
	}
}


/**
         * Check if the song (specified by path) is favored
         */
gboolean gmpc_favorites_list_is_favorite (GmpcFavoritesList* self, const gchar* path) {
	gboolean result = FALSE;
	MpdData* _tmp0_ = NULL;
	MpdData* iter;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = mpd_data_get_first (self->priv->list);
	iter = _tmp0_;
	while (TRUE) {
		if (!(iter != NULL)) {
			break;
		}
		if (iter->type == MPD_DATA_TYPE_SONG) {
			if (g_strcmp0 (iter->song->file, path) == 0) {
				result = TRUE;
				return result;
			}
		}
		iter = mpd_data_get_next_real (iter, FALSE);
	}
	result = FALSE;
	return result;
}


/**
         * Favor, or unfavor a song
         */
void gmpc_favorites_list_set_favorite (GmpcFavoritesList* self, const gchar* path, gboolean favorite) {
	gboolean _tmp0_;
	gboolean current;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gmpc_favorites_list_is_favorite (self, path);
	current = _tmp0_;
	if (!self->priv->_disable) {
		_tmp1_ = current != favorite;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (favorite) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = _ ("Favorites");
			mpd_database_playlist_list_add (connection, _tmp2_, path);
		} else {
			MpdData* _tmp3_ = NULL;
			MpdData* iter;
			_tmp3_ = mpd_data_get_first (self->priv->list);
			iter = _tmp3_;
			while (TRUE) {
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type == MPD_DATA_TYPE_SONG) {
					if (g_strcmp0 (iter->song->file, path) == 0) {
						const gchar* _tmp4_ = NULL;
						_tmp4_ = _ ("Favorites");
						mpd_database_playlist_list_delete (connection, _tmp4_, iter->song->pos);
						return;
					}
				}
				iter = mpd_data_get_next_real (iter, FALSE);
			}
		}
	}
}


GmpcFavoritesList* gmpc_favorites_list_construct (GType object_type) {
	GmpcFavoritesList * self = NULL;
	self = (GmpcFavoritesList*) g_object_new (object_type, NULL);
	return self;
}


GmpcFavoritesList* gmpc_favorites_list_new (void) {
	return gmpc_favorites_list_construct (GMPC_FAVORITES_TYPE_LIST);
}


gboolean gmpc_favorites_list_get_disable (GmpcFavoritesList* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_disable;
	return result;
}


void gmpc_favorites_list_set_disable (GmpcFavoritesList* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_disable = value;
	g_object_notify ((GObject *) self, "disable");
}


static void _gmpc_favorites_list_con_changed_gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self) {
	gmpc_favorites_list_con_changed (self, _sender, mi, connect);
}


static void _gmpc_favorites_list_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_favorites_list_status_changed (self, _sender, mi, what);
}


static gboolean mpd_get_connected (MpdObj* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpd_check_connected (self);
	result = _tmp0_;
	return result;
}


static GObject * gmpc_favorites_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcFavoritesList * self;
	gboolean _tmp0_;
	parent_class = G_OBJECT_CLASS (gmpc_favorites_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_FAVORITES_LIST (obj);
	g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) _gmpc_favorites_list_con_changed_gmpc_connection_connection_changed, self, 0);
	g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_favorites_list_status_changed_gmpc_connection_status_changed, self, 0);
	g_log (LOG_DOMAIN_FAV, G_LOG_LEVEL_DEBUG, "gmpc-favorites.vala:42: Favorites object created");
	_tmp0_ = mpd_get_connected (connection);
	if (_tmp0_) {
		gmpc_favorites_list_con_changed (self, gmpcconn, connection, 1);
	}
	return obj;
}


static void gmpc_favorites_list_class_init (GmpcFavoritesListClass * klass) {
	gmpc_favorites_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcFavoritesListPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gmpc_favorites_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gmpc_favorites_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = gmpc_favorites_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_favorites_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GMPC_FAVORITES_LIST_DISABLE, g_param_spec_boolean ("disable", "disable", "disable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Signal for the widget using the list to see if it needs to recheck status
	         */
	g_signal_new ("updated", GMPC_FAVORITES_TYPE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gmpc_favorites_list_instance_init (GmpcFavoritesList * self) {
	self->priv = GMPC_FAVORITES_LIST_GET_PRIVATE (self);
	self->priv->list = NULL;
	self->priv->_disable = FALSE;
}


static void gmpc_favorites_list_finalize (GObject* obj) {
	GmpcFavoritesList * self;
	self = GMPC_FAVORITES_LIST (obj);
	_mpd_data_free0 (self->priv->list);
	G_OBJECT_CLASS (gmpc_favorites_list_parent_class)->finalize (obj);
}


/**
     * This class is created, and stays active until the last GmpcFavoritesButton gets removed
     */
GType gmpc_favorites_list_get_type (void) {
	static volatile gsize gmpc_favorites_list_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_favorites_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcFavoritesListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_favorites_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcFavoritesList), 0, (GInstanceInitFunc) gmpc_favorites_list_instance_init, NULL };
		GType gmpc_favorites_list_type_id;
		gmpc_favorites_list_type_id = g_type_register_static (G_TYPE_OBJECT, "GmpcFavoritesList", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_favorites_list_type_id__volatile, gmpc_favorites_list_type_id);
	}
	return gmpc_favorites_list_type_id__volatile;
}


static void _vala_gmpc_favorites_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GmpcFavoritesList * self;
	self = GMPC_FAVORITES_LIST (object);
	switch (property_id) {
		case GMPC_FAVORITES_LIST_DISABLE:
		g_value_set_boolean (value, gmpc_favorites_list_get_disable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gmpc_favorites_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GmpcFavoritesList * self;
	self = GMPC_FAVORITES_LIST (object);
	switch (property_id) {
		case GMPC_FAVORITES_LIST_DISABLE:
		gmpc_favorites_list_set_disable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (Block37Data* _data37_) {
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		_g_object_unref0 (_data37_->self);
		_g_free0 (_data37_->pp);
		g_slice_free (Block37Data, _data37_);
	}
}


static void _lambda38_ (GtkMenuItem* source, Block37Data* _data37_) {
	GmpcFavoritesButton * self;
	self = _data37_->self;
	g_return_if_fail (source != NULL);
	mpd_database_playlist_list_add (connection, _data37_->pp, self->priv->song->file);
}


static void __lambda38__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda38_ (_sender, self);
}


static gboolean gmpc_favorites_button_button_press_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	if ((*event).button == 1) {
		_tmp0_ = self->priv->song != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_favorites_list_set_favorite (favorites, self->priv->song->file, !self->priv->fstate);
		self->priv->fstate = !self->priv->fstate;
	} else {
		gboolean _tmp1_ = FALSE;
		if ((*event).button == 3) {
			_tmp1_ = self->priv->song != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GtkMenu* _tmp2_ = NULL;
			GtkMenu* menu;
			gint items;
			MpdData* _tmp3_ = NULL;
			MpdData* item;
			_tmp2_ = (GtkMenu*) gtk_menu_new ();
			menu = g_object_ref_sink (_tmp2_);
			items = 0;
			_tmp3_ = mpd_database_playlist_list (connection);
			item = _tmp3_;
			while (TRUE) {
				Block37Data* _data37_;
				gchar* _tmp4_;
				GtkImageMenuItem* _tmp5_ = NULL;
				GtkImageMenuItem* entry;
				const gchar* _tmp6_ = NULL;
				_data37_ = g_slice_new0 (Block37Data);
				_data37_->_ref_count_ = 1;
				_data37_->self = g_object_ref (self);
				if (!(item != NULL)) {
					block37_data_unref (_data37_);
					_data37_ = NULL;
					break;
				}
				_tmp4_ = g_strdup ((gchar*) item->playlist->path);
				_data37_->pp = _tmp4_;
				_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_data37_->pp);
				entry = g_object_ref_sink (_tmp5_);
				_tmp6_ = _ ("Favorites");
				if (g_strcmp0 (_data37_->pp, _tmp6_) == 0) {
					GtkImage* _tmp7_ = NULL;
					GtkImage* _tmp8_;
					_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-favorite", GTK_ICON_SIZE_MENU);
					_tmp8_ = g_object_ref_sink (_tmp7_);
					gtk_image_menu_item_set_image (entry, (GtkWidget*) _tmp8_);
					_g_object_unref0 (_tmp8_);
				} else {
					GtkImage* _tmp9_ = NULL;
					GtkImage* _tmp10_;
					_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playlist", GTK_ICON_SIZE_MENU);
					_tmp10_ = g_object_ref_sink (_tmp9_);
					gtk_image_menu_item_set_image (entry, (GtkWidget*) _tmp10_);
					_g_object_unref0 (_tmp10_);
				}
				g_signal_connect_data ((GtkMenuItem*) entry, "activate", (GCallback) __lambda38__gtk_menu_item_activate, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
				gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) entry));
				item = mpd_data_get_next (item);
				items++;
				_g_object_unref0 (entry);
				block37_data_unref (_data37_);
				_data37_ = NULL;
			}
			if (items > 0) {
				gtk_widget_show_all ((GtkWidget*) menu);
				gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			} else {
				gtk_object_destroy ((GtkObject*) menu);
			}
			result = TRUE;
			_mpd_data_free0 (item);
			_g_object_unref0 (menu);
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean gmpc_favorites_button_enter_notify_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventCrossing* motion) {
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* pb2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	_tmp0_ = gdk_pixbuf_copy (self->priv->pb);
	pb2 = _tmp0_;
	if (self->priv->fstate) {
		colorshift_pixbuf (pb2, self->priv->pb, 10);
	} else {
		colorshift_pixbuf (pb2, self->priv->pb, -50);
	}
	gtk_image_set_from_pixbuf (self->priv->image, pb2);
	result = FALSE;
	_g_object_unref0 (pb2);
	return result;
}


static gboolean gmpc_favorites_button_leave_notify_event_callback (GmpcFavoritesButton* self, GtkWidget* button, GdkEventCrossing* motion) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	gmpc_favorites_button_update (self, favorites);
	result = FALSE;
	return result;
}


static void gmpc_favorites_button_update (GmpcFavoritesButton* self, GmpcFavoritesList* list) {
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* pb2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list != NULL);
	if (self->priv->song != NULL) {
		gboolean _tmp0_;
		_tmp0_ = gmpc_favorites_list_is_favorite (favorites, self->priv->song->file);
		self->priv->fstate = _tmp0_;
	} else {
		gtk_widget_hide ((GtkWidget*) self);
		return;
	}
	_tmp1_ = gdk_pixbuf_copy (self->priv->pb);
	pb2 = _tmp1_;
	if (self->priv->fstate) {
		colorshift_pixbuf (pb2, self->priv->pb, 30);
	} else {
		colorshift_pixbuf (pb2, self->priv->pb, -80);
	}
	gtk_image_set_from_pixbuf (self->priv->image, pb2);
	gtk_widget_show ((GtkWidget*) self->priv->image);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (pb2);
}


/**********************************************************************
         * Public api
         *********************************************************************/
static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


void gmpc_favorites_button_set_song (GmpcFavoritesButton* self, const mpd_Song* song) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	mpd_Song* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->song == NULL) {
		_tmp0_ = song == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->song != NULL) {
		_tmp2_ = song != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (self->priv->song->file, song->file) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	_tmp3_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (self->priv->song);
	self->priv->song = _tmp3_;
	gmpc_favorites_button_update (self, favorites);
}


GmpcFavoritesButton* gmpc_favorites_button_construct (GType object_type) {
	GmpcFavoritesButton * self = NULL;
	self = (GmpcFavoritesButton*) g_object_new (object_type, NULL);
	return self;
}


GmpcFavoritesButton* gmpc_favorites_button_new (void) {
	return gmpc_favorites_button_construct (GMPC_FAVORITES_TYPE_BUTTON);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda39_ (GParamSpec* source, GmpcFavoritesButton* self) {
	gboolean _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gmpc_favorites_list_get_disable (favorites);
	if (_tmp0_) {
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	}
}


static void __lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda39_ (pspec, self);
}


static void _gmpc_favorites_button_update_gmpc_favorites_list_updated (GmpcFavoritesList* _sender, gpointer self) {
	gmpc_favorites_button_update (self, _sender);
}


static gboolean _gmpc_favorites_button_button_press_event_callback_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gmpc_favorites_button_button_press_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_favorites_button_enter_notify_event_callback_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gmpc_favorites_button_enter_notify_event_callback (self, _sender, event);
	return result;
}


static gboolean _gmpc_favorites_button_leave_notify_event_callback_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gmpc_favorites_button_leave_notify_event_callback (self, _sender, event);
	return result;
}


static GObject * gmpc_favorites_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcFavoritesButton * self;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* it;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	GtkImage* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gmpc_favorites_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_FAVORITES_BUTTON (obj);
	gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	it = _tmp1_;
	_tmp2_ = gtk_icon_theme_load_icon (it, "emblem-favorite", 24, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch26_g_error;
	}
	_g_object_unref0 (self->priv->pb);
	self->priv->pb = _tmp3_;
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("gmpc-favorites.vala:165: error: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (it);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	if (favorites == NULL) {
		GmpcFavoritesList* _tmp4_ = NULL;
		_tmp4_ = gmpc_favorites_list_new ();
		_g_object_unref0 (favorites);
		favorites = _tmp4_;
		g_object_add_weak_pointer ((GObject*) favorites, &favorites);
	} else {
		g_object_ref ((GObject*) favorites);
	}
	g_signal_connect_object ((GObject*) favorites, "notify::disable", (GCallback) __lambda39__g_object_notify, self, 0);
	g_signal_connect_object (favorites, "updated", (GCallback) _gmpc_favorites_button_update_gmpc_favorites_list_updated, self, 0);
	_tmp5_ = (GtkImage*) gtk_image_new ();
	_g_object_unref0 (self->priv->image);
	self->priv->image = g_object_ref_sink (_tmp5_);
	gmpc_favorites_button_update (self, favorites);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->image);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _gmpc_favorites_button_button_press_event_callback_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _gmpc_favorites_button_enter_notify_event_callback_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _gmpc_favorites_button_leave_notify_event_callback_gtk_widget_leave_notify_event, self, 0);
	_g_object_unref0 (it);
	return obj;
}


static void gmpc_favorites_button_class_init (GmpcFavoritesButtonClass * klass) {
	gmpc_favorites_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcFavoritesButtonPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_favorites_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_favorites_button_finalize;
}


static void gmpc_favorites_button_instance_init (GmpcFavoritesButton * self) {
	self->priv = GMPC_FAVORITES_BUTTON_GET_PRIVATE (self);
	self->priv->fstate = FALSE;
	self->priv->pb = NULL;
}


static void gmpc_favorites_button_finalize (GObject* obj) {
	GmpcFavoritesButton * self;
	self = GMPC_FAVORITES_BUTTON (obj);
	if (favorites != NULL) {
		g_object_unref ((GObject*) favorites);
	}
	_mpd_freeSong0 (self->priv->song);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->pb);
	G_OBJECT_CLASS (gmpc_favorites_button_parent_class)->finalize (obj);
}


/**
     * The actual favorite button
     */
GType gmpc_favorites_button_get_type (void) {
	static volatile gsize gmpc_favorites_button_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_favorites_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcFavoritesButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_favorites_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcFavoritesButton), 0, (GInstanceInitFunc) gmpc_favorites_button_instance_init, NULL };
		GType gmpc_favorites_button_type_id;
		gmpc_favorites_button_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GmpcFavoritesButton", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_favorites_button_type_id__volatile, gmpc_favorites_button_type_id);
	}
	return gmpc_favorites_button_type_id__volatile;
}



