// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the findings for the specified Network Access Scope analysis.
func (c *Client) GetNetworkInsightsAccessScopeAnalysisFindings(ctx context.Context, params *GetNetworkInsightsAccessScopeAnalysisFindingsInput, optFns ...func(*Options)) (*GetNetworkInsightsAccessScopeAnalysisFindingsOutput, error) {
	if params == nil {
		params = &GetNetworkInsightsAccessScopeAnalysisFindingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetNetworkInsightsAccessScopeAnalysisFindings", params, optFns, c.addOperationGetNetworkInsightsAccessScopeAnalysisFindingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetNetworkInsightsAccessScopeAnalysisFindingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetNetworkInsightsAccessScopeAnalysisFindingsInput struct {

	// The ID of the Network Access Scope analysis.
	//
	// This member is required.
	NetworkInsightsAccessScopeAnalysisId *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetNetworkInsightsAccessScopeAnalysisFindingsOutput struct {

	// The findings associated with Network Access Scope Analysis.
	AnalysisFindings []types.AccessScopeAnalysisFinding

	// The status of Network Access Scope Analysis.
	AnalysisStatus types.AnalysisStatus

	// The ID of the Network Access Scope analysis.
	NetworkInsightsAccessScopeAnalysisId *string

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetNetworkInsightsAccessScopeAnalysisFindingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetNetworkInsightsAccessScopeAnalysisFindings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetNetworkInsightsAccessScopeAnalysisFindings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetNetworkInsightsAccessScopeAnalysisFindings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetNetworkInsightsAccessScopeAnalysisFindingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetNetworkInsightsAccessScopeAnalysisFindings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetNetworkInsightsAccessScopeAnalysisFindingsPaginatorOptions is the paginator
// options for GetNetworkInsightsAccessScopeAnalysisFindings
type GetNetworkInsightsAccessScopeAnalysisFindingsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetNetworkInsightsAccessScopeAnalysisFindingsPaginator is a paginator for
// GetNetworkInsightsAccessScopeAnalysisFindings
type GetNetworkInsightsAccessScopeAnalysisFindingsPaginator struct {
	options   GetNetworkInsightsAccessScopeAnalysisFindingsPaginatorOptions
	client    GetNetworkInsightsAccessScopeAnalysisFindingsAPIClient
	params    *GetNetworkInsightsAccessScopeAnalysisFindingsInput
	nextToken *string
	firstPage bool
}

// NewGetNetworkInsightsAccessScopeAnalysisFindingsPaginator returns a new
// GetNetworkInsightsAccessScopeAnalysisFindingsPaginator
func NewGetNetworkInsightsAccessScopeAnalysisFindingsPaginator(client GetNetworkInsightsAccessScopeAnalysisFindingsAPIClient, params *GetNetworkInsightsAccessScopeAnalysisFindingsInput, optFns ...func(*GetNetworkInsightsAccessScopeAnalysisFindingsPaginatorOptions)) *GetNetworkInsightsAccessScopeAnalysisFindingsPaginator {
	if params == nil {
		params = &GetNetworkInsightsAccessScopeAnalysisFindingsInput{}
	}

	options := GetNetworkInsightsAccessScopeAnalysisFindingsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetNetworkInsightsAccessScopeAnalysisFindingsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetNetworkInsightsAccessScopeAnalysisFindingsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetNetworkInsightsAccessScopeAnalysisFindings page.
func (p *GetNetworkInsightsAccessScopeAnalysisFindingsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetNetworkInsightsAccessScopeAnalysisFindingsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetNetworkInsightsAccessScopeAnalysisFindings(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetNetworkInsightsAccessScopeAnalysisFindingsAPIClient is a client that
// implements the GetNetworkInsightsAccessScopeAnalysisFindings operation.
type GetNetworkInsightsAccessScopeAnalysisFindingsAPIClient interface {
	GetNetworkInsightsAccessScopeAnalysisFindings(context.Context, *GetNetworkInsightsAccessScopeAnalysisFindingsInput, ...func(*Options)) (*GetNetworkInsightsAccessScopeAnalysisFindingsOutput, error)
}

var _ GetNetworkInsightsAccessScopeAnalysisFindingsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetNetworkInsightsAccessScopeAnalysisFindings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetNetworkInsightsAccessScopeAnalysisFindings",
	}
}
