---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations,
              numérotation des équations, numérotation, référence, \label, 
              \ref
---

# Comment afficher un second niveau de numérotation des équations ?

## Avec l'extension <ctanpkg:mathtools>

L'environnement `subequations` de l'extension <ctanpkg:mathtools> 
(ou <ctanpkg:amsmath>) permet de référencer différentes lignes 
d'un même groupe d'équations par des indices (3.a), (3.b), etc.

Cet environnement a deux particularités importantes :
- la commande `\\` incrémente le compteur des sous-références ;
- une référence à une ligne particulière s'obtient alors par un `\label` placé
  sur cette ligne alors qu'une référence au système d'équation s'obtient 
  par un `\label` placé immédiatement après `subequations`, comme le montre 
  l'exemple suivant.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{subequations} \label{E+gp}
  \begin{gather}
    x_1 x_2 + x_1^2 x_2^2 + x_3 = 1  \label{E+gp1} \\
    x_1 x_3 + x_1^2 x_3^2 + x_2 = 2  \label{E+gp2} \\
    x_1 x_2 x_3 = 0                  \label{E+gp3}
  \end{gather}
\end{subequations}

Voir le système~\ref{E+gp} et en particulier l'équation~\ref{E+gp3}.
\end{document}
```


## Avec l'extension <ctanpkg:subeqnarray> 

L'extension <ctanpkg:subeqnarray> permet d'obtenir un résultat similaire 
à celui de <ctanpkg:mathtools> avec son environnement `subeqnarray`. 
Cependant, avec <ctanpkg:subeqnarray>, une référence à une ligne particulière
se fait alors par `\slabel` au lieu de `\label`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{subeqnarray}

\begin{document}
\begin{subeqnarray} \label{E+gp}
  x_1 x_2 + x_1^2 x_2^2 + x_3 = 1  \slabel{E+gp1} \\
  x_1 x_3 + x_1^2 x_3^2 + x_2 = 2  \slabel{E+gp2} \\
  x_1 x_2 x_3 = 0                  \slabel{E+gp3}
\end{subeqnarray}
Voir le système~\ref{E+gp} et en particulier l'équation~\ref{E+gp3}.
\end{document}
```


## Avec l'extension <ctanpkg:deleq>

:::{warning}
L'extension <ctanpkg:deleq> date de la fin des années 90. 
Ce qui suit est informatif. 
:::

Cette extension permet de définir un label par groupe d'équations "(4)" 
en plus des labels individuels de type "(4a)", "(4b)", etc.