* PACKAGE XMKSST  !" SST κ
*
**************************************************************************
      PROGRAM MKSST
*
*   [PARAM] 
#if   SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻ, ȿ
      INCLUDE   (ZHDIM)                      !" ʸʸ
#else
#include        "zcdim.F"                    !" ʻ, ȿ
#include        "zhdim.F"                    !" ʸʸ
#endif
*
*"  [VAR] 
      REAL        GSST  ( IDIM , JDIM  )
      REAL        ALON  ( IDIM )
      REAL        ALAT  ( IDIM )
      REAL        SIG   ( KDIM )
      REAL        SIGM  ( KDIM+1 )
      REAL        DLON  ( IDIM )
      REAL        DLAT  ( IDIM )
      REAL        DSIG  ( KDIM )
      REAL        DSIGM ( KDIM+1 )
*
*   [INTERNAL PARM] 
      CHARACTER  HITEM*(NCC)
      CHARACTER  HTITL*(NCC)
      CHARACTER  HUNIT*(NCC)
      DATA       HITEM / 'GRSST' /
      DATA       HTITL / 'Sea Surface Temp.' /
      DATA       HUNIT / 'K' /
      INTEGER    IT
      INTEGER    IDATE(6)
      INTEGER    ISTEP
      INTEGER    ITDUR
      INTEGER    IOMODE
      INTEGER    NOEND
      DATA       IT    / 0 /
      DATA       IDATE / 1992, 3, 21, 0, 0, 0 /
      DATA       ISTEP  / 0 /
      DATA       ITDUR  / 1 /
      DATA       IOMODE / 1 /
      DATA       NOEND  / 0 /
*
      NAMELIST  /NMDATE/ IT, IDATE, ISTEP
*
      CHARACTER  DDSET *(NCC)
      DATA       DDSET / ' ' /
      CHARACTER  HDFMT *(NCC)
      DATA       HDFMT  / 'UR4' /
      REAL       TEQ
      REAL       ALAT0
      REAL       ALAT1
      REAL       ALPHA
      REAL       BETA
      REAL       GAMMA
      REAL       ALACON
      DATA       TEQ   , ALAT0, ALAT1, ALPHA,  BETA, GAMMA
     &         / 302.  ,  0.  , 30.  , 60.  , 32.  , 0.     /
      DATA       ALACON / 7.   /
*
      NAMELIST  /NMSST/ TEQ, ALAT0, ALAT1, ALPHA, BETA, GAMMA, ALACON
*
*   [INTERNAL WORK] 
      INTEGER    JFILE
*
      CALL YPREP
      CALL PCONST
      CALL GTOPEN
*
      WRITE ( 6,*      ) ' DATASET NAME? '
      READ  ( 5,'(A)'  ) DDSET
      CALL GFWOPQ ( JFILE, 'SST OUTPUT' )
*
      WRITE ( 6,NMSST  )
      WRITE ( 6,*      ) ' ENTER NAMELST NMSST?'
      READ  ( 5,NMSST,  END=1900  )
 1900 CONTINUE
      WRITE ( 6,NMDATE )
      WRITE ( 6,*      ) ' ENTER NAMELST NMDATE?'
      READ  ( 5,NMDATE, END=1910 )
 1910 CONTINUE
*
      CALL GTCSET( 'DDSET' , DDSET    )
*
      CALL SETCOR
     O         ( ALON  , DLON  ,
     O           ALAT  , DLAT  ,
     O           SIG   , DSIG  ,
     O           SIGM  , DSIGM  )
*
      CALL CALSST
     O         ( GSST  ,
     I           ALAT  ,
     I           TEQ   , ALAT0 , ALAT1 , ALPHA , BETA  , GAMMA ,
     I           ALACON,
     I           IDIM  , JDIM                                   )
*
      WRITE ( 6,* ) (GSST(1,J),J=1,JMAX)
*
      CALL GDWRIT
     O         ( GSST  ,
     I           HITEM , HTITL , HUNIT ,
     I           IT    , IDATE , ISTEP , ITDUR ,
     I           JFILE , IOMODE, NOEND , 'ASFC', HDFMT  )
*
      CALL YFINE
*
      STOP
      END
***********************************************************************
      SUBROUTINE CALSST        !" SST ׻
     O         ( GSST  ,
     I           ALAT  ,
     I           TEQ   , ALAT0 , ALAT1 , ALPHA , BETA  , GAMMA ,
     I           ALACON,
     I           IDIM  , JDIM                                   )
*
*     SST = SST ( TEQ-ALAT0, ALAT1, ALPHA, BETA, GAMMA )
*         -> ALAT0 +/- ALACON δ, ʿó
*
*   [PARAM] 
      INTEGER    IDIM, JDIM
*
*   [OUTPUT] 
      REAL       GSST  ( IDIM, JDIM )
*
*   [INPUT] 
      REAL       ALAT  ( JDIM )
      REAL       TEQ
      REAL       ALAT0
      REAL       ALAT1
      REAL       ALPHA
      REAL       BETA
      REAL       GAMMA
      REAL       ALACON
*
*   [INTERNAL WORK]       
      REAL       PI, PHI1, AB4, PHI, GSSTP, ALATP, ALATM, GSSTMX
      INTEGER    I, J, JP, JM
*
*" << CRSST : SSTη׻ >> 
*
      PI   = ATAN( 1. ) * 4.  
      PHI1 = ABS( ALAT1 * PI/180.   )
      AB4  = 2. *( PHI1**3 )*BETA/ALPHA
*
      DO 2100 J = 1, JDIM
*
         PHI   = ABS( ALAT( J ) - ALAT0 *PI/180. )
         GSSTP = TEQ
     &         - ALPHA/2.  
     &           * ( PHI - MAX(   SQRT(  PHI1**2     +AB4 )
     &                           -SQRT( (PHI-PHI1)**2+AB4 ), 0.   )  )
     &         + GAMMA *( PHI**3 )
*
         DO 2110 I = 1, IDIM
            GSST( I,J ) = GSSTP
 2110    CONTINUE
*
 2100 CONTINUE
*
*" << FIXSST : 濴+/-ALACONʿó >> 
*
      ALATP = ( ALAT0 + ALACON )*PI/180.  
      ALATM = ( ALAT0 - ALACON )*PI/180.  
*
      JP = 1
      JM = JDIM
      DO 2200 J = 1, JDIM
         IF ( ALAT( J ) .GT. ALATP ) THEN
            JP = J
         ENDIF
         IF ( ALAT( J ) .GE. ALATM ) THEN
            JM = J
         ENDIF
 2200 CONTINUE
*
      GSSTMX = (     GSST(1,JP) * ( ALATP - ALAT(JP+1))
     &            +  GSST(1,JP+1) * ( ALAT(JP) - ALATP ))
     &        /( ALAT(JP) - ALAT(JP+1) )
*
      DO 2500 J = JP+1, JM
         DO 2510 I = 1, IDIM
            GSST( I,J ) = GSSTMX
 2510    CONTINUE
 2500 CONTINUE
*
      RETURN
      END
