* PACKAGE BALOCLI  !"   βž 
*"                  ؤǹβžή   ꡣ
*
*"  [HIS]   93/09/18 Ƿ
**********************************************************************
      SUBROUTINE INISET               !" 
     O         ( GAU   , GAV   , GAT   , GAPS  , GAQ   ,
     I           DUM1  , DUM2  , ALAT  , DUM3  ,
     I           SIG   , DUM4  , SIGM  , DUM5  )
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻ, ȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻ, ȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [OUTPUT] 
      REAL       GAU   ( IDIM, JDIM, KMAX ),
     &           GAV   ( IDIM, JDIM, KMAX ),
     &           GAT   ( IDIM, JDIM, KMAX ),
     &           GAPS  ( IDIM, JDIM       )
      REAL       GAQ   ( IDIM, JDIM, KMAX )
*
*   [INPUT]
      REAL       SIG   ( KMAX )           !" ҥ٥()
      REAL       SIGM  (KMAX+1)           !" ҥ٥(Ⱦ)
      REAL       ALAT  ( JDIM )           !" 
      REAL       DUM1,DUM2,DUM3,DUM4,DUM5 !" ߡ

*   [INTERNAL PARM] 
      REAL       TB ( KMAX )              !" ܲ(٥ʿ)
      REAL       TB1,TB2                  !" ܲ at =1,kmax
      DATA       TB1,TB2 / 280. , 220. /
      REAL       U0 ( KMAX )              !" ƻǤ®
      REAL       U01,U02                  !" Ʊ     at =1,kmax
      DATA       U01,U02 / 0. , 50. /
      REAL       PS0                      !"  Ps (hPa)
      DATA       PS0         / 1000. /
      REAL       SALPHA( KMAX )           !" ſ尵μη 
      REAL       SBETA ( KMAX )           !" ſ尵μη 
      REAL       OMEGA 
      SAVE
*
*   [INTERNAL WORK] 
      REAL       C ( JDIM )               !" COS(  )
      REAL       S ( JDIM )               !" SIN(  )
      REAL       TW( KMAX )               !" ٤ʬη
*
      CALL PCONST        !" ɸʪ(ǥե) 
      OMEGA = 2 * 3.141593 / 86400.
*
      DO 10 J=1,JDIM
        C( J ) = COS( ALAT(J) )
        S( J ) = SIN( ALAT(J) )
   10 CONTINUE
*
      DO 20 K=1,KMAX
        U0( K ) = U01 + (U02-U01) * ( 1-SIG(K) ) / ( 1 - SIG(KMAX) )
        TB( K ) = TB1 + (TB2-TB1) * ( 1-SIG(K) ) / ( 1 - SIG(KMAX) )
   20 CONTINUE
*
      DO 100 K = 1,KMAX 
      DO 100 J = 1,JDIM
      DO 100 I = 1,IDIM
        GAU( I, J, K ) = U0( K ) * C( J ) 
        GAV( I, J, K ) = 0
  100 CONTINUE
*
      IF (  U01 .NE. 0 ) THEN
        WRITE(6,*) '(INISET) U01 MUST BE ZERO'
        STOP
      ENDIF
      DO 120 J = 1,JDIM
      DO 120 I = 1,IDIM
        GAPS( I, J ) = PS0
  120 CONTINUE
*
      CALL HYDROS         !" ſ尵η(dynamics/dhydr.F)
     I         ( SIG   , SIGM  )
      CALL HYDROQ         !" ſ尵ηλ(dynamics/dhydr.F)
     O         ( SALPHA, SBETA )
*
      TW ( 1 ) = U0(1)/CP/SALPHA(1)
      DO 140 K = 2,KMAX
        TW ( K ) = ( U0(K)-U0(K-1) )/CP/SALPHA(K)
     &             - TW(K-1)*SBETA(K-1)/SALPHA(K)
  140 CONTINUE
*
      DO 160 K = 1,KMAX 
      DO 160 J = 1,JDIM
      DO 160 I = 1,IDIM
        GAT( I, J, K ) =  TB(K) + OMEGA*ER* ( 1./3 - S(J)**2 ) * TW(K)
  160 CONTINUE
*
      CALL JOURAN         !" 
     M       ( GAU, GAV )
*
      RETURN
      END
************************************************************************
*" (Legendreʬͥ륮, ࡿäƤ)
*
      SUBROUTINE JOURAN
     M       ( GAU, GAV )         !" 
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻ, ȿ
#else
#include        "zcdim.F"                    !" ʻ, ȿ
#endif
*
*   [MODIFY] 
      REAL       GAU   ( IDIM, JDIM, KMAX ),
     &           GAV   ( IDIM, JDIM, KMAX )
*
*   [INTERNAL PARAM] 
      INTEGER    MMN,MMX, LMN,LMX
**      DATA       MMN,MMX, LMN,LMX/ 1,MMAX-4, 0,3 /
      REAL       UORDER   !" ʬ SQRT(2*ENRGY) : ȯʬʤΤ
*"                        !  Potential EnergyϣǤ뤳Ȥ
      DATA       UORDER/ 0.001 /
      SAVE
*
*   [INTERNAL WORK] 
      REAL       WDPSI( NMDIM , KMAX ) !" ήؿ /ER (m/s)
      INTEGER    NMO   ( 2, 0:MMAX, 0:LMAX ) !" ڥȥź
*
*   [CONSTS]
      MMN = 1
      MMX = MMAX-3
      LMN = 0
      LMX = LMAX 

      CALL LTINIT
      CALL LTGET
     I       ( 'NMO', 2*(MMAX+1)*(LMAX+1),
     O          NMO  )
*
      DO 100 K = 1, KMAX
      DO 100 M = MMN,MMX
      DO 100 L = LMN,LMX
        IF ( NMO(1,M,L).NE.0 .AND. NMO(2,M,L).NE.0 ) THEN
          AR = SIN( 1. * (L+1) * M ) !" ХХˤ롣
          AI = COS( 1. * (L+1) * M ) !" ХХˤ롣
**          AR = 1                     !" 򤽤롣
**          AI = 0                     !" 򤽤롣
          N  =  M + L
          C  =  1./SQRT( 1.* N*(N+1) )
          WDPSI( NMO(1,M,L) , K ) = AR * C * UORDER
          WDPSI( NMO(2,M,L) , K ) = AI * C * UORDER
        ENDIF
  100 CONTINUE
*
      CALL W2G
     O         ( GAU   ,
     I           WDPSI ,
     I           'YGRA', 'SUB ', KMAX )
*
      IF ( MMAX .GE. 1 ) THEN
         CALL W2G
     O         ( GAV   ,
     I           WDPSI ,
     I           'XGRA', 'ADD ', KMAX )
      ENDIF
*
      RETURN
      END
