************************************************************************
*     CALCULATE NONLINEAR TERM                                  96/10/26
************************************************************************
      SUBROUTINE N2AJBS(LM,KM,JM,IM,Z,DZ,WS,WG,ITJ,TJ,ITI,TI)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Z(-LM:LM,-KM:KM)
      DIMENSION DZ(-LM:LM,-KM:KM)
      DIMENSION WS(-LM:LM,-KM:KM)
      DIMENSION WG(JM*IM,3)
      DIMENSION ITJ(5),TJ(JM*2),ITI(5),TI(IM*2)

      DO K=-KM,KM
        DO L=-LM,LM
          DZ(L,K)=-(K*K+L*L)
        END DO
      END DO
      DZ(0,0)=1

      DO K=-KM,KM
        DO L=-LM,LM
          DZ(L,K)=Z(L,K)/DZ(L,K)
        END DO
      END DO

* CALCULATE V COMPONENT

      DO K=-KM,KM
        DO L=-LM,LM
          WS(L,K)=-K*DZ(-L,-K)
        END DO
      END DO

      CALL N2S2GA(LM,KM,JM,IM,WS,WG(1,1),WG(1,3),ITJ,TJ,ITI,TI)

* CALCULATE U COMPONENT

      DO K=-KM,KM
        DO L=-LM,LM
          WS(L,K)=L*DZ(-L,-K)
        END DO
      END DO

      CALL N2S2GA(LM,KM,JM,IM,WS,WG(1,2),WG(1,3),ITJ,TJ,ITI,TI)

      DO JI=1,JM*IM
        WG(JI,3)=WG(JI,1)*WG(JI,1)-WG(JI,2)*WG(JI,2)
        WG(JI,2)=WG(JI,1)*WG(JI,2)
      END DO

      CALL N2G2SA(LM,KM,JM,IM,WG(1,3),WS,WG,ITJ,TJ,ITI,TI)
      CALL N2G2SA(LM,KM,JM,IM,WG(1,2),DZ,WG,ITJ,TJ,ITI,TI)

      DO K=-KM,KM
        DO L=-LM,LM
          DZ(L,K)=(K*K-L*L)*DZ(L,K)+K*L*WS(L,K)
        END DO
      END DO

      END
