************************************************************************
*     TIME-INTEGRATION BY RUNGE-KUTTA (2) METHOD     95/10/25 K.ISHIOIKA
************************************************************************
      SUBROUTINE TDRK2U(N,M,H,X,Y,W,SUB)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Y(N),W(N,2)
      EXTERNAL SUB

      DX=H/M

      DO I=1,M
        CALL TDRK2L(N,DX,X,Y,W,SUB)
      END DO

      END
************************************************************************
      SUBROUTINE TDRK2L(N,DX,X,Y,W,SUB)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Y(N),W(N,2)
      EXTERNAL SUB

      CALL SUB(X,Y,W(1,1))
      DO I=1,N
        W(I,2)=Y(I)+(DX/2)*W(I,1)
        Y(I)=Y(I)+DX*W(I,1)
      END DO

      X=X+DX
      CALL SUB(X,Y,W(1,1))
      DO I=1,N
        Y(I)=W(I,2)+(DX/2)*W(I,1)
      END DO

      END
