************************************************************************
*     TIME-INTEGRATION BY RUNGE-KUTTA (4) METHOD     95/10/13 K.ISHIOIKA
************************************************************************
      SUBROUTINE TDRK4U(N,M,H,X,Y,W,SUB)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Y(N),W(N,3)
      EXTERNAL SUB

      DX=H/M

      DO I=1,M
        CALL TDRK4L(N,DX,X,Y,W,SUB)
      END DO

      END
************************************************************************
      SUBROUTINE TDRK4L(N,DX,X,Y,W,SUB)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Y(N),W(N,3)
      EXTERNAL SUB

      CALL SUB(X,Y,W(1,1))
      DO I=1,N
        W(I,3)=Y(I)+(DX/2)*W(I,1)
      END DO

      X=X+DX/2
      CALL SUB(X,W(1,3),W(1,2))
      DO I=1,N
        W(I,3)=Y(I)+(DX/2)*W(I,2)
        W(I,1)=W(I,1)+2*W(I,2)
      END DO

      CALL SUB(X,W(1,3),W(1,2))
      DO I=1,N
        W(I,3)=Y(I)+DX*W(I,2)
        W(I,1)=W(I,1)+2*W(I,2)
      END DO

      X=X+DX/2
      CALL SUB(X,W(1,3),W(1,2))
      DO I=1,N
        Y(I)=Y(I)+(DX/6)*(W(I,1)+W(I,2))
      END DO

      END
