*"$@I=Bj(J   $@6&DL(J $@Dj?t(J($@&R:BI8CM(J) GCM5(ASETS)
*
*"$@MzNr(J   90/05/19 $@>B8}(J  $@FX(J
*"       90/11/15 $@>B8}(J  $@FX(J
*"       92/02/06 $@C]9-??0l(J  Sun Fortran Version, barotropic $@DI2C(J
*
***********************************************************************
*"          << $@&R%l%Y%k(J >>
***********************************************************************
      SUBROUTINE SETSIG
     O         ( SIG   , DSIG  , HASIG ,
     O           SIGM  , DSIGM , HASIGM,
     D           KMAX  , KDIM            )
*
*"                (*  Arakawa & Suarez $@1tD>:9J,(J $@&R:BI8(J *)
*
#if   HITAC
      INCLUDE   (ZCCOM)                      !" $@I8=`J*M}Dj?t(J
#elif SX3
      INCLUDE   "zccom.F"                    !" $@I8=`J*M}Dj?t(J
#else
#include        "zccom.F"                    !" $@I8=`J*M}Dj?t(J
#endif
*
      REAL       SIG   ( KDIM )              !" $@&R%l%Y%k(J($@@0?t(J)
      REAL       SIGM  (KDIM+1)              !" $@&R%l%Y%k(J($@H>@0?t(J)
      REAL       DSIG  ( KDIM )              !" $@&$&R(J($@@0?t(J)
      REAL       DSIGM (KDIM+1)              !" $@&$&R(J($@H>@0?t(J)
      CHARACTER  HASIG  *(*)                 !" $@1tD><4L>>N!'@0?t(J
      CHARACTER  HASIGM *(*)                 !" $@1tD><4L>>N!'H>@0?t(J
*
      REAL       AKAPPA                      !" $@&J(J= $@#R!?#C(Jp
*
*"          < 1. $@&R(J($@H>@0?t(J) >
*
      CALL SETSGM
     O         ( SIGM  , HASIG , HASIGM ,
     I           KMAX                    )
*
*"          < 2. $@&R(J, $@&$&R$N7W;;(J >
*
      AKAPPA = RAIR / CP
*
      DO 3100 K = 1 , KMAX
*
        DSIG  ( K ) =   SIGM ( K ) - SIGM ( K+1 )
*
        SIG   ( K ) = (    (   SIGM ( K   )**( 1.+ AKAPPA )
     &                       - SIGM ( K+1 )**( 1.+ AKAPPA )  )
     &                   / (   DSIG ( K ) *  ( 1.+ AKAPPA )  )
     &                 )
     &                  **( 1./AKAPPA )
*
 3100 CONTINUE
*
      DO 3200 K = 2, KMAX
          DSIGM ( K ) = SIG ( K-1 ) - SIG ( K )
 3200 CONTINUE
      DSIGM ( 1      ) = SIGM( 1    ) - SIG ( 1      )
      DSIGM ( KMAX+1 ) = SIG ( KMAX ) - SIGM( KMAX+1 )
*
      RETURN
      END
************************************************************************
*"          << $@&R%l%Y%k(J($@H>@0?t(J) >>
************************************************************************
      SUBROUTINE SETSGM
     O         ( SIGMX , HASIGX , HASIMX,
     I           KMAX                     )
*
      REAL       SIGMX (KMAX+1)              !" $@&R%l%Y%k(J($@H>@0?t(J)
      CHARACTER  HASIGX *(*)                 !" $@Bh(J3$@<4L>>N!'@0?t(J
      CHARACTER  HASIMX *(*)                 !" $@Bh(J3$@<4L>>N!'H>@0?t(J
*
#if   HITAC
      INCLUDE   (ZHDIM)
#elif SX3
      INCLUDE   "zhdim.F"
#else
#include        "zhdim.F"
#endif
      PARAMETER ( KDIMD=100 )
      REAL       SIGM  ( KDIMD )
*
*
      PARAMETER  ( KM0=1 )
      REAL       SIGM0 ( KM0+1 )
      DATA       SIGM0 / 1.000, 0.000                       /
      PARAMETER  ( KM1=12 )
      REAL       SIGM1 ( KM1+1 )
      DATA       SIGM1 / 1.000, 0.970, 0.920, 0.850, 0.770,
     &                   0.640, 0.500, 0.360, 0.260, 0.180,
     &                   0.110, 0.050, 0.000                /
      PARAMETER  ( KM2=16 )
      REAL       SIGM2 ( KM2+1 )
      DATA       SIGM2 / 1.000, 0.990, 0.970, 0.930, 0.870,
     &                   0.790, 0.700, 0.600, 0.500, 0.410,
     &                   0.330, 0.260, 0.200, 0.150, 0.100,
     &                   0.050, 0.000                       /
      PARAMETER  ( KM3=23 )
      REAL       SIGM3 ( KM3+1 )
      DATA       SIGM3 / 1.000, 0.990, 0.980, 0.965, 0.945,
     &                   0.920, 0.890, 0.850, 0.800, 0.740,
     &                   0.650, 0.550, 0.450, 0.360, 0.300,
     &                   0.260, 0.220, 0.180, 0.150, 0.120,
     &                   0.090, 0.060, 0.030, 0.000        /
*
      CHARACTER  HASIG1 *(NCC)
      DATA       HASIG1 / 'GSIG'  /
*
      WRITE ( 6,* ) ' SIGMA LEVEL GSIG A2.1 DATE=91/01/16'
*
*"          < 1. $@%G%U%)%k%HCM(J >
*
      IF      ( KMAX .EQ. KM0 ) THEN
         CALL COPY  ( SIGM, SIGM0, KM0+1 )
      ElSE IF ( KMAX .EQ. KM1 ) THEN
         CALL COPY  ( SIGM, SIGM1, KM1+1 )
      ELSE IF ( KMAX .EQ. KM2 ) THEN
         CALL COPY  ( SIGM, SIGM2, KM2+1 )
      ELSE IF ( KMAX .EQ. KM3 ) THEN
         CALL COPY  ( SIGM, SIGM3, KM3+1 )
      ELSE
         CALL MSGDMP( 'E', 'SETSGM', 'LEVEL NOT DEFINED' )
      ENDIF
*
      CALL       SETSIX
     M         ( SIGM  ,
     O           HASIGX, HASIMX,
     I           HASIG1, KMAX   )
*
      CALL COPY ( SIGMX, SIGM, KMAX+1 )
*
      RETURN
*--------------------------------------------------------------------
      ENTRY      STNSIG
     O         ( HASIGX, HASIMX ,
     I           KMAX             )
*
      CALL       SETSIX
     M         ( SIGM  ,
     O           HASIGX, HASIMX,
     I           HASIG1, KMAX   )
*
      RETURN
      END
*====================================================================
      SUBROUTINE SETSIX
     M         ( SIGMX ,
     O           HASIGX, HASIMX,
     I           HASIG1, KMAX   )
*
      CHARACTER  HASIGX *(*)                 !" $@Bh(J3$@<4L>>N!'@0?t(J
      CHARACTER  HASIMX *(*)                 !" $@Bh(J3$@<4L>>N!'H>@0?t(J
      CHARACTER  HASIG1 *(*)                 !" $@Bh(J3$@<4L>>N(J
*
#if   HITAC
      INCLUDE   (ZHDIM)
#elif SX3
      INCLUDE   "zhdim.F"
#else
#include        "zhdim.F"
#endif
      PARAMETER ( KDIMD=100 )
      CHARACTER  HASIG  *(NCC)
      CHARACTER  HASIGM *(NCC)
      REAL       SIGM  ( KDIMD ), SIGMX  ( KDIMD )
*
      NAMELIST  /NMSIGM/ SIGM, HASIG , HASIGM
*
      CHARACTER  HASI0Z *(NCC)
      CHARACTER  HNUM   *(NCC)
*
*"          < 1. $@L>>N%;%C%H(J >
*
      CALL COPY
     O        ( SIGM   ,
     I          SIGMX  ,
     D          KDIMD     )
*
      CALL GULCHR
     I     ( '(I4)', KMAX  ,
     O       HNUM  , INUM   )
*
      HASI0Z = HASIG1
*
      IAZ    = LENC( HASI0Z )
      HASIG  = HASI0Z(1:IAZ)//HNUM(1:INUM)//'.P'
      HASIGM = HASI0Z(1:IAZ)//HNUM(1:INUM)//'.M'
      HASIG  = HASI0Z(1:IAZ)//'.P'
      HASIGM = HASI0Z(1:IAZ)//'.M'
*
*"          < 2. NAMELIST $@FI$_9~$_(J >
*
      WRITE ( 6,* ) ' CONTROL PARAMETER NMSIGM: '
*
      CALL   REWNML ( IFPAR , JFPAR )
      READ   ( IFPAR, NMSIGM, END=2190 )
 2190 WRITE  ( JFPAR, NMSIGM )
*
      HASIGX = HASIG
      HASIMX = HASIGM
*
      CALL COPY
     O        ( SIGMX  ,
     I          SIGM   ,
     D          KDIMD     )
*
      RETURN
      END
