# Indie Wiki Buddy

Indie Wiki Buddy is a browser extension that automatically notifies and redirects you from wikis on large, corporate-run wiki farms to independent wikis.

* Learn more at [getindie.wiki](https://getindie.wiki/).
* [Download for Firefox](https://addons.mozilla.org/en-US/firefox/addon/indie-wiki-buddy/)
* [Download for Chrome](https://chrome.google.com/webstore/detail/indie-wiki-buddy/fkagelmloambgokoeokbpihmgpkbgbfm)

![DE wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=DE%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesDE.json)
![EN wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=EN%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesEN.json)
![ES wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=ES%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesES.json)
![FI wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=FI%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesFI.json)
![FR wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=FR%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesFR.json)
![HU wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=HU%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesHU.json)
![IT wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=IT%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesIT.json)
![JA wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=JA%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesJA.json)
![KO wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=KO%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesKO.json)
![LZH wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=LZH%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesLZH.json)
![PL wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=PL%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesPL.json)
![PT wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=PT%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesPT.json)
![RU wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=RU%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesRU.json)
![SV wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=SV%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesSV.json)
![TH wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=TH%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesTH.json)
![TOK wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=TOK%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesTOK.json)
![UK wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=UK%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesUK.json)
![ZH wikis](https://img.shields.io/badge/dynamic/json?style=flat-square&label=ZH%20wikis&query=length&url=https%3A%2F%2Fraw.githubusercontent.com%2FKevinPayravi%2Findie-wiki-buddy%2Fmain%2Fdata%2FsitesZH.json)

![Mozilla Add-on](https://img.shields.io/amo/v/indie-wiki-buddy?style=flat-square&color=%23cb553f&label=firefox%20version&logo=firefox)
![Mozilla Add-on](https://img.shields.io/amo/users/indie-wiki-buddy?style=flat-square&color=%23cb553f&label=firefox%20downloads&logo=firefox)
![Mozilla Add-on](https://img.shields.io/amo/stars/indie-wiki-buddy?style=flat-square&color=%23cb553f&label=firefox%20rating&logo=firefox)

![Chrome Web Store](https://img.shields.io/chrome-web-store/v/fkagelmloambgokoeokbpihmgpkbgbfm?style=flat-square&color=%234285f4&label=chrome%20version&logo=google-chrome)
![Chrome Web Store](https://img.shields.io/chrome-web-store/users/fkagelmloambgokoeokbpihmgpkbgbfm?style=flat-square&color=%234285f4&label=chrome%20downloads&logo=googlechrome)
![Chrome Web Store](https://img.shields.io/chrome-web-store/stars/fkagelmloambgokoeokbpihmgpkbgbfm?style=flat-square&color=%234285f4&label=chrome%20rating&logo=googlechrome)

----

Large, corporate-run wiki farms have enabled hundreds of great wikis and communities. Unfortunately, these wiki farms can easily overshadow quality independent wikis, especially in search engine results. Independent wikis often have the benefit of greater self-determination and fewer ads, but are easily missed by users who aren't aware of their existence.

When visiting a wiki on a large corporate wiki farm such as Fandom, Indie Wiki Buddy will notify and/or automatically redirect you if a quality, independent alternative is available. You can customize your experience per-wiki.

In addition, search results in Google, Bing, DuckDuckGo, Brave, Ecosia, Kagi, Qwant, Startpage, Yahoo!, and Yandex can also be filtered, replacing non-independent wikis with text inviting you to visit the independent counterpart.

Indie Wiki Buddy also supports [BreezeWiki](https://breezewiki.com/), a service that renders Fandom wikis without ads or bloat. This helps give you a more enjoyable reading experience on Fandom when an independent wiki isn't available.

# Adding wikis

Contributions are welcome and encouraged! You can either open a pull request to add a new wiki, or [open an issue](https://github.com/KevinPayravi/indie-wiki-buddy/issues/new?assignees=KevinPayravi&labels=add+wiki&template=request-a-wiki-be-added.md&title=Add+a+wiki%3A+WIKI+NAME).

## Criteria for inclusion
* The wiki should be editable by the public (that's what makes a wiki a wiki!)
* The destination wiki should be independent, meaning that decision-making and control of the wiki largely rests with the wiki's staff and volunteer editing community.
  * Factors include editorial independence, the editorbase's ability to request changes from their host, and any history of the host exerting decisions contrary to a wiki community's wishes.
  * Large hosts such as Miraheze and Wiki.gg may be considered less independent, but are included as they are community-friendly hosts, provide decent levels of control, and are popular destinations for forking wikis.
* The destination wiki should be of decent quality, ideally matching (or exceeding) the quality and size of the origin wiki. While we want to support all independent wikis, we also want extension users to be directed to wikis where they can find what they are looking for.
* When there are multiple independent wikis on the same subject, we will usually point to the wiki that is most complete and prominent in the community.

## Data
Wiki data is located in JSON files in the [data](data) folder, one file per language.

Entries are formatted as follows:
```
{
  "id": "en-example",
  "origins_label": "Example Fandom Wiki",
  "origins": [
    {
      "origin": "Example Fandom Wiki",
      "origin_base_url": "example.fandom.com",
      "origin_content_path": "/wiki/",
      "origin_main_page": "Example_Wiki"
    }
  ],
  "destination": "Example Wiki",
  "destination_base_url": "example.com",
  "destination_platform": "mediawiki",
  "destination_icon": "example.png",
  "destination_main_page": "Main_Page",
  "destination_search_path": "/index.php",
  "destination_content_path": "/wiki/",
  "destination_host": "wiki.gg",
  "tags": [
    "official"
  ]
}
```

* `id`: A unique identifier for the wiki; should start with the (usually two-letter) language code for the wiki, followed by a hyphen and the name of the subject/franchise the wiki covers.
* `origins_label`: A label that is shown to the user, identifying the non-indie wiki(s). This is usually just the name of the non-indie wiki, but in the case of multiple non-indie wikis, it may be something like "Example Fandom Wikis" (plural).
* `origins`: An array of wikis being redirected to the destination wiki. The vast majority of the time, there is just one wiki here. There may be multiple when a series has multiple wikis that combined into one destination wiki, when a Fandom wiki has archived alternatives, or when there are multiple non-independent wikis across multiple wiki farms.
* `origin`: Name of the wiki being redirected.
* `origin_base_url`: Fully qualified domain name of the wiki being redirected. Do not include `https://` or `http://`. For non-English Fandom wikis, this also needs to include the language portion of the URL (e.g. `example.fandom.com/fr`).
* `origin_content_path`: The URL path prefix for article links on the wiki being redirected. On MediaWiki wikis, it is listed on Special:Version as the article path. For Fandom wikis it will be `/wiki/`.
* `origin_main_page`: The title of the wiki being redirected's main page. This is used to ensure it redirects to the destination wiki's main page even if their titles differ.
* `destination`: Name of the wiki being redirected to.
* `destination_base_url`: Fully qualified domain name of the wiki being redirected to. Do not include `https://` or `http://`.
* `destination_content_prefix`: A prefix that is prepended to article names before performing a search on the destination wiki. This can be useful if a wiki separates its content into different namespaces. For example, to redirect a wiki about _The Elder Scrolls V: Skyrim_ to a general Elder Scrolls wiki that has _Skyrim_ content in a namespace called `Skyrim`, set `destination_content_prefix` to `Skyrim:`. If this is not applicable, omit this property.
* `destination_content_suffix`: A suffix that is added to the end of article names before performing a search on the destination wiki. This is typically used when a multilingual wiki separates its languages by suffixes (e.g. `/es`, `/pt`, etc.). Team Fortress Wiki is an example that uses this. If this is not applicable, omit this property.
* `destination_platform`: The wiki software used by the wiki being redirected to. The currently supported options are `mediawiki`, `dokuwiki`, and `moinmoin`. If you are contributing a redirect to a wiki that is on another wiki platform, please open an issue so that support for the platform can be added.
* `destination_icon`: The name of the favicon in the [favicons](favicons) folder for the wiki being redirected to.
* `destination_main_page`: The title of the main page of the wiki being redirected to.
* `destination_search_path`: The URL path prefix for performing searches on the wiki being redirected to. On MediaWiki wikis, it is listed on Special:Version as the index.php entry point.
* `destination_content_path`: The URL path prefix for article links on the wiki being redirected to. On MediaWiki wikis, it is listed on Special:Version as the article path.
* `destination_host`: The host of the wiki being redirected to, if it is hosted by a large wiki host (e.g. wiki.gg, Miraheze). If the wiki is hosted independently, omit this property.
* `tags`: An optional array of tags. Currently only `official` is used, to mark wikis officially endorsed by the subject of the wiki. If there are no tags, omit this property.

Favicons should be uploaded as 16px PNGs inside the [favicons](favicons) folder.
