/*
 *  JGlib0.h  - Header file for JGlib for JG Font
 *
 *  Programmmed by Hideo "Sir MaNMOS (and H.Kakugawa)
 *
 *  Edition History
 *  10 June 1993
 *
 */


/* This is a part of JGlib
 *
 * Copyright (C) 1993 Hideo "Sir MaNMOS and Hirotsugu Kakugawa.  
 * All rights reserved.
 *
 * JGlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * JGlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with JGlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */


#if	0
#define MAX_VALUE 0x3ff
#else
#define MAX_VALUE 0xfff
#endif

typedef char    *BUFFER;
typedef double  floatp;

typedef struct
{
  int x, y;
  int	xm,ym;
} Point;

typedef struct CYCLE
{
  struct CYCLE *next;
  Point point;
} Cycle;

typedef struct FONT
{
  struct FONT *next;
  Cycle *cycle;
} Font;

typedef union FREE
{
  union FREE *next;
  Cycle cycle;
  Font font;
} Free;

#define CODE_SIZE 4418
#define CODE_SIZE0 0x582
#define CODE_SIZE1 0xbc0
#define CODE_SIZE2 4418

typedef struct
{
  unsigned char dummy[8];
  unsigned long offsets[CODE_SIZE];
} Zs_Header;

/* #define Zs0_Header_SIZE (2 + (CODE_SIZE) * 4) */
#define Zs0_Header_SIZE 0x17c2
#define Zs1_Header_SIZE 0x30ba
#define Zs2_Header_SIZE 0x3812
