/*
 *  ZFlib0.h  - Header file for ZFlib for Zeit Vector font
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 *  Edition History
 *  13 Mar. 1993
 *
 */


/* This is a part of ZFlib
 *
 * Copyright (C) 1993 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * ZFlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * ZFlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with ZFlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */



#define MAX_VALUE 0x3ff

typedef char    *BUFFER;
typedef double  floatp;

typedef struct
{
  int x, y;
} Point;

typedef struct CYCLE
{
  struct CYCLE *next;
  Point point;
} Cycle;

typedef struct FONT
{
  struct FONT *next;
  Cycle *cycle;
} Font;

typedef union FREE
{
  union FREE *next;
  Cycle cycle;
  Font font;
} Free;

#define CODE_SIZE 4418

typedef struct
{
  unsigned char dummy[2];
  unsigned long offsets[CODE_SIZE];
} Zs_Header;

#define Zs_Header_SIZE (2 + (CODE_SIZE) * 4)
