/*
 *	gs-view.c
 *
 *		Revision 1.4  1992/09/16  04:42:23  hiro@jaist-east.ac.jp
 *		Revision 1.4a 1993/09/02  23:12:34  miyu@ftp.tohoku.ac.jp
 */

#include <stdio.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>

#include "xdvi.h"
#include "gs-view.h"

#include <fcntl.h>
#include <sys/stat.h>

#include <signal.h>

#ifndef	SIGCHLD
#define	SIGCHLD	SIGCLD
#endif

#ifdef	SIGNALRETURNSINT
#define	SIGVAL	int
#else
#define	SIGVAL	void
#endif

extern	int	errno;

#ifndef	SEEK_SET
#define	SEEK_SET	0
#endif

#ifndef	GHOSTSCRIPT
#define	GHOSTSCRIPT	"gs"
#endif

#define	DEV_NULL	"/dev/null"

struct gs_prop {
	Window	parent;
	Atom	GS_DONE;
	Atom	GS_PAGE;
};

int
round(x)
	float x;
{
	if (x > 0)
	    return (int) (x + 0.5);
	else
	    return (int) (x - 0.5);
/*
	if (x > 0)
	    return (int) (x + ( 1 - (int)  0.5) / 2.0);
	else
	    return (int) (x + (-1 - (int) -0.5) / 2.0);
 */
}

static	jmp_buf	abort_gs;

static	SIGVAL
catch_sig_child()
{
	/* longjmp(abort_gs, SIGCHLD); */
#ifdef	SIGNALRETURNSINT
	return 0;
#endif
}

static	SIGVAL
catch_sig_user1()
{
	longjmp(abort_gs, SIGUSR1);
	/*NOTREACHED*/
}

static	Boolean
check_gs_event(disp, event, props)
	Display	*disp;
	XEvent	*event;
	struct gs_prop	*props;
{
	if (event->type               == ClientMessage  &&
	    event->xclient.window     == props-> parent &&
	    event->xclient.send_event == TRUE) {
#ifdef	DEBUG_XDVI_PS
		Printf("caught ClientMessage event\n");
#endif
	    if (event->xclient.message_type == props->GS_DONE ||
		event->xclient.message_type == props->GS_PAGE)
		    return TRUE;
	}
	else
	    return FALSE;
}

int
psfig_to_bitmap(gs)
	struct gs_info	*gs;
{
	char	param[BUFSIZ];
	SIGVAL	(*old_sigchld)(), (*old_sigusr1)();

	Sprintf(param, "0 0 %d %d %d %d %f %f 0 0 0 0 %d %d",
		round(gs->llx ), round(gs->lly ),
		round(gs->urx ), round(gs->ury ),
		gs->width  / ((gs->urx - gs->llx) / 72.0),
		gs->height / ((gs->ury - gs->lly) / 72.0),
		gs->width, gs->height);
	XChangeProperty(gs->disp, gs->parent,
			XInternAtom(gs->disp, "GHOSTVIEW", FALSE), XA_STRING,
			8, PropModeReplace, param, strlen(param));

#ifdef	DEBUG
	Printf("property:%s\n", param);
#endif

#ifdef	PS_LITERAL
	fflush(temp_ps_file);
	lseek(fileno(temp_ps_file), 0L, SEEK_SET);
#endif	/* PS_LITERAL */

	{
	    int val;

	    val = setjmp(abort_gs);
	    if (val == SIGUSR1) {
		Fprintf(stderr, "GS terminated abnormally.\n");
		wait(NULL);
#ifdef	PS_LITERAL
		temp_ps_flush();
#endif	/* PS_LITERAL */
		return 1;
	    }
	}

	old_sigchld = signal(SIGCHLD, catch_sig_child);
	old_sigusr1 = signal(SIGUSR1, catch_sig_user1);

	if ((gs->gs_pid = fork()) == 0) {
	    /* child */
	    static char	env[BUFSIZ];
	    char	**argv;
	    int	i;
	    struct font	*fontp;
#ifdef	PS_HEADER
	    struct ps_hdr	*p;
#endif	/* PS_HEADER */

	    Sprintf(env, "DISPLAY=%s", XDisplayString(gs->disp));
	    putEnv(strDup(env));
	    Sprintf(env, "GHOSTVIEW=%d %d", gs->parent, gs->pix);
	    putEnv(strDup(env));

#ifdef	DEBUG
	    Printf("getenv:%s\n", getenv("DISPLAY"));
	    Printf("getenv:%s\n", getenv("GHOSTVIEW"));
#endif

	    close(fileno(stdin));
	    errno = 0;
#ifdef	PS_LITERAL
	    if (dup(fileno(temp_ps_file)) != fileno(stdin)) {
#else
	    if (open(DEV_NULL, O_RDONLY) != fileno(stdin)) {
#endif	/* PS_LITERAL */
		perror("Cound not redirect stdin");
		goto gs_exec_error;
	    }

	    close(fileno(stdout));
	    errno = 0;
	    if (open(DEV_NULL, O_WRONLY, 0777) != fileno(stdout)) {
		perror("Cound not redirect stdout");
		goto gs_exec_error;
	    }

	    for (fontp = font_head; fontp != NULL; fontp = fontp->next)
		if (fontp->file != NULL) {
		    Fclose(fontp->file);
		    fontp->file = NULL;
		    ++n_files_left;
		}

	    i = 0;
#ifdef	PS_HEADER
	    for (p = ps_headers; p != NULL; p = p->next)
		i++;
#endif	/* PS_HEADER */
	    argv = (char **) xmalloc(sizeof(char *) * (i + 7), "gs");
	    if (argv == NULL)
		goto gs_exec_error;

	    i = 0;
	    argv[i++] = GHOSTSCRIPT;
	    argv[i++] = "-dQUIET";
	    argv[i++] = "-dNOPAUSE";
#ifdef	PS_HEADER
	    for (p = ps_headers; p != NULL; p = p->next)
		argv[i++] = p->psheader;
#endif	/* PS_HEADER */
	    argv[i++] = "-";
	    argv[i++] = gs->psfile;
	    argv[i++] = "quit.ps";
	    argv[i++] = NULL;

#ifdef	DEBUG_XDVI_PS
	    Printf("gs:exec-ed\n");
#endif
	    execvp(GHOSTSCRIPT, argv);
	    perror("gs");

      gs_exec_error:
	    kill(getppid(), SIGUSR1);
	    exit(1);
	}
	else {
	    /* parent */
	    XEvent	ev;
	    struct gs_prop	props;

	    props.parent = gs->parent;
	    props.GS_DONE = XInternAtom(gs->disp, "DONE", False);
	    props.GS_PAGE = XInternAtom(gs->disp, "PAGE", False);

	    XIfEvent(gs->disp, &ev, check_gs_event, &props);
#ifdef	DEBUG
	    if (ev.xclient.message_type == props.GS_DONE ||
		ev.xclient.message_type == props.GS_PAGE) {
		Printf("caught event:GS_DONE or GS_PAGE\n");
		Printf("mess:%s\n", ev.xclient.data.b);
	    } else {
		Printf("caught another event\n");
	    }
#endif
	    signal(SIGCHLD, old_sigchld);
	    signal(SIGUSR1, old_sigusr1);
	    kill(gs-> gs_pid, SIGTERM);
	    wait(NULL);
	}

#ifdef	PS_LITERAL
	temp_ps_flush();
#endif	/* PS_LITERAL */

	return 0;
}

#ifdef	DEBUG
int
main(argc, argv)
	int	argc;
	char	**argv;
{
	struct gs_info	gs;
	GC	gc;
	int 	screen;

	gs.width = 400;
	gs.height = 400;

	gs.disp = XOpenDisplay("");
	screen = DefaultScreen();
	gs.parent = XCreateSimpleWindow(gs.disp, DefaultRootWindow(gs.disp),
					0, 0, gs.width, gs.height, 1,
					BlackPixel(gs.disp, screen),
					BlackPixel(gs.disp, screen));
	XMapWindow(gs.disp, gs.parent);

	gc = XCreateGC(gs.disp, gs.parent, 0, 0);
	XSetForeground(gs.disp, gc, WhitePixel(gs.disp, screen));
	XSetBackground(gs.disp, gc, BlackPixel(gs.disp, screen));

	XFlush(gs.disp);

	gs.psfile = argv[1];
	get_bounding_box(gs.psfile, &gs.llx, &gs.lly, &gs.urx, &gs.ury);

	printf("bounding box: llx:%d lly:%d urx:%d ury:%d\n",
	       (int) gs.llx, (int) gs.lly, (int) gs.urx, (int) gs.ury);

	gs.pix = XCreatePixmap(gs.disp, gs.parent, gs.width, gs.height, 1);

	psfig_to_bitmap(&gs);

	XCopyArea(gs.disp, gs.pix, gs.parent, gc,
		  0, 0, 400, 400, 0, 0);
	XFlush(gs.disp);

	getchar();

	return 0;
}
#endif

