/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_uherb(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uherb__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uherbz(obj, n, upx1, upx2, upy, itype, index, rsize)
    VALUE obj, n, upx1, upx2, upy, itype, index, rsize;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uherbz__(&i_n, i_upx1, i_upx2, i_upy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhdif(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhdif__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhdifz(obj, n, upx1, upx2, upy, itpat1, itpat2)
    VALUE obj, n, upx1, upx2, upy, itpat1, itpat2;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itpat1;
    integer i_itpat2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhdifz__(&i_n, i_upx1, i_upx2, i_upy, &i_itpat1, &i_itpat2);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbrf(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbrf__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbrfz(obj, n, upx1, upx2, upy, itype, index, rsize)
    VALUE obj, n, upx1, upx2, upy, itype, index, rsize;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbrfz__(&i_n, i_upx1, i_upx2, i_upy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbra(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbra__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbraz(obj, n, upx1, upx2, upy, itpat1, itpat2, rsize)
    VALUE obj, n, upx1, upx2, upy, itpat1, itpat2, rsize;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itpat1;
    integer i_itpat2;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbraz__(&i_n, i_upx1, i_upx2, i_upy, &i_itpat1, &i_itpat2, &i_rsize);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbrl(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uhbrl__(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbrlz(obj, n, upx, upy, itype, index, rsize)
    VALUE obj, n, upx, upy, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uhbrlz__(&i_n, i_upx, i_upy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxf(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbxf__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxfz(obj, n, upx1, upx2, upy, itype, index)
    VALUE obj, n, upx1, upx2, upy, itype, index;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbxfz__(&i_n, i_upx1, i_upx2, i_upy, &i_itype, &i_index);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxa(obj, n, upx1, upx2, upy)
    VALUE obj, n, upx1, upx2, upy;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbxa__(&i_n, i_upx1, i_upx2, i_upy);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxl(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uhbxl__(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxaz(obj, n, upx1, upx2, upy, itpat1, itpat2)
    VALUE obj, n, upx1, upx2, upy, itpat1, itpat2;
{
    integer i_n;
    real *i_upx1;
    real *i_upx2;
    real *i_upy;
    integer i_itpat1;
    integer i_itpat2;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx1) == T_FLOAT) {
      upx1 = rb_Array(upx1);
    }
    /* if ((TYPE(upx1) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upx2) == T_FLOAT) {
      upx2 = rb_Array(upx2);
    }
    /* if ((TYPE(upx2) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat1) != T_BIGNUM) || (TYPE(itpat1) != T_FIXNUM)) {
      itpat1 = rb_funcall(itpat1, rb_intern("to_i"), 0);
    }
    if ((TYPE(itpat2) != T_BIGNUM) || (TYPE(itpat2) != T_FIXNUM)) {
      itpat2 = rb_funcall(itpat2, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat1 = NUM2INT(itpat1);
    i_itpat2 = NUM2INT(itpat2);
    i_upx1 = dcl_obj2crealary(upx1);
    i_upx2 = dcl_obj2crealary(upx2);
    i_upy = dcl_obj2crealary(upy);


    uhbxaz__(&i_n, i_upx1, i_upx2, i_upy, &i_itpat1, &i_itpat2);

    dcl_freecrealary(i_upx1);
    dcl_freecrealary(i_upx2);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_uhbxlz(obj, n, upx, upy, itype, index)
    VALUE obj, n, upx, upy, itype, index;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    uhbxlz__(&i_n, i_upx, i_upy, &i_itype, &i_index);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}
void
init_grph2_uhpack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "uherb", dcl_uherb, 4);
    rb_define_module_function(mDCL, "uherbz", dcl_uherbz, 7);
    rb_define_module_function(mDCL, "uhdif", dcl_uhdif, 4);
    rb_define_module_function(mDCL, "uhdifz", dcl_uhdifz, 6);
    rb_define_module_function(mDCL, "uhbrf", dcl_uhbrf, 4);
    rb_define_module_function(mDCL, "uhbrfz", dcl_uhbrfz, 7);
    rb_define_module_function(mDCL, "uhbra", dcl_uhbra, 4);
    rb_define_module_function(mDCL, "uhbraz", dcl_uhbraz, 7);
    rb_define_module_function(mDCL, "uhbrl", dcl_uhbrl, 3);
    rb_define_module_function(mDCL, "uhbrlz", dcl_uhbrlz, 6);
    rb_define_module_function(mDCL, "uhbxf", dcl_uhbxf, 4);
    rb_define_module_function(mDCL, "uhbxfz", dcl_uhbxfz, 6);
    rb_define_module_function(mDCL, "uhbxa", dcl_uhbxa, 4);
    rb_define_module_function(mDCL, "uhbxl", dcl_uhbxl, 3);
    rb_define_module_function(mDCL, "uhbxaz", dcl_uhbxaz, 6);
    rb_define_module_function(mDCL, "uhbxlz", dcl_uhbxlz, 5);
}
