!--
!----------------------------------------------------------------------
!     Copyright (c) 2002-2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_module
!
!  spml/w_deriv_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!  Υ⥸塼Ȥˤä w_base_initial Ƥ
!  ȿ, ʻ򤷤Ƥɬפ. 
!
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/07/04  ݹ  OPENMP Ѵ롼б
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2008/05/31  ݹ  롼ʬΥ
!      2008/06/22  ʿ ʻǡ󳫻 1  0 .
!      2008/06/23  ʿ ʻǡγǼ (0:im-1, 1:jm) .
!      2008/07/01  ʿ Ȥ RDoc Ѥ
!      2009/01/09  ݹ  w_deriv_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!      2009/07/30  ݹ  ΰѿѹ(for OpenMP)
!      2013/02/23  ݹ  w_deriv_Finalize Ƴ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_deriv_module
  !
  != w_deriv_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_deriv_module.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_deriv_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
  ! ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  ! Υ⥸塼Ȥˤä w_base_initial Ƥ
  ! ȿ, ʻ򤷤Ƥɬפ. 
  !
  use dc_message, only : MessageNotify
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, &
                            w_base_Initial, xy_w, w_xy
  implicit none

  real(8), allocatable  :: rn(:,:)            
  ! ץ饷黻
  !
  ! ڥȥǡΥץ饷׻뤿η
  ! Υ((nm+1)*(nm+1), 2)
  !
  ! r(L,1) ˤ L ܤγǼ֤ΥڥȥФץ饷׻
  !  -n(n+1) ͤǼƤ.
  !
  integer, allocatable  :: irm(:,:)           
  ! ʬ黻
  !
  ! ڥȥǡηʬ׻뤿η.
  ! 󥵥 ( (nm+1)*(nm+1),2 ) Ǥ.
  !
  ! LܤγǼ֤Υڥȥ뤬ʤ, irm(L,1)ˤбγǼ֤,
  ! irm(L,2) ˤȿ m ǼƤ. ޤ, LܤγǼ֤Υڥȥ
  ! ʤ, irm(L,1)ˤбγǼ֤, irm(L,2)ˤ -m Ǽ
  ! Ƥ.
  !
  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  integer iw                                  ! 礭

  logical               :: w_deriv_initialize=.false.   ! եå

  private

  public w_deriv_Initial                      ! 
  public w_deriv_Finalize                     ! λ

  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public rn, irm                              ! ץ饷/ʬ黻

  save rn, irm, ip2, ip3, p2, p3, r2, r3
  save iw

  save w_deriv_initialize                     ! ե饰

  contains

  !---------------  -----------------
    subroutine w_deriv_initial
      !
      ! ڥȥʬ׻ɬפȤʤΰꤹ. 
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_Initial Ѥ뤳.
      !
      allocate(rn((nm+1)*(nm+1),2))           ! ץ饷黻
      allocate(irm((nm+1)*(nm+1),2))          ! ʬ黻
      call spnini(nm,rn)
      call spmini(nm,irm)

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jm,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jm,3,ip,p,r,ip3,p3,r3)

      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*im )

      w_deriv_initialize=.true.

      call MessageNotify('M','w_deriv_initial',&
           'w_deriv_module (2013/02/23) is initialized')

    end subroutine w_deriv_initial

  !--------------- ʬ׻ -----------------
    function w_Lapla_w(w_data)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !    ^2 = 1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_Lapla_w((nm+1)*(nm+1))
      !(out) ϥڥȥǡΥץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclap(nm,w_data,w_Lapla_w,rn(1,1))
    end function w_Lapla_w

    function w_LaplaInv_w(w_data)
      !
      ! ϥڥȥǡ˵եץ饷
      !
      !    ^{-2}
      !      =[1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)]^{-1}
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_LaplaInv_w((nm+1)*(nm+1))
      !(out) ڥȥǡεեץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclap(nm,w_data,w_LaplaInv_w,rn(1,2))
    end function w_LaplaInv_w

    function w_DLon_w(w_data)
      !
      ! ڥȥǡ˷ʬ /ߦ Ѥ(1 ).
      !
      ! ڥȥǡηʬȤ, бʻǡ
      ! ʬ/ߦˤѤǡΥڥȥѴΤȤǤ.
      ! 
      real(8)              :: w_DLon_w((nm+1)*(nm+1))
      !(out) ڥȥǡηʬ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call spclam(nm,w_data,w_DLon_w,irm)

    end function w_DLon_w

    function xy_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xy_GradLon_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLon_w = xy_w(w_data,ipow=1,iflag=-1)

    end function xy_GradLon_w

    function xy_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradLat_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLat_w = xy_w(w_data,ipow=1,iflag=1)

    end function xy_GradLat_w

    function w_DivLon_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ
      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLon_xy = w_xy(xy_data,ipow=1,iflag=-1)

    end function w_DivLon_xy

    function w_DivLat_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLat_xy = w_xy(xy_data,ipow=1,iflag=1)

    end function w_DivLat_xy

    function w_Div_xy_xy(xy_u,xy_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xy_xy((nm+1)*(nm+1))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xy_u(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xy_v(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      w_Div_xy_xy = w_Divlon_xy(xy_u) + w_Divlat_xy(xy_v)

    end function w_Div_xy_xy

    function w_Jacobian_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_Jacobian_w_w((nm+1)*(nm+1))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      real(8) :: q(3*((nm+1)/2+nm+1)*jm)       ! 
      real(8) :: ws(iw),ww(iw)                 ! 

      call spnjcb(nm,im,im,jm,jm,w_a,w_b,w_Jacobian_w_w,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww)

    end function w_Jacobian_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xy_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xy_GradLambda_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ
      
      xy_GradLambda_w = xy_w(w_data,ipow=0,iflag=-1)

    end function xy_GradLambda_w

    function xy_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradMu_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradMu_w = xy_w(w_data,ipow=0,iflag=1)

    end function xy_GradMu_w

    function w_DivLambda_xy(xy_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLambda_xy = w_xy(xy_data,ipow=2,iflag=-1)

    end function w_DivLambda_xy

    function w_DivMu_xy(xy_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivMu_xy = w_xy(xy_data,ipow=2,iflag=1)

    end function w_DivMu_xy

  !--------------- λ -----------------
    subroutine w_deriv_finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_Finalize Ѥ뤳.
      !
      if ( .not. w_deriv_initialize ) then
         call MessageNotify('W','w_deriv_Finalize',&
              'w_deriv_module not initialized yet')
         return
      endif

      deallocate(rn)       ! ץ饷黻
      deallocate(irm)      ! ʬ黻

      deallocate(ip2)      ! 䥳ӥ׻
      deallocate(p2)       ! 䥳ӥ׻
      deallocate(r2)       ! 䥳ӥ׻
      deallocate(ip3)      ! 䥳ӥ׻
      deallocate(p3)       ! 䥳ӥ׻
      deallocate(r3)       ! 䥳ӥ׻

      w_deriv_initialize = .false.

      call MessageNotify('M','w_deriv_Finalize',&
           'w_deriv_module (2013/02/23) is finalized')

    end subroutine w_deriv_finalize

  end module w_deriv_module
