#
# map3d1.rb
#   $Id$
#


require "numru/dcl"
include NumRu
include Math


np = 14

#-- data ---
itr =         [10, 11, 12, 13, 14, 15, 20, 21, 22, 23, 30, 31, 32, 33]
fct = NArray[12.0, 12, 14, 14, 14, 14, 11, 16, 12, 12, 40, 12, 12, 17]
fct = fct/100.0

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn(-(iws).abs)

DCL::slrat(2.0, 3.0)
DCL::sldiv('Y', 2, 3)

DCL::sglset('LCLIP', true)
DCL::sgrset('STLAT1', 45.0)
DCL::sgrset('STLAT2', 30.0)

DCL::umlset('LGRIDMN', false)
DCL::umiset('INDEXMJ', 1)

DCL::sgstxs(0.035)
DCL::sgstxi(3)

for i in 0..np-1
  DCL::sgfrm

  DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)
  DCL::sgssim(fct[i], 0.0, 0.0)
  DCL::sgsmpl(0.0, 90.0, 0.0)
  if ( itr[i] == 30 )
    DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
  else
    DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
  end
  DCL::sgstrn(itr[i])
  DCL::sgstrf

  DCL::slpwwr(1)
  DCL::slpvpr(1)
  cttl = DCL::sgtrnl(itr[i])
  DCL::sgtxr(0.5, 0.95, cttl)
  cttl = format("ITR=%2d", itr[i]);
  DCL::sgtxr(0.5, 0.05, cttl)

  DCL::umpmap('coast_world')
  DCL::umpglb

  if ( itr[i] == 23 )
    DCL::sgfrm
    DCL::sgfrm
  end
end

DCL::sgcls

