!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 SPMODEL Development Group.
!----------------------------------------------------------------------
!ɽ  w_interpolate_module_sjpack_cuda
!
!  spml/w_interpolate_module_sjpack_cuda ⥸塼ϵ̾Ǥ
!  2 ήαưĴȡѤڥȥˡˤäƿͷ׻
!  뤿Υ⥸塼 w_module_sjpack_cuda β⥸塼Ǥ, 
!  ڥȥˡˤַ׻Τ Fortran90 ؿ󶡤. 
!
!  ַ׻ˡˤĤƤ doc/w_module.tex 򻲾ȤΤ. 
!  Υ֥롼 ISPACK  sjpack, sjpack-cuda 
!  ֥롼ƤǤʤ. 
!
!  2011/03/11  ݹ w_interpolate_module_sjapack ¤, sjpack б.
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_interpolate_module_sjpack_cuda
  !
  !=  w_interpolate_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_interpolate_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_interpolate_module_sjpack ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module_sjpack_cuda β⥸塼Ǥ, ڥȥˡˤ
  ! ַ׻Τ Fortran90 ؿ󶡤. 
  !
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message, only : MessageNotify
  use w_base_module_sjpack_cuda, only : nm=>nn, l_nm
  implicit none
  private

  public Interpolate_w                        ! ִؿ

  interface Interpolate_w
     !
     !  alon,  alat ˤؿͤ
     ! εĴѴ w_data ַ׻
     !
     ! Ϥٷٺɸ, 
     !       , 1ʣ, ʣ1, ٰʣ
     !  4 
     !
     module procedure Interpolate_array00_w
  end interface

  interface alpha
     module procedure alpha_array0
  end interface

  interface Pmm
     module procedure Pmm_array0
  end interface

  contains

  !--------------- ַ׻ -----------------
    function Interpolate_array00_w(w_data,alon,alat)
      !
      !  alat,  alon ˤؿͤ
      ! εĴѴ w_data ַ׻
      !
      real(8), intent(IN) :: w_data((nm+1)*(nm+1))  ! ڥȥǡ
      real(8), intent(IN) :: alon                   ! ֤()
      real(8), intent(IN) :: alat                   ! ֤()
      real(8)             :: Interpolate_array00_w  ! ֤
      
      real(8) :: mu
      real(8) :: y0, y1, y2, AnmPnm
      integer :: k,m

      mu = sin(alat)
      Interpolate_array00_w = 0.0D0

      !---- a_n^0 P_n^0 η׻
      y2 = 0 ; y1 = 0
      do k=nm,1,-1
         y0 = alpha(k,0,mu) * y1 + beta(k+1,0)*y2 + w_data(l_nm(k,0))
         y2 = y1 ; y1 = y0
      enddo
      Interpolate_array00_w = (  beta(1,0) * y2 + mu*sqrt(3.0D0) * y1 &
                       + w_data(l_nm(0,0))  ) * Pmm(0,mu)

      !----   Re[s_n^m] P_n^m exp(im)η׻
      do m=1,nm
         y2 = 0 ; y1 = 0
         do k=nm,m+1,-1
            y0 = alpha(k,m,mu) * y1 + beta(k+1,m) * y2 + w_data(l_nm(k,m))
            y2 = y1 ; y1 = y0
         enddo

         AnmPnm =(w_data(l_nm(m,m)) + beta(m+1,m)*y2 &
                   + mu*sqrt(2.0D0*m+3)*y1 ) * Pmm(m,mu)

         Interpolate_array00_w = Interpolate_array00_w &
                                 + AnmPnm * 2 * cos(m*alon)
      end do

      !----   Im[s_n^m] P_n^m exp(im)η׻
      do m=1,nm
         y2 = 0 ; y1 = 0
         do k=nm,m+1,-1
            y0 = alpha(k,m,mu) * y1 + beta(k+1,m)*y2 + w_data(l_nm(k,-m))
            y2 = y1 ; y1 = y0
         enddo

         AnmPnm =(w_data(l_nm(m,-m)) + beta(m+1,m)*y2 &
                   + mu*sqrt(2.0D0*m+3)*y1 ) * Pmm(m,mu)


         Interpolate_array00_w = Interpolate_array00_w &
                                 - AnmPnm * 2 * sin(m*alon)
      end do
      
    end function Interpolate_array00_w

  !--------------- 롼 -----------------
    function alpha_array0(n,m,x)
      !
      !   P_n^m η
      !
      integer, intent(IN) :: n,m 
      real(8), intent(IN) :: x
      real(8)             :: alpha_array0

      alpha_array0 = sqrt( (2.0D0*n+3)*(2.0D0*n+1)/((n-m+1)*(n+m+1)) ) * x
    end function alpha_array0

    function beta(n,m)
      !
      !   P_{n-1}^m η
      !
      integer, intent(IN) :: n,m 
      real(8)             :: beta

      beta = - sqrt( (2.0D0*n+3)*(n+m)*(n-m)/((2*n-1)*(n+m+1)*(n-m+1)) )
    end function beta

    function Pmm_array0(m,x)
      !
      ! 른ɥȡ P_m^m(x) η׻
      !         sqrt( factrl(2*m+1) )/(2.0D0**m * factrl(m)) &
      !          * (1-x**2)**(m/2.0D0)
      !
      ! ȯʤ褦пǷ׻
      !
      integer, intent(IN) :: m           ! 른ɥȡμ
      real(8), intent(IN) :: x           ! 
      real(8)             :: Pmm_array0  ! 른ɥȡ
      real(8)             :: gammaln     ! ؿп

      if ( m < 0 ) call MessageNotify('E','Pmm in w_Intepolate_module',&
                                'order m should be larger equal to zero')

      Pmm_array0 = 1.0
      if ( m > 0 )then
            Pmm_array0 = &
                 exp(gammaln(2.0D0*m+2.0)/2.0D0 - m*log(2.0D0) - gammaln(m+1.0D0)) &
                 * (1-x**2)**(m/2.0D0)
      endif
    end function Pmm_array0

end module w_interpolate_module_sjpack_cuda
