!--
!----------------------------------------------------------------------
! Copyright(C) 2011 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_spectrum_module_sjpack_cuda
!
!  spml/w_spectrum_module_sjpack_cuda ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module_sjpack_cuda β⥸塼Ǥ, 
!  ڥȥϷ׻Τ Fortran90 ؿ󶡤. 
!
!  ڥȥ׻ˡˤĤƤ doc/w_module_sjpack.tex 򻲾ȤΤ. 
!   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2009/09/04  ݹ w_spectrum_module ¤, SJPACK б
!      2009/09/23  ݹ nm_* η׻
!      2011/03/11  ݹ sjpack-cuda Ѥ˲¤
!
!++
module w_spectrum_module_sjpack_cuda
  !
  !=  w_spectrum_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_spectrum_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_spectrum_module_sjpack_cuda ⥸塼ϵ̾Ǥ 
  ! 2 ήαưĴȡѤڥȥˡˤä
  ! ͷ׻뤿 ⥸塼 w_module_sjpack_cuda 
  ! ⥸塼Ǥ, ڥȥϷ׻Τ Fortran90 
  ! ؿ󶡤. 
  !
  ! ڥȥ׻ˡˤĤƤ doc/w_module_sjpack.tex 򻲾ȤΤ. 
  !  ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use w_base_module_sjpack_cuda, only : nm=>nn, l_nm

  implicit none

  private
 
  public nm_EnergyFromStreamfunc_w          ! ͥ륮ڥȥ           
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnergyFromStreamfunc_w           ! ͥ륮ڥȥ
                                            ! (ʿȿ n ) 
  public nm_EnstrophyFromStreamfunc_w       ! 󥹥ȥեڥȥ     
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnstrophyFromStreamfunc_w        ! 󥹥ȥեڥȥ  
                                            !  (ʿȿ n )
  public w_spectrum_VMiss                   ! »

  real(8) :: w_spectrum_VMiss = -999.000    ! »ͽ

  contains

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nm_EnergyFromStreamfunc_w(w_Strfunc)
      ! 
      ! ήؿΥڥȥǡ饨ͥ륮εĴȡʬ
      ! (ڥȥ)׻(1 ).
      !
      !  * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥ (1/2)n(n+1)|(n,m)|^2 ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤4Ф򤫤Τ̾Ǥ
      !    ͥ륮.
      !
      !  * ڥȥ (n,m) ʬȿ n, ȿ m μʬ, 
      !    (n,-m) ʬȿ n, ȿ m εʬǼƤ.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ(ʿȿ n, Ӿȿ m )

      integer n,m                               ! DO ѿ

      nm_EnergyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         nm_EnergyFromStreamfunc_w(n,0) &
              = 0.5 * n*(n+1) * w_Strfunc(l_nm(n,0))**2
         do m=1,n
            nm_EnergyFromStreamfunc_w(n,m) &
                 = 0.5 * n*(n+1) &
                 * (w_Strfunc(l_nm(n,m))**2+w_Strfunc(l_nm(n,-m))**2)
            nm_EnergyFromStreamfunc_w(n,-m) &
                 = nm_EnergyFromStreamfunc_w(n,m)
         enddo
      enddo
    end function nm_EnergyFromStreamfunc_w

    function n_EnergyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 ).
      !
      !  * ȿ n ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥϦ[m=-nm]^nm(1/2)n(n+1)|(n,m)|^2 
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ 4Ф򤫤Τ
      !    ̾Ǥͥ륮.
      !

      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ (ʿȿ n ) 

      integer n,m                                 ! DO ѿ

      n_EnergyFromStreamfunc_w = 0.0D0
      do n=0,nm
         n_EnergyFromStreamfunc_w(n) = &
                0.5 * n*(n+1) * w_StrFunc(l_nm(n,0))**2
         do m=1,n
            n_EnergyFromStreamfunc_w(n) = n_EnergyFromStreamfunc_w(n)+ &
                2 * 0.5 * n*(n+1) &
                * (w_StrFunc(l_nm(n,m))**2+w_StrFunc(l_nm(n,-m))**2)
         enddo
      enddo

    end function n_EnergyFromStreamfunc_w

  !--------------- 󥹥ȥեڥȥ׻ -----------------
    function nm_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡ饨󥹥ȥեεĴȡʬ
      ! (ڥȥ)׻(1 ). 
      !
      ! * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    󥹥ȥեڥȥ (1/2)n^2(n+1)^2|(n,m)|^2 ȷ׻.
      !
      ! * ƤΥ󥹥ȥեڥȥʬ¤4/R^2򤫤Τ
      !   ̾Ǥ󥹥ȥե.  R ϵ̤Ⱦ¤Ǥ.
      !
      ! * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !   »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !   (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnstrophyFromStreamfunc_w
      ! 󥹥ȥեڥȥ (ʿȿ n, Ӿȿ m )

      integer n,m                               ! DO ѿ

      nm_EnstrophyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         nm_EnstrophyFromStreamfunc_w(n,0) &
                 = 0.5 * n**2 * (n+1)**2 * w_Strfunc(l_nm(n,0))**2 
         do m=1,n
            nm_EnstrophyFromStreamfunc_w(n,m) &
                 = 0.5 * n**2 * (n+1)**2 * &
                 (w_Strfunc(l_nm(n,m))**2 +w_Strfunc(l_nm(n,-m))**2 )
            nm_EnstrophyFromStreamfunc_w(n,-m) &
                 = nm_EnstrophyFromStreamfunc_w(n,m)
         enddo
      enddo
    end function nm_EnstrophyFromStreamfunc_w

    function n_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 )
      !
      ! * ȿ n ήؿΥڥȥʬ(n,m) 饨󥹥ȥե
      !   ڥȥϦ[m=-nm]^nm(1/2)n^2(n+1)^2|(n,m)|^2 ȷ׻.
      !    
      ! * ƤΥͥ륮ڥȥʬ¤ 4/R^2 򤫤Τ
      !   ̾Ǥ󥹥ȥե.
      !
      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnstrophyFromStreamfunc_w  
      !(out) 󥹥ȥեڥȥ(ʿȿ n )

      integer n,m                                ! DO ѿ

      do n=0,nm
         n_EnstrophyFromStreamfunc_w(n)  &
              = 0.5 * n**2 * (n+1)**2 * w_StrFunc(l_nm(n,0))**2
         do m=1,n
            n_EnstrophyFromStreamfunc_w(n) &
               =  n_EnstrophyFromStreamfunc_w(n) &
               + 2* 0.5 * n**2 * (n+1)**2 &
                * (w_StrFunc(l_nm(n,m))**2+w_StrFunc(l_nm(n,-m))**2)
         enddo
      enddo
    end function n_EnstrophyFromStreamfunc_w

end module w_spectrum_module_sjpack_cuda
