!----------------------------------------------------------------------
!     Copyright (c) 2009--2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wa_zonal_module ƥȥץ :: ѴؿΥƥ
!
!  2009/09/23  ݹ
!      2013/02/14  ݹ  SJPACK Ѥ¤
!      2013/02/24  ݹ  λƥƳ
!
program wa_zonal_module_base_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wa_zonal_module
  implicit none

  integer :: im=1
  integer :: jm(2)=(/16,32/)
  integer :: nm(2)=(/10,21/)
  integer :: km=3

  real(8), allocatable ::  wa_data(:,:)
  real(8), allocatable ::  xya_data(:,:,:)

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  integer :: n

  call MessageNotify('M','wa_zonal_module_base_test', &
                         'wa_zonal_module basic functions tests') 

  do n=1,2

  call wa_Initial( nm(n), im, jm(n), km )

  allocate(wa_data(nm(n)+1,km))
  allocate(xya_data(0:im-1,jm(n),km))

  !---- Y_*^0 Υƥ ----
  wa_data= 0.0D0 
  xya_data(:,:,1) = sqrt(3.0D0)*sin(xy_Lat)                   ! Y_1^0
  wa_data(l_nm(1,0),1)=1.0D0

  xya_data(:,:,2) = sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)  ! Y_2^0
  wa_data(l_nm(2,0),2)=1.0D0

  xya_data(:,:,3) = sqrt(7.0D0)*(5.0/2*sin(xy_Lat)**3-3/2.0*sin(xy_Lat))! Y_3^0
  wa_data(l_nm(3,0),3)=1.0D0

  call AssertEqual(&
    message='Y_*^0 Test of wa_xya(xya_data)',                     &
    answer = wa_data,                                             &
    check = wa_xya(xya_data),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_*^0 Test of xya_wa(wa_xya(xya_data))',             &
    answer = xya_data,                                            &
    check = xya_wa(wa_xya(xya_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪؿΥƥ ----
  xya_data(:,:,1) = (sin(xy_Lat)-1)**2*(sin(xy_Lat)-0.5)*(sin(xy_Lat)+1)
  xya_data(:,:,2) = (sin(xy_Lat)-1)**2*(sin(xy_Lat)+1)**2
  xya_data(:,:,3) = (sin(xy_Lat)-1)*(sin(xy_Lat)-0.5)**2*(sin(xy_Lat)+1)

  call AssertEqual(&
    message='general function Test of xya_wa(wa_xya(xya_data))',  &
    answer = xya_data,                                            &
    check = xya_wa(wa_xya(xya_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  deallocate(wa_data)
  deallocate(xya_data)

  call wa_Finalize

  enddo

  call MessageNotify('M','wa_zonal_module_base_test', &
                         'wa_zonal_module basic functions tests succeeded!') 

end program wa_zonal_module_base_test
