!----------------------------------------------------------------------
!     Copyright (c) 2010--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_module_sjpack ƥȥץ
!      ʬʿѷ׻
!
!  2010/04/18  ݹ  wt_module_sjpack_integral_test.f90 ¤
!      2011/09/14  ݹ  MPI 
!      2011/09/14  ݹ  wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ  wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ  wtq_module_sjpack Ѥ˲¤
!
program wtq_module_sjpack_integral_wt

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module_sjpack

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=21       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=32       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo)       :: xyz_Data

  real(8), dimension(0:im-1,1:jm)            :: xy_Data
  real(8), dimension(1:jm,0:kmo)              :: yz_Data
  real(8), dimension(0:im-1,0:kmo)            :: xz_Data
  real(8), dimension(0:im-1)                 :: x_Data
  real(8), dimension(1:jm)                   :: y_Data
  real(8), dimension(0:kmo)                   :: z_Data
  real(8)                                    :: Data

  ! Ƚ
  integer, parameter :: check_digits = 8
  integer, parameter :: ignore = -9

  real(8), parameter  :: pi=3.1415926535897932385D0

  !============================ ʬ(xyz) ==============================

  call MessageNotify('M','wtq_module_sjpack_integral_wt_test', &
       'wtq_module_sjpack wt-integration functions tests')

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

 !----------  ----------
  xyz_Data = 1.0D0

  yz_Data = 2*pi
  call AssertEqual(&
       message='yz_IntLon_xyz with constant field',                &
       answer = yz_Data,                                           &
       check = yz_IntLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 2.0D0
  call AssertEqual(&
       message='xz_IntLat_xyz with constant field',                &
       answer = xz_Data,                                           &
       check = xz_IntLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='xy_IntRad_xyz with constant field',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 4*pi
  call AssertEqual(&
       message='z_IntLonLat_xyz with constant field',              &
       answer = z_Data,                                            &
       check = z_IntLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='x_IntLatRad_xyz with constant field',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='y_IntLonRad_xyz with constant field',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = 4*pi/3*(ro**3-ri**3)
  call AssertEqual(&
       message='IntLonLatRad_xyz with constant field',             &
       answer = Data,                                              &
       check = IntLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  !------------------ r -----------------------
  xyz_Data = xyz_Rad 

  yz_Data = 2*pi* xyz_Rad(1,:,:)
  call AssertEqual(&
       message='yz_IntLon_xyz with r-field',                       &
       answer = yz_Data,                                           &
       check = yz_IntLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 2.0D0 * xyz_Data(:,1,:)
  call AssertEqual(&
       message='xz_IntLat_xyz with r-field',                       &
       answer = xz_Data,                                           &
       check = xz_IntLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/4.0D0*(ro**4-ri**4) 
  call AssertEqual(&
       message='xy_IntRad_xyz with r field',                       &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 4*pi * xyz_Data(1,1,:)
  call AssertEqual(&
       message='z_IntLonLat_xyz with r field',                     &
       answer = z_Data,                                            &
       check = z_IntLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/2.0D0*(ro**4-ri**4)
  call AssertEqual(&
       message='x_IntLatRad_xyz with r field',                     &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/2.0D0*(ro**4-ri**4)
  call AssertEqual(&
       message='y_IntLonRad_xyz with constant field',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = pi*(ro**4-ri**4)
  call AssertEqual(&
       message='IntLonLatRad_xyz with constant field',              &
       answer = Data,                                            &
       check = IntLonLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  !--------- sin(phi)**2  ---------
  xyz_Data = sin(xyz_Lat)**2

  yz_Data = 2*pi* xyz_Data(1,:,:)
  call AssertEqual(&
       message='yz_IntLon_xyz with sin^2 field',                 &
       answer = yz_Data,                                           &
       check = yz_IntLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='xz_IntLat_xyz with sin^2 field',                 &
       answer = xz_Data,                                           &
       check = xz_IntLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*(ro**3-ri**3) * xyz_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyz with sin^2 field',                 &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 4*pi/3.0
  call AssertEqual(&
       message='z_IntLonLat_xyz with sin^2 field',               &
       answer = z_Data,                                            &
       check = z_IntLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/9.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='x_IntLatRad_xyz with sin^2 field',               &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*(ro**3-ri**3) * xyz_Data(1,:,1)
  call AssertEqual(&
       message='y_IntLonRad_xyz with sin^2 field',               &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = 4*pi/9*(ro**3-ri**3)
  call AssertEqual(&
       message='IntLonLatRad_xyz with constant field',             &
       answer = Data,                                              &
       check = IntLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyz_Data = sin(xyz_Lon)**2

  yz_Data = pi
  call AssertEqual(&
       message='yz_IntLon_xyz with sin(lambda)**2',                &
       answer = yz_Data,                                           &
       check = yz_IntLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 2.0D0 * xyz_Data(:,1,:)
  call AssertEqual(&
       message='xz_IntLat_xyz with sin(lambda)**2',                &
       answer = xz_Data,                                           &
       check = xz_IntLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*(ro**3-ri**3) * xyz_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyz with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 2*pi
  call AssertEqual(&
       message='z_IntLonLat_xyz with sin(lambda)**2',              &
       answer = z_Data,                                            &
       check = z_IntLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0*(ro**3-ri**3) * xyz_Data(:,1,1)
  call AssertEqual(&
       message='x_IntLatRad_xyz with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='y_IntLonRad_xyz with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyz with sin(lambda)**2',             &
       answer = 2*pi/3*(ro**3-ri**3),                              &
       check = IntLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xy) =============================
  ! 
  xy_Data = 1.0D0

  y_Data = 2*pi
  call AssertEqual(&
       message='y_IntLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0
  call AssertEqual(&
       message='x_IntLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with constant field',                 &
       answer = 4*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2

  y_Data = pi 
  call AssertEqual(&
       message='y_IntLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0d0 * xy_Data(:,1)
  call AssertEqual(&
       message='x_IntLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(lambda)**2',                 &
       answer = 2*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2

  y_Data = 2*pi* xy_Data(1,:)
  call AssertEqual(&
       message='y_IntLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='x_IntLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(phi)**2',                    &
       answer = 4*pi/3.0,                                          &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(yz) =============================
  ! 
  yz_Data = 1.0D0

  z_Data = 2.0D0
  call AssertEqual(&
       message='z_IntLat_yz with constant field',                  &
       answer = z_Data,                                            &
       check = z_IntLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='y_IntRad_yz with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yz with constant field',                 &
       answer = 2/3.0D0*(ro**3-ri**3),                             &
       check = IntLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yz_Data = xyz_Rad(0,:,:)**2

  z_Data = 2.0D0 * yz_Data(1,:)
  call AssertEqual(&
       message='z_IntLat_yz with r^2',                             &
       answer = z_Data,                                            &
       check = z_IntLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/5.0D0*(ro**5-ri**5)
  call AssertEqual(&
       message='y_IntRad_yz with r^2',                             &
       answer = y_Data,                                            &
       check = y_IntRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yz with r^2',                            &
       answer = 2/5.0D0*(ro**5-ri**5),                             &
       check = IntLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yz_Data = sin(xyz_Lat(0,:,:))**2

  z_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='z_IntLat_yz with sin(phi)**2',                     &
       answer = z_Data,                                            &
       check = z_IntLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*(ro**3-ri**3) * yz_Data(:,1)
  call AssertEqual(&
       message='y_IntRad_yz with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yz with sin(phi)**2',                    &
       answer = 2/9.0D0*(ro**3-ri**3),                             &
       check = IntLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xz) =============================
  ! 
  xz_Data = 1.0D0

  z_Data = 2*pi
  call AssertEqual(&
       message='z_IntLon_xz with constant field',                  &
       answer = z_Data,                                            &
       check = z_IntLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*(ro**3-ri**3)
  call AssertEqual(&
       message='x_IntRad_xz with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xz with constant field',                 &
       answer = 2*pi/3.0D0*(ro**3-ri**3),                          &
       check = IntLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xz_Data = sin(xyz_Lon(:,1,:))**2

  z_Data = pi
  call AssertEqual(&
       message='z_IntLon_xz with sin(lambda)**2',                  &
       answer = z_Data,                                            &
       check = z_IntLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*(ro**3-ri**3) * xz_Data(:,1)
  call AssertEqual(&
       message='x_IntRad_xz with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xz with sin(lambda)**2',                 &
       answer = pi/3.0D0*(ro**3-ri**3) ,                           &
       check = IntLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xz_Data = spread(z_Rad**2,1,im)

  z_Data = 2*pi* z_Rad**2
  call AssertEqual(&
       message='z_IntLon_xz with r^2',                             &
       answer = z_Data,                                            &
       check = z_IntLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/5.0D0*(ro**5-ri**5)
  call AssertEqual(&
       message='x_IntRad_xz with r^2',                             &
       answer = x_Data,                                            &
       check = x_IntRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xz with r^2',                            &
       answer = 2*pi/5.0D0*(ro**5-ri**5),                          &
       check = IntLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='IntLon_x with constant field',                     &
       answer = 2*pi,                                              &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='IntLon_x with sin(lambda)**2',                     &
       answer = pi,                                                &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(y) =============================
  ! 
  y_Data = 1.0D0

  call AssertEqual(&
       message='IntLat_y with constant field',                     &
       answer = 2.0D0,                                             &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2

  call AssertEqual(&
       message='IntLat_y with sin(phi)**2',                        &
       answer = 2.0D0/3.0D0,                                       &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(z) =============================
  ! 
  z_Data = 1.0D0

  call AssertEqual(&
       message='IntRad_r with constant field',                     &
       answer = 1/3.0D0*(ro**3-ri**3),                             &
       check = IntRad_z(z_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  z_Data = z_Rad**2

  call AssertEqual(&
       message='IntRad_r with r^2',                                &
       answer = 1/5.0D0*(ro**5-ri**5),                             &
       check = IntRad_z(z_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

!============================ ʿ(xyz) ==============================

 !----------  ----------
  xyz_Data = 1.0D0

  yz_Data = 1.0D0
  call AssertEqual(&
       message='yz_AvrLon_xyz with constant field',                &
       answer = yz_Data,                                           &
       check = yz_AvrLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 1.0D0
  call AssertEqual(&
       message='xz_AvrLat_xyz with constant field',                &
       answer = xz_Data,                                           &
       check = xz_AvrLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0
  call AssertEqual(&
       message='xy_AvrRad_xyz with constant field',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 1.0D0
  call AssertEqual(&
       message='z_AvrLonLat_xyz with constant field',              &
       answer = z_Data,                                            &
       check = z_AvrLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyz with constant field',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLonRad_xyz with constant field',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = 1.0D0
  call AssertEqual(&
       message='AvrLonLatRad_xyz with constant field',             &
       answer = Data,                                              &
       check = AvrLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  !------------------ r -----------------------
  xyz_Data = xyz_Rad 

  yz_Data = xyz_Rad(1,:,:)
  call AssertEqual(&
       message='yz_AvrLon_xyz with r-field',                &
       answer = yz_Data,                                           &
       check = yz_AvrLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = xyz_Data(:,1,:)
  call AssertEqual(&
       message='xz_AvrLat_xyz with r-field',                &
       answer = xz_Data,                                           &
       check = xz_AvrLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0/4.0D0*(ro**4-ri**4)/(1/3.0D0*(ro**3-ri**3))
  call AssertEqual(&
       message='xy_AvrRad_xyz with r field',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = xyz_Data(1,1,:)
  call AssertEqual(&
       message='z_AvrLonLat_xyz with r field',                     &
       answer = z_Data,                                            &
       check = z_AvrLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/2.0D0*(ro**4-ri**4)/(2/3.0D0*(ro**3-ri**3))
  call AssertEqual(&
       message='x_AvrLatRad_xyz with r field',                     &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/2.0D0*(ro**4-ri**4)/(2*pi/3.0D0*(ro**3-ri**3))
  call AssertEqual(&
       message='y_AvrLonRad_xyz with constant field',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = pi*(ro**4-ri**4)/(4*pi/3*(ro**3-ri**3))
  call AssertEqual(&
       message='AvrLonLatRad_xyz with constant field',              &
       answer = Data,                                            &
       check = AvrLonLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  !--------- sin(phi)**2  ---------
  xyz_Data = sin(xyz_Lat)**2

  yz_Data = xyz_Data(1,:,:)
  call AssertEqual(&
       message='yz_AvrLon_xyz with sin^2 field',                 &
       answer = yz_Data,                                           &
       check = yz_AvrLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='xz_AvrLat_xyz with sin^2 field',                 &
       answer = xz_Data,                                           &
       check = xz_AvrLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyz_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyz with sin^2 field',                 &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='z_AvrLonLat_xyz with sin^2 field',               &
       answer = z_Data,                                            &
       check = z_AvrLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyz with sin^2 field',               &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = xyz_Data(1,:,1)
  call AssertEqual(&
       message='y_AvrLonRad_xyz with sin^2 field',               &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  Data = 1.0D0/3D0
  call AssertEqual(&
       message='AvrLonLatRad_xyz with constant field',             &
       answer = Data,                                              &
       check = AvrLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyz_Data = sin(xyz_Lon)**2

  yz_Data = 0.5D0
  call AssertEqual(&
       message='yz_AvrLon_xyz with sin(lambda)**2',                &
       answer = yz_Data,                                           &
       check = yz_AvrLon_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xz_Data = xyz_Data(:,1,:)
  call AssertEqual(&
       message='xz_AvrLat_xyz with sin(lambda)**2',                &
       answer = xz_Data,                                           &
       check = xz_AvrLat_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyz_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyz with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyz(xyz_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  z_Data = 0.5D0
  call AssertEqual(&
       message='z_AvrLonLat_xyz with sin(lambda)**2',              &
       answer = z_Data,                                            &
       check = z_AvrLonLat_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xyz_Data(:,1,1)
  call AssertEqual(&
       message='x_AvrLatRad_xyz with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLonRad_xyz with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyz(xyz_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyz with sin(lambda)**2',             &
       answer = 0.5D0,                                             &
       check = AvrLonLatRad_xyz(xyz_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xy) =============================
  ! 
  xy_Data = 1.0D0

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xy_Data(:,1)
  call AssertEqual(&
       message='x_AvrLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2

  y_Data = xy_Data(1,:)
  call AssertEqual(&
       message='y_AvrLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(yz) =============================
  ! 
  yz_Data = 1.0D0

  z_Data = 1.0D0
  call AssertEqual(&
       message='z_AvrLat_yz with constant field',                  &
       answer = z_Data,                                            &
       check = z_AvrLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrRad_yz with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yz with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yz_Data = xyz_Rad(0,:,:)**2

  z_Data = yz_Data(1,:)
  call AssertEqual(&
       message='z_AvrLat_yz with r^2',                             &
       answer = z_Data,                                            &
       check = z_AvrLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 3.0D0/5.0D0*(ro**5-ri**5)/(ro**3-ri**3)
  call AssertEqual(&
       message='y_AvrRad_yz with r^2',                             &
       answer = y_Data,                                            &
       check = y_AvrRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yz with r^2',                            &
       answer = 3.0D0/5.0D0*(ro**5-ri**5)/(ro**3-ri**3),           &
       check = AvrLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yz_Data = sin(xyz_Lat(0,:,:))**2

  z_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='z_AvrLat_yz with sin(phi)**2',                     &
       answer = z_Data,                                            &
       check = z_AvrLat_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = yz_Data(:,1)
  call AssertEqual(&
       message='y_AvrRad_yz with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrRad_yz(yz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yz with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLatRad_yz(yz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xz) =============================
  ! 
  xz_Data = 1.0D0

  z_Data = 1.0D0
  call AssertEqual(&
       message='z_AvrLon_xz with constant field',                  &
       answer = z_Data,                                            &
       check = z_AvrLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrRad_xz with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xz with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xz_Data = sin(xyz_Lon(:,1,:))**2

  z_Data = 0.5D0
  call AssertEqual(&
       message='z_AvrLon_xz with sin(lambda)**2',                  &
       answer = z_Data,                                            &
       check = z_AvrLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xz_Data(:,1)
  call AssertEqual(&
       message='x_AvrRad_xz with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xz with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xz_Data = spread(z_Rad**2,1,im)

  z_Data = z_Rad**2
  call AssertEqual(&
       message='z_AvrLon_xz with r^2',                             &
       answer = z_Data,                                            &
       check = z_AvrLon_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 3.0D0/5.0D0*(ro**5-ri**5)/(ro**3-ri**3)
  call AssertEqual(&
       message='x_AvrRad_xz with r^2',                             &
       answer = x_Data,                                            &
       check = x_AvrRad_xz(xz_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xz with r^2',                            &
       answer = 3.0D0/5.0D0*(ro**5-ri**5)/(ro**3-ri**3),           &
       check = AvrLonRad_xz(xz_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='AvrLon_x with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='AvrLon_x with sin(lambda)**2',                     &
       answer = 0.5D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(y) =============================
  ! 
  y_Data = 1.0D0

  xz_Data = 1.0D0
  call AssertEqual(&
       message='AvrLat_y with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2

  call AssertEqual(&
       message='AvrLat_y with sin(phi)**2',                        &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(r) =============================
  ! 
  z_Data = 1.0D0

  call AssertEqual(&
       message='AvrRad_r with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrRad_z(z_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  z_Data = z_Rad**2

  call AssertEqual(&
       message='AvrRad_r with r^2',                                &
       answer = 3.0D0/5.0D0*(ro**5-ri**5)/(ro**3-ri**3),           &
       check = AvrRad_z(z_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call MessageNotify('M','wtq_module_sjpack_integral_wt_test', &
       'wtq_module_sjpack wt-integration/averaging function tests succeeded!')

end program wtq_module_sjpack_integral_wt
