!--
!----------------------------------------------------------------------
! Copyright(c) 2009-2013 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  tee_module
!
!    spml/tee_module ⥸塼ʿʿĴ֤Ǥ 3 ήαư
!    ڥȥˡˤäƿͷ׻뤿 Fortran90 ؿ󶡤
!    ΤǤ.
!
!    ʿ˥աꥨѴӾ岼ζɤ򰷤
!    ӥѴѤΥڥȥ׻ΤΤޤޤ
!    ؿ󶡤.
!
!     ee_module, at_module ѤƤ. ǲǤϥաꥨ
!    ӥӥѴΥ󥸥Ȥ ISPACK  Fortran77
!    ֥롼ѤƤ.
!
!
!  2009/12/19  ݹ  
!      2010/03/10  ʿ  threadprivate (ѥ¸)
!      2010/03/27  ݹ  goto ʸ
!      2011/12/05  ݹ  tee_Div_zyx_zyx_zyx  public ѿ
!      2012/07/08  ݹ  tee_LaplaPol2PolTau_tee ɲ
!      2012/08/24  ݹ  tee_LaplaPol2Pol_tee public ɲ
!      2013/08/20  ݹ  gnu fortran б
!
!
!      ǡ index
!        x : ʿ(X)        y : ʿ(Y)        z : ľ
!        e : աꥨѴڥȥ
!        l : աꥨؿڥȥ(X ȿ)
!        m : աꥨؿڥȥ(Y ȿ)
!        t : ӥմؿڥȥ
!        a : Ǥդμ
!
!        zyx : 3 ʻǡ
!        yx  : ʿ 2 ʻǡ
!        zy  : ľ 2 ʻǡ
!        zx  : ľ 2 ʻǡ
!
!        zee : ʿڥȥľʻǡ
!        tee : ڥȥǡľӥեǡ
!
!++
module tee_module
  !
  != tee_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: tee_module.f90 598 2013-08-20 03:23:44Z takepiro $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !    spml/tee_module ⥸塼ʿʿĴ֤Ǥ 3 ήαư
  !    ڥȥˡˤäƿͷ׻뤿 Fortran90 ؿ󶡤
  !    ΤǤ.
  !
  !    ʿ˥աꥨѴӾ岼ζɤ򰷤
  !    ӥѴѤΥڥȥ׻ΤΤޤޤ
  !    ؿ󶡤.
  !
  !     ee_module, at_module ѤƤ. ǲǤϥաꥨ
  !    ӥӥѴΥ󥸥Ȥ ISPACK  Fortran77
  !    ֥롼ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (tee_, zyx_, zee_, ee_, yx_, x_, y_, z_, a_) ,
  !   ֤ͤη򼨤Ƥ.
  !   tee_  :: ڥȥǡ(2 ťաꥨӥѴ)
  !   zyx_ :: 3 ʻǡ(ʿ 2 ľ 1 )
  !   zee_ :: ʿڥȥ, ľʻǡ
  !   e2a_ :: 1 ʿڥȥ, Ǥպɸǡ
  !   aee_ :: Ǥպɸǡ, ʿڥȥǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Dz, Lapla,..)
  !   , δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (tee_, zyx_, zee_, ee_, yx_, x_, y_, z_, a_) , ѿ
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _tee :: ڥȥǡ(2 ťաꥨӥѴ)
  !   _zyx :: 3 ʻǡ(ʿ 2 ľ 1 )
  !   _zee :: ʿڥȥ, ľʻǡ
  !   _e2a :: 1 ʿڥȥ, Ǥպɸǡ
  !   _aee :: Ǥպɸǡ, ʿڥȥǡ
  !
  !=== ƥǡμ
  !
  ! * zyx : 3 ʻǡ(ľ, ʿ 2 )
  !   * ѿμȼ real(8), dimension(0:km,0:jm-1,0:im-1).
  !   * im, jm, km Ϥ줾ʿ X, Y, ľ Z ɸγʻǤ,
  !     ֥롼 tee_Initial ˤƤ餫ꤷƤ.
  !
  ! * tee : ڥȥǡ
  !   * ѿμȼ real(8), dimension(0:nm,-mm:mm,-lm:lm).
  !   * lm, mm  X,Y ȿ, nm ϥӥ¿༰κ缡
  !     Ǥ, ֥롼 tee_Initial ˤƤ餫ꤷƤ.
  !
  ! * zee : ʿڥȥ, ľʻǡ.
  !   * ѿμȼ real(8), dimension(0:km,-mm:mm,-lm:lm).
  !
  ! * e2a : 1 ʿڥȥ, Ǥպɸǡ
  !   * ѿμȼ real(8), dimension((2*mm+1)*(2*lm+1),:)
  !
  ! * aee :   Ǥպɸǡ, ʿڥȥǡ
  !   * ѿμȼ real(8), dimension(:,-mm:mm,-lm:lm).
  !
  ! * tee_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * zyx_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * zee_ ǻϤޤؿ֤ͤϿʿڥȥ, ư³ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !
  !== ѿ³
  !
  !==== 
  !
  ! tee_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  !
  !==== ɸѿ
  !
  ! x_X, y_Y, z_Z                :: ʻɸ(ʿ X,Y, ľ Z ɸ)
  !                                 Ǽ1 
  ! x_X_Weight, y_X_Weight, z_Z_Weight :: ŤߺɸǼ 1 
  ! zyx_X, zyx_Y, zyx_Z          :: ʻǡοʿľɸ(X,Y,Z)
  !                                 (ʻǡ 3 )
  ! yx_X, yx_Y                   :: ʻǡοʿɸ(X,Y)
  ! zy_Z, zy_Y                   :: ʻǡαľʿɸ(Z,Y)
  ! zx_Z, zx_X                   :: ʻǡαľʿɸ(Z,X)
  !                                 (ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! zyx_tee, tee_zyx :: ڥȥǡ 3 ʻҥǡδ֤Ѵ
  !                     (2 ťաꥨ, ӥѴ)
  ! zyx_zee, zee_zyx :: 3 ʻҥǡȿʿڥȥ롦ľʻҥǡȤδ
  !                     Ѵ (2 ťաꥨѴ)
  ! zee_tee, tee_zee :: ڥȥǡȿʿڥȥ롦ľʻҥǡȤδ
  !                     Ѵ (ӥѴ)
  ! ee_yx, yx_ee     :: ڥȥǡ 2 ʿʻҥǡδ֤Ѵ
  !                     (2 ťաꥨѴ)
  ! az_at, at_az     :: ƱʣĹԤ (ӥѴ)ʻҥǡ
  !                     ӥեǡδ֤Ѵ
  ! e2a_aee, aee_e2a :: ʿڥȥ뼴 1 ž, ž .
  !
  !==== ʬ
  !
  ! tee_Dx_tee          :: ڥȥǡưʬ/x Ѥ
  ! tee_Dy_tee          :: ڥȥǡưʬ/y Ѥ
  ! tee_Dz_tee          :: ڥȥǡưʬ/z Ѥ
  !
  ! tee_Lapla_tee       :: ڥȥǡ˥ץ饷Ѥ
  ! tee_LaplaH_tee      :: ڥȥǡ˿ʿץ饷Ѥ
  ! tee_LaplaHInv_tee   :: ڥȥǡ˵տʿץ饷Ѥ
  !
  ! tee_Div_zyx_zyx_zyx :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  !
  !==== ȥݥ׻ʬ
  !
  ! tee_ZRot_zyx_zyx         :: ٥ȥ v α٤ư¥٥ȥ r 
  !                             z(v) ׻
  ! tee_ZRotRot_zyx_zyx_zyx  :: ٥ȥ v  z(ߢv) ׻
  ! tee_Potential2Vector     :: ȥݥݥƥ󥷥뤫
  !                             ٥ȥ׻
  ! tee_Potential2Rotation   :: ȥݥݥƥ󥷥ɽ
  !                             ȯ٥ȥβžγʬ׻
  !
  !==== ݥ/ȥǥѥڥȥ
  !
  ! zee_ToroidalEnergySpectrum_tee, zk_ToroidalEnergySpectrum_tee   ::
  !     ȥݥƥ󥷥뤫饨ͥ륮Υաꥨʬ׻
  ! zee_PoloidalEnergySpectrum_tee, zk_PoloidalEnergySpectrum_tee   ::
  !     ݥݥƥ󥷥뤫饨ͥ륮Υաꥨʬ׻
  !
  !==== 
  !
  ! tee_BoundariesTau, tee_BoundariesGrid, tee_Boundaries                ::
  !     ǥꥯ, Υޥ󶭳ŬѤ(ˡ, ˡ)
  !
  ! tee_TorBoundariesTau, tee_TorBoundariesGrid, tee_TorBoundaries       ::
  !     ®٥ȥݥƥ󥷥ζŬѤ(ˡ,ˡ)
  !
  ! tee_LaplaPol2PolTau_tee, zee_LaplaPol2Pol_zee, tee_LaplaPol2PolGrid_tee ::
  !     ®٥ݥݥƥ󥷥릵^2
  !     (Ϥ줾ӥճʻ,ӥշ)
  !
  ! tee_TorMagBoundariesTau, tee_TorMagBoundariesGrid, tee_TorMagBoundaries ::
  !     ȥݥƥ󥷥ζŬѤ(ˡ, ˡ)
  !
  ! tee_PolMagBoundariesTau, tee_PolMagBoundariesGrid, tee_PolMagBoundaries ::
  !     ȥݥƥ󥷥붭ζŬѤ(ˡ, ˡ)
  !
  !==== ʬʿ(3 ǡ)
  !
  ! IntZYX_zyx, AvrZYX_zyx     :: 3 ʻǡΰʬʿ
  ! z_IntYX_zyx, z_AvrYX_zyx   :: 3 ʻǡοʿʬʿ
  ! y_IntZX_zyx, y_AvrZX_zyx   :: 3 ʻǡZXʬʿ
  ! z_IntZY_zyx, z_AvrZY_zyx   :: 3 ʻǡZYʬʿ
  ! zy_IntX_zyx, zy_AvrX_zyx   :: 3 ʻǡοʿXʬʿ
  ! zx_IntY_zyx, zx_AvrY_zyx   :: 3 ʻǡοʿYʬʿ
  ! zx_IntZ_zyx, zx_AvrZ_zyx   :: 3 ʻǡαľʬʿ
  !
  !==== ʬʿ(2 ǡ)
  !
  ! IntYX_yx, AvrYX_yx :: 2 ʻǡοʿʬʿ
  ! IntZX_zx, AvrZX_zx :: 2 (ZX)ʻǡZXʬʿ
  ! IntZY_zy, AvrZY_zy :: 2 (ZY)ʻǡZYʬʿ
  ! y_IntX_yx, y_AvrX_yx   :: ʿ 2 ʻǡXʬʿ
  ! x_IntY_yx, x_AvrY_yx   :: ʿ2 ʻǡYʬʿ
  ! z_IntX_zx, z_AvrX_zx   :: 2 (ZX)ʻǡXʬʿ
  ! x_IntZ_zx, x_AvrZ_zx   :: 2 (ZX)ʻǡZʬʿ
  ! z_IntY_zy, z_AvrY_zy   :: 2 (ZY)ʻǡYʬʿ
  ! y_IntZ_zy, y_AvrZ_zy   :: 2 (ZY)ʻǡZʬʿ
  !
  !==== ʬʿ(1 ǡ)
  !
  ! IntX_x, AvrX_x  :: 1 (X)ʻǡXʬʿ
  ! IntY_y, AvrY_y  :: 1 (Y)ʻǡYʬʿ
  ! IntZ_z, AvrZ_z  :: 1 (Z)ʻǡZʬʿ
  !
  !==== ַ׻
  !
  ! Interpolate_tee :: ڥȥǡǤդ֤ͤ.
  !
  use dc_message
  use lumatrix
  use ee_module
  use at_module, z_Z => g_X, z_Z_WEIGHT => g_X_WEIGHT, &
                 at_az => at_ag, az_at => ag_at, &
                 t_z => t_g, z_t => g_t, &
                 t_Dz_t => t_Dx_t, at_Dz_at => at_Dx_at
  implicit none
  private

  public tee_Initial

  public x_X, x_X_Weight
  public y_Y, y_Y_Weight
  public z_Z, z_Z_Weight
  public yx_X, yx_Y, zy_Z, zy_Y, zx_X, zx_Z
  public zyx_X, zyx_Y, zyx_Z
  public zee_Z
  public tee_VMiss

  public ee_yx, yx_ee
  public at_Dz_at, t_Dz_t, az_at, at_az, z_t, t_z
  public zyx_tee, tee_zyx, zyx_zee, zee_zyx, zee_tee, tee_zee
  public e2z_e2t, e2t_e2z 
  public aee_e2a, e2a_aee, ee_e2, e2_ee
  public tee_Dx_tee, tee_Dy_tee, tee_Dz_tee
  public tee_Lapla_tee, tee_LaplaH_tee, tee_LaplaHInv_tee
  public tee_Div_zyx_zyx_zyx

  public zy_IntX_zyx, zx_IntY_zyx, yx_IntZ_zyx
  public x_IntZY_zyx, y_IntZX_zyx, z_IntYX_zyx
  public IntZYX_zyx

  public x_IntY_yx, y_IntX_yx, IntYX_yx
  public z_IntY_zy, y_IntZ_zy, IntZY_zy
  public z_IntX_zx, x_IntZ_zx, IntZX_zx
  public IntX_x, IntY_y, IntZ_z

  public zy_AvrX_zyx, zx_AvrY_zyx, yx_AvrZ_zyx
  public x_AvrZY_zyx, y_AvrZX_zyx, z_AvrYX_zyx
  public AvrZYX_zyx

  public x_AvrY_yx, y_AvrX_yx, AvrYX_yx
  public z_AvrY_zy, y_AvrZ_zy, AvrZY_zy
  public z_AvrX_zx, x_AvrZ_zx, AvrZX_zx
  public AvrX_x, AvrY_y, AvrZ_z

  public tee_ZRot_zyx_zyx, tee_ZRotRot_zyx_zyx_zyx
  public tee_Potential2vector, tee_Potential2Rotation

  public Interpolate_tee

  public zee_ToroidalEnergySpectrum_tee ! nz_ToroidalEnergySpectrum_wt
  public zee_PoloidalEnergySpectrum_tee ! nz_PoloidalEnergySpectrum_wt

  public tee_Boundaries, zee_LaplaPol2Pol_zee
  public tee_TorBoundaries, tee_LaplaPol2Pol_tee
  public tee_TormagBoundaries, tee_PolmagBoundaries

  public tee_BoundariesTau, tee_LaplaPol2PolTau_tee, tee_TorBoundariesTau
  public tee_TormagBoundariesTau, tee_PolmagBoundariesTau

  public tee_BoundariesGrid, tee_LaplaPol2PolGrid_tee, tee_TorBoundariesGrid
  public tee_TormagBoundariesGrid, tee_PolmagBoundariesGrid

  interface tee_Boundaries
     module procedure tee_BoundariesTau
  end interface

  interface tee_TorBoundaries
     module procedure tee_TorBoundariesTau
  end interface

  interface tee_LaplaPol2Pol_tee
     module procedure tee_LaplaPol2PolTau_tee
  end interface

  interface tee_TorMagBoundaries
     module procedure tee_TorMagBoundariesTau
  end interface

  interface tee_PolMagBoundaries
     module procedure tee_PolMagBoundariesTau
  end interface

  integer            :: im=32, jm=32, km=16  ! ʻ(X,Y,Z)
  integer            :: lm=10, mm=10, nm=16  ! ȿ(ʿX,Y, ľZ)
  real(8)            :: xl, yl, zl           ! ΰ礭(ʿX,Y, ľZ)

  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: zyx_X, zyx_Y, zyx_Z    ! ɸ
  real(8), dimension(:,:),   allocatable :: zy_Z, zy_Y             ! ɸ
  real(8), dimension(:,:),   allocatable :: zx_Z, zx_X             ! ɸ
  real(8), dimension(:,:,:), allocatable :: zee_Z                  ! ɸ

  real(8) :: tee_VMiss = -999.0        ! »

  save im, jm, km, lm, mm, nm, xl, yl, zl

  contains
  !---------------  -----------------
   subroutine tee_Initial(i,j,k,l,m,n,xmin,xmax,ymin,ymax,zmin,zmax)
     !
     ! ڥȥѴγʻ, ȿ, ƺɸϰϤꤹ.
     !
     ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
     ! ʤФʤʤ.
     !
     integer,intent(in) :: i              ! ʻ(ʿX)
     integer,intent(in) :: j              ! ʻ(ʿY)
     integer,intent(in) :: k              ! ʻ(ľZ)
     integer,intent(in) :: l              ! ȿ(ʿXȿ)
     integer,intent(in) :: m              ! ȿ(ʿYȿ)
     integer,intent(in) :: n              ! ȿ(ľZȿ)

     real(8),intent(in) :: xmin, xmax     ! X ΰ
     real(8),intent(in) :: ymin, ymax     ! Y ΰ
     real(8),intent(in) :: zmin, zmax     ! Z ΰ

     integer            :: id

     im = i  ; jm = j ; km = k
     lm = l  ; mm = m ; nm = n
     xl = xmax - xmin
     yl = ymax - ymin
     zl = zmax - zmin

     call ee_Initial(im,jm,lm,mm,xmin,xmax,ymin,ymax,id)

     call at_Initial(km,nm,zmin,zmax)

     allocate(zyx_X(0:km,0:jm-1,0:im-1))
     allocate(zyx_Y(0:km,0:jm-1,0:im-1))
     allocate(zyx_Z(0:km,0:jm-1,0:im-1))

     allocate(zy_Z(0:km,0:jm-1))
     allocate(zy_Y(0:km,0:jm-1))
     allocate(zx_Z(0:km,0:im-1))
     allocate(zx_X(0:km,0:im-1))

     allocate(zee_Z(0:km,-mm:mm,-lm:lm))

     zyx_X = spread(yx_X,1,km+1)
     zyx_Y = spread(yx_Y,1,km+1)
     zyx_Z = spread(spread(z_Z,2,jm),3,im)

     zy_Z = spread(z_Z,2,jm)
     zy_Y = spread(y_Y,1,km+1)
     zx_Z = spread(z_Z,2,im)
     zx_X = spread(x_X,1,km+1)

     zee_Z = spread(spread(z_Z,2,2*mm+1),3,2*lm+1)

     call MessageNotify('M','tee_initial', &
          'tee_module (2013/08/20) is initialized')

   end subroutine tee_Initial

  !--------------- Ѵ -----------------

    function zyx_tee(tee)
      !
      ! ڥȥǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) 2 ťաꥨӥեڥȥǡ
      real(8), dimension(0:km,0:jm-1,0:im-1)             :: zyx_tee
      !(out) 3 ʻǡ

      zyx_tee = zyx_zee(zee_tee(tee))

    end function zyx_tee

    function tee_zyx(zyx)
      !
      ! 3 ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ
      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_zyx
      !(out) 2 ťաꥨӥեڥȥǡ

      tee_zyx = tee_zee(zee_zyx(zyx))

    end function tee_zyx

    function zyx_zee(zee)
      !
      ! ʿڥȥ롦ľʻǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:km,-mm:mm,-lm:lm), intent(in) :: zee
      !(in) 2 ʿڥȥ롦ľʻǡ
      real(8), dimension(0:km,0:jm-1,0:im-1)             :: zyx_zee
      !(out) 3 ʻǡ
      real(8), dimension(-mm:mm,-lm:lm)                  :: ee
      real(8), dimension(0:jm-1,0:im-1)                  :: yx

      integer :: k

      do k = 0, km
         !zyx_zee(k,:,:) = yx_ee(zee(k,:,:))
         !
         ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
         !
         ee = zee(k,-mm:mm,-lm:lm)
         yx = yx_ee(ee)
         zyx_zee(k,:,:) = yx
      enddo

    end function zyx_zee

    function zee_zyx(zyx)
      !
      ! 3 ʻҥǡʿڥȥ롦ľʻǡ()Ѵ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ
      real(8), dimension(0:km,-mm:mm,-lm:lm)             :: zee_zyx
      !(out) 2 ڥȥ롦ľʻǡ
      real(8), dimension(-mm:mm,-lm:lm)                  :: ee
      real(8), dimension(0:jm-1,0:im-1)                  :: yx

      integer :: k

      do k = 0, km
         !zee_zyx(k,:,:) = ee_yx(zyx(k,:,:))
         !
         ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
         !
         yx = zyx(k,0:jm-1,0:im-1)
         ee = ee_yx(yx)
         zee_zyx(k,:,:) = ee
      enddo

    end function zee_zyx

    function zee_tee(tee)
      !
      ! ڥȥǡʿڥȥ롦ľʻǡ()Ѵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) 2 ʿڥȥľӥեڥȥǡ
      real(8), dimension(0:km,-mm:mm,-lm:lm)             :: zee_tee
      !(out) 2 ʿڥȥ롦ľʻǡ

      zee_tee = aee_e2a(e2z_e2t(e2a_aee(tee)))

    end function zee_tee

    function tee_zee(zee)
      !
      ! ʿڥȥ롦ľʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension(0:km,-mm:mm,-lm:lm), intent(in) :: zee
      !(in) 2 ʿڥȥ롦ľʻǡ
      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_zee
      !(out) 2 ʿľӥեڥȥǡ

      tee_zee = aee_e2a(e2t_e2z(e2a_aee(zee)))

    end function tee_zee

    function e2z_e2t(e2t)
      !
      ! ľڥȥʻѴ
      !
      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)  :: e2t
      !(in)  1 줿ʿڥȥ롦ľڥȥ
      real(8), dimension((2*lm+1)*(2*mm+1),0:km)  :: e2z_e2t
      !(out) 1 줿ʿڥȥ롦ľʻҺɸ

      e2z_e2t = az_at(e2t)

    end function e2z_e2t

    function e2t_e2z(e2z)
      !
      ! ľʻ򥹥ڥȥѴ
      !
      real(8), dimension((2*lm+1)*(2*mm+1),0:km)  :: e2z
      !(in)  1 줿ʿڥȥ롦ľʻҺɸ
      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)  :: e2t_e2z
      !(out) 1 줿ʿڥȥ롦ľڥȥ

      e2t_e2z = at_az(e2z)

    end function e2t_e2z

    function e2a_aee(aee)
      !
      ! ʿڥȥ 1 ž֤.
      !
      real(8), dimension(:,-mm:,-lm:), intent(in)        :: aee
      !(in) Ǥպɸʿ 2 ڥȥǡ dimension(:,-mm:mm,-lm:lm)
      real(8), dimension((2*lm+1)*(2*mm+1),size(aee,1))  :: e2a_aee
      !(out) 1 줿ʿڥȥ롦Ǥպɸǡ

      integer :: j,k,l,m

      if ( size(aee,2) /= 2*mm+1 ) &
           call MessageNotify('E','e2a_aee',&
                              '2nd dimension of input data invalid')
      if ( size(aee,3) /= 2*lm+1 ) &
           call MessageNotify('E','e2a_aee',&
                              '3rd dimension of input data invalid')

      !e2a_aee = transpose(reshape(aee,(/size(aee,1),(2*lm+1)*(2*mm+1)/)))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !

      do k=1,size(aee,1)
         do l=-lm,lm
            do m=-mm,mm
               j = (m+mm+1)+ (2*mm+1)*(l+lm)
               e2a_aee(j,k) = aee(k,m,l)
            enddo
         enddo
      enddo

    end function e2a_aee

    function aee_e2a(e2a)
      !
      ! ʿڥȥžŸ.
      !
      real(8), dimension(:,:),intent(in)                 :: e2a
      !(in) 1 줿ʿڥȥ롦Ǥպɸǡ
      !     dimmension((2*mm*1)*(2*lm*1),:)
      real(8), dimension(size(e2a,2),-mm:mm,-lm:lm)      :: aee_e2a
      !(out) Ǥպɸʿ 2 ڥȥǡ

      integer :: j,k,l,m

      if ( size(e2a,1) /= (2*mm+1)*(2*lm+1) ) &
           call MessageNotify('E','aee_e2a',&
                              '1st dimension of input data invalid')

      !aee_e2a = reshape(transpose(e2a),(/size(e2a,2),2*mm+1,2*lm+1/))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !

      do k=1,size(e2a,2)
         do l=-lm,lm
            do m=-mm,mm
               j = (m+mm+1) + (2*mm+1)*(l+lm)
               aee_e2a(k,m,l) = e2a(j,k)
            enddo
         enddo
      enddo

    end function aee_e2a

    function e2_ee(ee)
      !
      ! ʿڥȥ 1 ž֤.
      !
      real(8), dimension(-mm:,-lm:), intent(in)        :: ee
      !(in) Ǥպɸʿ 2 ڥȥǡ dimension(-mm:mm,-lm:lm)
      real(8), dimension((2*lm+1)*(2*mm+1))            :: e2_ee
      !(out) 1 줿ʿڥȥ롦Ǥպɸǡ

      integer :: j,l,m

      !e2_ee = reshape(e2a_aee(reshape(ee,(/1,2*mm+1,2*lm+1/))), &
      !                (/(2*lm+1)*(2*mm+1)/))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !

      do l=-lm,lm
         do m=-mm,mm
            j = (m+mm+1)+ (2*mm+1)*(l+lm)
            e2_ee(j) = ee(m,l)
         enddo
      enddo

    end function e2_ee

    function ee_e2(e2)
      !
      ! ʿڥȥžŸ.
      !
      real(8), dimension(:),intent(in)                   :: e2
      !(in) 1 줿ʿڥȥ롦Ǥպɸǡ
      !     dimmension((2*mm*1)*(2*lm*1),:)
      real(8), dimension(-mm:mm,-lm:lm)                  :: ee_e2
      !(out) Ǥպɸʿ 2 ڥȥǡ

      integer :: j,l,m

      !ee_e2 = reshape(aee_e2a(reshape(e2,(/(2*mm+1)*(2*lm+1),1/))), &
      !                (/2*mm+1,2*lm+1/))
      !
      ! νǤϤ, gfortran ̤ʤΤǲΤ褦˽ľ
      !

      do l=-lm,lm
         do m=-mm,mm
            j = (m+mm+1) + (2*mm+1)*(l+lm)
            ee_e2(m,l) = e2(j)
         enddo
      enddo

    end function ee_e2

  !--------------- ʬ׻ -----------------
    function tee_Dx_tee(tee)
      !
      ! ϥڥȥǡ˿ʿʬ /x Ѥ.
      !
      ! ڥȥǡXʬȤ, бʻǡXʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) ϥڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_Dx_tee
      !(in) Xʬ줿ڥȥǡ

      integer :: n

      do n=0,nm
         tee_Dx_tee(n,:,:) = ee_Dx_ee(tee(n,:,:))
      enddo

    end function tee_Dx_tee

    function tee_Dy_tee(tee)
      !
      ! ϥڥȥǡ˿ʿʬ /y Ѥ.
      !
      ! ڥȥǡYʬȤ, бʻǡYʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) ϥڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_Dy_tee
      !(in) Xʬ줿ڥȥǡ

      integer :: n

      do n=0,nm
         tee_Dy_tee(n,:,:) = ee_Dy_ee(tee(n,:,:))
      enddo

    end function tee_Dy_tee

    function tee_Dz_tee(tee)
      !
      ! ϥڥȥǡ˱ľʬ /z Ѥ.
      !
      ! ڥȥǡαľʬȤ, бʻǡ˱ľʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) ϥڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_Dz_tee
      !(in) ľʬ줿ڥȥǡ

      tee_Dz_tee = aee_e2a(at_Dz_at(e2a_aee(tee)))

    end function tee_Dz_tee

    function tee_Lapla_tee(tee)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !     ^2 = ^2/X^2 + ^2/Y^2 + ^2/Z^2
      !
      ! Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_Lapla_tee
      !(out) ץ饷Ѥ줿 2 ڥȥǡ

      tee_Lapla_tee = tee_LaplaH_tee(tee) + tee_Dz_tee(tee_Dz_tee(tee))

    end function tee_Lapla_tee

    function tee_LaplaH_tee(tee)
      !
      ! ϥڥȥǡ˿ʿץ饷
      !
      !     ^2_H = ^2/X^2 + ^2/Y^2
      !
      ! Ѥ.
      !
      ! ڥȥǡοʿץ饷Ȥ, бʻǡ
      ! ʿץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) ϥڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_LaplaH_tee
      !(out) ʿץ饷Ѥ줿 2 ڥȥǡ

      integer :: n

      do n=0,nm
         tee_LaplaH_tee(n,:,:) = ee_Lapla_ee(tee(n,:,:))
      enddo

    end function tee_LaplaH_tee

    function tee_LaplaHInv_tee(tee)
      !
      ! ϥڥȥǡ˵տʿץ饷
      !
      !     ^-2_H = (^2/X^2 + ^2/Y^2)^-1
      !
      ! Ѥ.
      !
      ! ڥȥǡεտʿץ饷Ȥ, бʻǡ
      ! տʿץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)             :: tee_LaplaHInv_tee
      !(out) տʿץ饷Ѥ줿 2 ڥȥǡ

      integer :: n

      do n=0,nm
         tee_LaplaHInv_tee(n,:,:) = ee_LaplaInv_ee(tee(n,:,:))
      enddo

    end function tee_LaplaHInv_tee

    function tee_Div_zyx_zyx_zyx(zyx_VX,zyx_VY,zyx_VZ)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
      ! ڥȥǡ֤.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VX
      !(in) ٥ȥXʬ
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VY
      !(in) ٥ȥYʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VZ
      !(in) ٥ȥZʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)     :: tee_Div_zyx_zyx_zyx
      !(out) ٥ȥȯ

      tee_Div_zyx_zyx_zyx =   tee_Dx_tee(tee_zyx(zyx_VX)) &
                            + tee_Dy_tee(tee_zyx(zyx_VY)) &
                            + tee_Dz_tee(tee_zyx(zyx_VZ))

    end function tee_Div_zyx_zyx_zyx

  !--------------- ʬ׻ -----------------
    !----(ϥǡ zyx)---
    function zy_IntX_zyx(zyx)  ! Xʬ
      !
      ! 3 ʻǡXʬ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:km,0:jm-1)  :: zy_IntX_zyx
      !(out) Xʬ줿 2 ZYʻǡ

      integer :: i

      zy_IntX_zyx = 0.0d0
      do i=0,im-1
         zy_IntX_zyx(:,:) = zy_IntX_zyx(:,:) &
                       + zyx(:,:,i) * x_X_Weight(i)
      enddo
    end function zy_IntX_zyx

    function zx_IntY_zyx(zyx)
      !
      ! 3 ʻǡYʬ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:km,0:im-1)  :: zx_IntY_zyx
      !(out) Yʬ줿 2 ZYʻǡ.

      integer :: j

      zx_IntY_zyx = 0.0d0
      do j=0,jm-1
         zx_IntY_zyx(:,:) = zx_IntY_zyx(:,:) &
                       + zyx(:,j,:) * y_Y_Weight(j)
      enddo
    end function zx_IntY_zyx

    function yx_IntZ_zyx(zyx)  ! Zʬ
      !
      ! 3 ʻǡZʬ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:jm-1,0:im-1)  :: yx_IntZ_zyx
      !(out) Zʬ줿 2 YX(ʿ)ʻǡ

      integer :: k

      yx_IntZ_zyx = 0.0d0
      do k=0,km
         yx_IntZ_zyx(:,:) = yx_IntZ_zyx(:,:) &
                       + zyx(k,:,:) * z_Z_Weight(k)
      enddo
    end function yx_IntZ_zyx

    function x_IntZY_zyx(zyx)
      !
      ! 3 ʻǡZYʬ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8), dimension(0:im-1)     :: x_IntZY_zyx
      !(out) ZY(Ҹ)ʬ줿 1 Xʻǡ

      integer :: j, k

      x_IntZY_zyx = 0.0D0
      do j=0,jm-1
         do k=0,km
            x_IntZY_zyx = x_IntZY_zyx &
                 + zyx(k,j,:) * y_Y_Weight(j) * z_Z_Weight(k)
         enddo
      enddo
    end function x_IntZY_zyx

    function y_IntZX_zyx(zyx)
      !
      ! 3 ʻǡZXʬ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8), dimension(0:jm-1)       :: y_IntZX_zyx
      !(out) ZXʬ줿 1 Yʻǡ

      integer :: i, k

      y_IntZX_zyx = 0
      do i=0,im-1
         do k=0,km
            y_IntZX_zyx = y_IntZX_zyx &
                 + zyx(k,:,i) * x_X_Weight(i) * z_Z_Weight(k)
         enddo
      enddo
    end function y_IntZX_zyx

    function z_IntYX_zyx(zyx)  ! YX(ʿ)ʬ
      !
      ! 3 ʻǡYX(ʿ)ʬ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8), dimension(0:km)     :: z_IntYX_zyx
      !(out) YX(ʿ)ʬ줿 1 Zʻǡ

      integer :: i, j

      z_IntYX_zyx = 0
      do j=0,jm-1
         do i=0,im-1
            z_IntYX_zyx = z_IntYX_zyx &
                 + zyx(:,j,i) * x_X_Weight(i) * y_Y_Weight(j)
         enddo
      enddo
    end function z_IntYX_zyx

    function IntZYX_zyx(zyx) ! ZYX(ΰ)ʬ
      !
      ! 3 ʻǡZYX(ΰ)ʬ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8)                     :: IntZYX_zyx
      !(out) ΰʬ

      integer :: i, j, k

      IntZYX_zyx = 0
      do i=0,im-1
         do j=0,jm-1
            do k=0,km
               IntZYX_zyx = IntZYX_zyx &
                    + zyx(k,j,i) * x_X_Weight(i) &
                         * y_Y_Weight(j) * z_Z_Weight(k)
            enddo
         enddo
      enddo
    end function IntZYX_zyx

    !----(ϥǡ zy)---
    function z_IntY_zy(zy)  ! Yʬ
      !
      ! 2 (ZY)ʻǡYʬ.
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZY(Ҹ)ʻǡ

      real(8), dimension(0:km)  :: z_IntY_zy
      !(out) Yʬ줿 1 Zʻǡ

      integer :: j

      z_IntY_zy = 0.0d0
      do j=0,jm-1
         z_IntY_zy(:) = z_IntY_zy(:) + zy(:,j) * y_Y_Weight(j)
      enddo
    end function z_IntY_zy

    function y_IntZ_zy(zy)  ! Zʬ
      !
      ! 2 (ZY)ʻǡZʬ.
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZYʻǡ

      real(8), dimension(0:jm-1)  :: y_IntZ_zy
      !(out) Zʬ줿 1 Yʻǡ

      integer :: k

      y_IntZ_zy = 0.0d0
      do k=0,km
         y_IntZ_zy(:) = y_IntZ_zy(:) &
                       + zy(k,:) * z_Z_Weight(k)
      enddo
    end function y_IntZ_zy

    function IntZY_zy(zy)
      !
      ! 2 (ZY)ʻǡZYʬ
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZY(Ҹ)ʻǡ

      real(8)                   :: IntZY_zy
      !(out) ʬ
      integer :: j, k

      IntZY_zy = 0
      do j=0,jm-1
         do k=0,km
            IntZY_zy = IntZY_zy &
                 + zy(k,j) * y_Y_Weight(j) * z_Z_Weight(k)
         enddo
      enddo
    end function IntZY_zy

    !----(ϥǡ zx)---
    function z_IntX_zx(zx)
      !
      ! 2 (ZX)ʻǡXʬ.
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      !(in) 2 ZYʻǡ

      real(8), dimension(0:km)  :: z_IntX_zx
      !(out) Xʬ줿 1 Zʻǡ

      integer :: i

      z_IntX_zx = 0.0d0
      do i=0,im-1
         z_IntX_zx(:) = z_IntX_zx(:) + zx(:,i) * x_X_Weight(i)
      enddo

    end function z_IntX_zx

    function x_IntZ_zx(zx)
      !
      ! 2 (ZX)ʻǡZʬ.
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      !(in) 2 ZYʻǡ

      real(8), dimension(0:im-1)  :: x_IntZ_zx
      !(out) Zʬ줿 1 Xʻǡ

      integer :: k

      x_IntZ_zx = 0.0d0
      do k=0,km
         x_IntZ_zx(:) = x_IntZ_zx(:) &
                       + zx(k,:) * z_Z_Weight(k)
      enddo

    end function x_IntZ_zx

    function IntZX_zx(zx)  ! ZXʬ
      !
      ! 2 (ZX)ʻǡZXʬ
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      !(in) 2 ZYʻǡ

      real(8)                                 :: IntZX_zx
      !(out) ʬ

      integer :: i, k

      IntZX_zx = 0
      do i=0,im-1
         do k=0,km
            IntZX_zx = IntZX_zx &
                 + zx(k,i) * x_X_Weight(i) * z_Z_Weight(k)
         enddo
      enddo
    end function IntZX_zx

    !----(ϥǡ z)---
    function IntZ_z(z)  ! Zʬ
      !
      ! 1 (Z)ʻǡZʬ.
      !
      real(8), dimension(0:km), intent(in) :: z
      !(in) 1 Zʻǡ

      real(8)                              :: IntZ_z
      !(out) ʬ

      integer :: k

      IntZ_z = 0.0d0
      do k=0,km
         IntZ_z = IntZ_z + z(k) * z_Z_Weight(k)
      enddo
    end function IntZ_z

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ zyx)---
    function zy_AvrX_zyx(zyx)  ! Xʬ
      !
      ! 3 ʻǡXʿ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8), dimension(0:km,0:jm-1)  :: zy_AvrX_zyx
      !(out) XʿѤ줿 2 Ҹ̳ʻǡ

      zy_AvrX_zyx = zy_IntX_zyx(zyx)/sum(x_X_Weight)

    end function zy_AvrX_zyx

    function zx_AvrY_zyx(zyx)  ! Yʿ
      !
      ! 3 ʻǡYʿ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:km,0:im-1)  :: zx_AvrY_zyx
      !(out) YʿѤ줿 2 ZXʻǡ

      zx_AvrY_zyx = zx_IntY_zyx(zyx)/sum(y_Y_Weight)

    end function zx_AvrY_zyx

    function yx_AvrZ_zyx(zyx)
      !
      ! 3 ʻǡZʿ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:jm-1,0:im-1)  :: yx_AvrZ_zyx
      !(out) ZʿѤ줿 2 YX(ʿ)ʻǡ

      yx_AvrZ_zyx = yx_IntZ_zyx(zyx)/sum(z_Z_Weight)

    end function yx_AvrZ_zyx

    function x_AvrZY_zyx(zyx)  ! ZYʬ
      !
      ! 3 ʻǡZYʿ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8), dimension(0:im-1)     :: x_AvrZY_zyx
      !(out) ZYʿѤ줿 1 Xʻǡ

      x_AvrZY_zyx = x_IntZY_zyx(zyx) &
                   /( sum(y_Y_Weight)*sum(z_Z_Weight) )

    end function x_AvrZY_zyx

    function y_AvrZX_zyx(zyx)  ! ZXʬ
      !
      ! 3 ʻǡZXʿ.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:jm-1)       :: y_AvrZX_zyx
      !(out) ZXʿѤ줿 1 Yʻǡ

      y_AvrZX_zyx = y_IntZX_zyx(zyx) &
                 /(sum(x_X_Weight)*sum(z_Z_Weight))

    end function y_AvrZX_zyx

    function z_AvrYX_zyx(zyx)  ! YX(ʿ)ʬ
      !
      ! 3 ʻǡYX(ʿ)ʬ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ʻǡ

      real(8), dimension(0:km)     :: z_AvrYX_zyx
      !(out) YX(ʿ)ʿѤ줿 1 Zʻǡ

      z_AvrYX_zyx = z_IntYX_zyx(zyx) &
                 /(sum(x_X_Weight)*sum(y_Y_Weight))

    end function z_AvrYX_zyx

    function AvrZYX_zyx(zyx) ! ZYX(ΰ)ʬ
      !
      ! 3 ʻǡZYX(ΰ)ʬ
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx
      !(in) 3 ZYXʻǡ

      real(8)                     :: AvrZYX_zyx
      !(out) ΰʿ

      AvrZYX_zyx = IntZYX_zyx(zyx) &
            /(sum(x_X_Weight)*sum(y_Y_Weight) * sum(z_Z_Weight))

    end function AvrZYX_zyx

    !----(ϥǡ zy)---
    function z_AvrY_zy(zy)
      !
      ! 2 (ZY)ʻǡYʿ.
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZYʻǡ

      real(8), dimension(0:km)  :: z_AvrY_zy
      !(out) YʿѤ줿 1 Zʻǡ

      z_AvrY_zy = z_IntY_zy(zy)/sum(y_Y_Weight)

    end function z_AvrY_zy

    function y_AvrZ_zy(zy)
      !
      ! 2 (ZY)ʻǡZʿ.
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZYʻǡ

      real(8), dimension(0:jm-1)  :: y_AvrZ_zy
      !(out) ZʿѤ줿 1 Yʻǡ

      y_AvrZ_zy = y_IntZ_zy(zy)/sum(z_Z_Weight)

    end function y_AvrZ_zy

    function AvrZY_zy(zy)  ! ZYʿ
      !
      ! 2 (ZY)ʻǡZYʿ
      !
      real(8), dimension(0:km,0:jm-1), intent(in) :: zy
      !(in) 2 ZY(Ҹ)ʻǡ

      real(8)                   :: AvrZY_zy
      !(out) ʿ

      AvrZY_zy = IntZY_zy(zy)/(sum(y_Y_Weight)*sum(z_Z_Weight))

    end function AvrZY_zy

    !----(ϥǡ zx)---
    function z_AvrX_zx(zx)  ! Xʬ
      !
      ! 2 (ZX)ʻǡXʿ.
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      !(in) 2 ZYʻǡ

      real(8), dimension(0:km)  :: z_AvrX_zx
      !(out) XʿѤ줿 1 Zʻǡ

      z_AvrX_zx = z_IntX_zx(zx)/sum(x_X_Weight)

    end function z_AvrX_zx

    function x_AvrZ_zx(zx)  ! Zʿ
      !
      ! 2 (ZX)ʻǡZʿ.
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      !(in) 2 ZYʻǡ

      real(8), dimension(0:im-1)  :: x_AvrZ_zx
      !(out) ZʿѤ줿 1 Xʻǡ

      x_AvrZ_zx = x_IntZ_zx(zx)/sum(z_Z_Weight)

    end function x_AvrZ_zx

    function AvrZX_zx(zx)  ! ZXʬ
      !
      ! 2 (ZX)ʻǡZXʿ
      !
      real(8), dimension(0:km,0:im-1), intent(in) :: zx
      ! (in) 2 ʻǡ
      real(8)                                 :: AvrZX_zx
      ! ʿ

      AvrZX_zx = IntZX_zx(zx)/(sum(x_X_Weight)*sum(z_Z_Weight))

    end function AvrZX_zx

    !----(ϥǡ z)---
    function AvrZ_z(z)
      !
      ! 1 (Z)ʻǡZʿ.
      !
      real(8), dimension(0:km), intent(in) :: z
      !(in) 1 Zʻǡ
      real(8)                              :: AvrZ_z
      !(out) ʿ

      AvrZ_z = IntZ_z(z)/sum(z_Z_Weight)

    end function AvrZ_z

!!$  !--------------- ݥ/ȥǥʬ -----------------
!!$
!!$    function wt_KxRGrad_wt(wt)
!!$      !
!!$      ! ϥڥȥǡXʬ kr = /ߦˤѤ.
!!$      !
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm), intent(in) :: wt
!!$      !(in) 2 Ĵȡӥեڥȥǡ
!!$
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm)             :: wt_KxRGrad_wt
!!$      !(out) XʬѤ줿 2 ڥȥǡ
!!$
!!$      wt_KxRGrad_wt =  wa_Dlon_wa(wt)
!!$
!!$    end function wt_KxRGrad_wt
!!$
!!$    function zyx_KGrad_wt(wt)    ! k = cos/r /ߦ + sinբ/r
!!$      !
!!$      ! ϥڥȥǡбʻҥǡ˼ʬ
!!$      !
!!$      !    k = cos/r /ߦ + sinբ/r
!!$      !
!!$      ! Ѥʻҥǡ֤.
!!$      ! ǥ٥ȥ k ϵ濴̶˸ñ̥٥ȥǤ.
!!$      !
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm), intent(in) :: wt
!!$      !(in) 2 Ĵȡӥեڥȥǡ
!!$
!!$      real(8), dimension(0:km,0:jm-1,0:im-1)                     :: yzx_KGrad_wt
!!$      !(out) ʬѤ줿 2 ڥȥǡ
!!$
!!$      xzy_KGrad_wt =  cos(xyz_Y)*xyz_GradY_wt(wt) &
!!$                    + sin(xyz_Y)*xyz_wt(wt_Drad_wt(wt))
!!$
!!$    end function xyz_KGrad_wt
!!$
!!$    function wt_L2_wt(wt)
!!$      !
!!$      ! ϥڥȥǡ L^2 黻(=-ʿץ饷)Ѥ.
!!$      !
!!$      ! L^2 黻Ҥñ̵̾οʿץ饷εˤ.
!!$      !  ϥڥȥ бʻǡ˱黻
!!$      !
!!$      !     L^2 = -1/cos^2ա^2/ߦ^2 - 1/cosա/ߦ(cosբ/ߦ)
!!$      !
!!$      ! ѤǡΥڥȥѴ֤.
!!$      !
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm), intent(in) :: wt
!!$      !(in) 2 Ĵȡӥեڥȥǡ
!!$
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm)             :: wt_L2_wt
!!$      !(out) L^2 黻ҤѤ줿 2 ڥȥǡ
!!$
!!$      wt_L2_wt = -wa_Lapla_wa(wt)
!!$
!!$    end function wt_L2_wt
!!$
!!$    function wt_L2Inv_wt(wt)
!!$      !
!!$      ! ϥڥȥǡ L^2 黻Ҥεձ黻(-տʿץ饷)
!!$      ! Ѥ.
!!$      !
!!$      ! ڥȥǡ L^2 黻ҤѤؿ wt_L2_wt εշ׻
!!$      ! ԤؿǤ.
!!$      !
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm), intent(in) :: wt
!!$      !(in) 2 Ĵȡӥեڥȥǡ
!!$
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm)             :: wt_L2Inv_wt
!!$      !(out) L^2 黻Ҥεձ黻Ѥ줿 2 ڥȥǡ
!!$
!!$      wt_L2Inv_wt = -wa_LaplaInv_wa(wt)
!!$
!!$    end function wt_L2Inv_wt
!!$
!!$    function wt_QOperator_wt(wt)
!!$      !
!!$      ! ϥڥȥǡбʻǡ˱黻
!!$      !
!!$      !    Q=(k-1/2(L2 k+ kL2))
!!$      !
!!$      ! ѤǡΥڥȥѴ֤.
!!$      !
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm), intent(in) :: wt
!!$      !(in) 2 Ĵȡӥեڥȥǡ
!!$
!!$      real(8), dimension(-lm:lm,-mm,mm,0:nm)             :: wt_QOperator_wt
!!$      !(out) Q 黻ҤѤ줿 2 ڥȥǡ
!!$
!!$      wt_QOperator_wt = &
!!$             wt_xyz(xyz_KGrad_wt(wt) - xyz_KGrad_wt(wt_L2_wt(wt))/2) &
!!$           - wt_L2_wt(wt_xyz(xyz_KGrad_wt(wt)))/2
!!$
!!$    end function wt_QOperator_wt

    function tee_ZRot_zyx_zyx(zyx_VX,zyx_VY)  ! z(v)
      !
      ! ٥ȥα٤Z٥ȥ z(v) ׻.
      !
      !  1, 2 (v[x], v[y])줾٥ȥXʬ, Yʬɽ.
      !
      !    z(v) = v[y]/x - (v[x])/y
      !
      ! Υڥȥ ǡ֤.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VX
      !(in) ٥ȥXʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VY
      !(in) ٥ȥYʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)     :: tee_ZRot_zyx_zyx
      !(out) ٥ȥα٤Z٥ȥ

      tee_ZRot_zyx_zyx = tee_DX_tee(tee_zyx(zyx_VY)) &
                       - tee_DY_tee(tee_zyx(zyx_VX))

    end function tee_ZRot_zyx_zyx

    function tee_ZRotRot_zyx_zyx_zyx(zyx_VX,zyx_VY,zyx_VZ)
      !
      ! ٥ȥ v Ф z(ߢv) ׻.
      !
      !  1, 2, 3 (v[x], v[y], v[z])줾٥ȥXʬ,
      ! Yʬ, Zʬɽ.
      !
      !    z(ߢv)  = /z (v[x]/x + (v[y])/y ) )
      !                    - _H^2 v[z]
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VX
      !(in) ٥ȥXʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VY
      !(in) ٥ȥYʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(in) :: zyx_VZ
      !(in) ٥ȥZʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)     :: tee_ZRotRot_zyx_zyx_zyx
      !(out) ٥ȥ v  z(ߢv)

      tee_ZRotRot_zyx_zyx_zyx = &
               tee_DZ_tee(   tee_DX_tee(tee_zyx(zyx_VX))   &
                           + tee_DY_tee(tee_zyx(zyx_VY)) ) &
             - tee_LaplaH_tee(tee_zyx(zyx_VZ))

    end function tee_ZRotRot_zyx_zyx_zyx

    subroutine tee_Potential2Vector(&
         zyx_VX,zyx_VY,zyx_VZ,tee_Torvel,tee_Polvel)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(z) + xx(z)
      !
      ! γʬ׻
      !
      real(8), dimension(0:km,0:jm-1,0:im-1)     :: zyx_VX
      !(out) ٥ȥXʬ

      real(8), dimension(0:km,0:jm-1,0:im-1)     :: zyx_VY
      !(out) ٥ȥYʬ

      real(8), dimension(0:km,0:jm-1,0:im-1)     :: zyx_VZ
      !(out) ٥ȥZʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_Torvel
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_Polvel
      !(in) ݥݥƥ󥷥

      zyx_VX = zyx_tee(   tee_DY_tee(tee_Torvel) &
                        + tee_DX_tee(tee_DZ_tee(tee_Polvel))  )
      zyx_VY = zyx_tee( - tee_DX_tee(tee_Torvel) &
                        + tee_DY_tee(tee_DZ_tee(tee_Polvel))  )
      zyx_VZ = -zyx_tee(tee_LaplaH_tee(tee_Polvel))

    end subroutine tee_Potential2Vector

    subroutine tee_Potential2Rotation(&
       zyx_RotVX,zyx_RotVY,zyx_RotVZ,tee_Torvel,tee_Polvel)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(z) + xx(z)
      !
      ! Ф, βž
      !
      !     xv = xx(z) + xxx(z) = xx(z) - x((^2)z)
      !
      ! ׻.

      ! ٥ȥβž
      real(8), dimension(0:km,0:jm-1,0:im-1), intent(OUT) :: zyx_RotVX
      !(out) žXʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(OUT) :: zyx_RotVY
      !(out) žYʬ

      real(8), dimension(0:km,0:jm-1,0:im-1), intent(OUT) :: zyx_RotVZ
      !(out) žZʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_Torvel
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_Polvel
      !(in) ݥݥƥ󥷥

      call tee_Potential2Vector( &
           zyx_RotVX,zyx_RotVY,zyx_RotVZ, &
           -tee_Lapla_tee(tee_Polvel), tee_Torvel)

    end subroutine tee_Potential2Rotation

  !--------------- ַ׻ -----------------
    function Interpolate_tee(tee_data,x,y,z)
      !
      ! (x,y,z) ˤؿͤ
      ! Υڥȥ뷸 tee_data ַ׻
      !
      real(8), intent(IN) :: tee_data(0:nm,-mm:mm,-lm:lm)  ! ڥȥǡ
      real(8), intent(IN) :: x                             ! ֤(X)
      real(8), intent(IN) :: y                             ! ֤(Y)
      real(8), intent(IN) :: z                             ! ֤(Z)
      real(8) :: Interpolate_tee                           ! ֤

      Interpolate_tee = &
           Interpolate_ee(ee_e2(a_Interpolate_at(e2a_aee(tee_data),z)),x,y)

    end function Interpolate_tee

  !--------------- ݥ/ȥǥѥڥȥ ----------------

    function zee_ToroidalEnergySpectrum_tee(tee_TORPOT)
      !
      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
      ! ʿ X ȿ l, Y  ȿ m γʬ׻
      !
      !  * X ȿ l, Y ȿ m Υȥݥƥ󥷥Υڥȥʬ
      !    (l,m,z)ʿ X ȿ l, Y ȿ m ʬΥȥ륨ͥ륮
      !    ڥȥ  (1/2)(l**2+m**2)|(l,m,z)|^2  ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ZʬΤΰǤ
      !    ʿʿѥͥ륮.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:km,-mm:mm,-lm:lm) :: zee_ToroidalEnergySpectrum_tee
      !(out) ͥ륮ڥȥȥʬ

      real(8), dimension(0:km,-mm:mm,-lm:lm) :: zee_Work
      integer :: l, m

      zee_Work = zee_tee(tee_Torpot)
      do l=-lm,lm
         do m=-mm,mm
            zee_ToroidalEnergySpectrum_tee(:,m,l) &
              = 0.5 * ((2*PI*l/xl)**2+(2*PI*m/yl)**2) &
              * ( zee_Work(:,m,l)**2 + zee_Work(:,-m,-l)**2 )
         enddo
      enddo

    end function zee_ToroidalEnergySpectrum_tee

!!$    function nz_ToroidalEnergySpectrum_wt(wt_TORPOT)
!!$      !
!!$      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
!!$      ! Ĵȡȿγʬ׻.
!!$      !
!!$      !  * ȿ n, Ӿȿ m Υȥݥƥ󥷥Υڥȥʬ
!!$      !    (n,m,r)ȿ n ʬΥȥ륨ͥ륮ڥȥ
!!$      !    [m=-n]^n(1/2)n(n+1)4r^2(n,m,r)^2 ȷ׻.
!!$      !
!!$      ! * ƤΥͥ륮ڥȥʬ¤Zʬ(r^2νŤ̵)
!!$      !    Ǥͥ륮.
!!$      !
!!$      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: wt_TORPOT
!!$      !(in) ȥݥƥ󥷥
!!$
!!$      real(8), dimension(0:nm,0:km) :: nz_ToroidalEnergySpectrum_wt
!!$      !(out) ͥ륮ڥȥȥʬ
!!$
!!$      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA   ! ΰ
!!$      integer :: n, m
!!$
!!$      wz_DATA = wz_wt(wt_TORPOT)
!!$      do n=0,nm
!!$         nz_ToroidalEnergySpectrum_wt(n,:) &
!!$              = 0.5 * n*(n+1)* (4*pi) * z_Z**2 &
!!$                * sum(wz_Data(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)
!!$      enddo
!!$
!!$    end function nz_ToroidalEnergySpectrum_wt

    function zee_PoloidalEnergySpectrum_tee(tee_POLPOT)
      !
      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
      ! ʿ X ȿ l, Y ȿ m γʬ׻.
      !
      !  * X ȿ l, Y ȿ m Υݥݥƥ󥷥Υڥȥʬ
      !    (l,m,z) X ȿ l, Y ȿ m ʬΥݥ륨ͥ륮
      !    ڥȥ
      !
      !      (1/2)(l**2+m**2){[d(n,m,z)/dz]^2 + (l**2+m**2)(n,m,z)^2}
      !
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤Zʬ
      !    ʿʿѥͥ륮.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: tee_POLPOT
      !(in) ݥݥƥ󥷥

      real(8), dimension(0:km,-nm:nm,-lm:lm) :: zee_PoloidalEnergySpectrum_tee
      !(out) ͥ륮ڥȥݥʬ


      real(8), dimension(0:km,-mm:mm,-lm:lm) :: zee_Data   ! ΰ
      real(8), dimension(0:km,-mm:mm,-lm:lm) :: zee_DData  ! ΰ
      integer :: l, m

      zee_Data = zee_tee(tee_POLPOT)
      zee_DData = zee_tee(tee_DZ_tee(tee_POLPOT))

      do l=-lm,lm
         do m=-mm,mm
            zee_PoloidalEnergySpectrum_tee(:,m,l) =                   &
                 + 0.5* ((2*pi*l/xl)**2+(2*pi*m/yl)**2)               &
                 *(   zee_DData(:,m,l)**2 + zee_DData(:,-m,-l)**2     &
                    + ((2*pi*l/xl)**2+(2*pi*m/yl)**2)                 &
                         *( zee_Data(:,m,l)**2 + zee_Data(:,-m,-l)**2))
         enddo
      enddo

    end function zee_PoloidalEnergySpectrum_tee

!!$    function nz_PoloidalEnergySpectrum_wt(wt_POLPOT)
!!$      !
!!$      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
!!$      ! Ĵȡȿγʬ׻
!!$      !
!!$      !  * ȿ n, Ӿȿ m Υݥݥƥ󥷥Υڥȥʬ
!!$      !    (n,m,r)ȿ n ʬΥݥ륨ͥ륮ڥȥ
!!$      !
!!$      !      [m=-n]^n ((1/2)n(n+1)4r^2{[d(r(n,m,r))/dr]^2
!!$      !                 + n(n+1)(n,m,r)^2}
!!$      !
!!$      !    ȷ׻.
!!$      !
!!$      !  * ƤȿФƤΥͥ륮ڥȥʬ¤Zʬ
!!$      !    (r^2νŤ̵)Ǥͥ륮.
!!$      !
!!$      real(8), dimension(0:nm,-mm:mm,-lm:lm), intent(in) :: wt_POLPOT
!!$      !(in) ݥݥƥ󥷥
!!$
!!$      real(8), dimension(0:nm,0:km) :: nz_PoloidalEnergySpectrum_wt
!!$      !(out) ͥ륮ڥȥݥʬ
!!$
!!$      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA1   ! ΰ
!!$      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA2   ! ΰ
!!$      integer :: n, m
!!$
!!$      wz_Data1 = wz_wt(wt_POLPOT)
!!$      wz_Data2 = wz_Z*wz_wt(wt_DZ_wt(wt_POLPOT)) &    ! d(r)/dr
!!$               + wz_wt(wt_POLPOT)                         ! = rd/dr+
!!$
!!$      do n=0,nm
!!$         nz_PoloidalEnergySpectrum_wt(n,:) = &
!!$              + 0.5* n*(n+1)* (4*pi) &
!!$              *( sum(wz_Data2(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)  &
!!$                + n*(n+1)*sum(wz_Data1(l_nm(n,(/(m,m=-n,n)/)),:)**2,1) )
!!$      enddo
!!$
!!$    end function nz_PoloidalEnergySpectrum_wt
!!$
!!$
  !---------------  -----------------

    subroutine tee_BoundariesTau(tee,values,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! Chebyshev ֤ǤζŬ(ˡ)
      !
      ! ӥն֤ˤƶ٤⼡η
      ! ˡȤäƤ(ˡ).
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)      :: tee
              !(inout) ŬѤǡ. 줿֤ͤ.

      real(8), dimension(2,-mm:mm,-lm:lm), intent(in), optional :: values
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ.
              !     ά/ 0 Ȥʤ.

      character(len=2), intent(in), optional             :: cond
              !(in) . ά 'DD'
              !        DD : ξüǥꥯ
              !        DN : üǥꥯ, üΥޥ
              !        ND : üΥޥ, üǥꥯ
              !        NN : ξüΥޥ

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)         :: e2t

      real(8), dimension((2*lm+1)*(2*mm+1),2)            :: e22_values
      character(len=2)                                   :: Bcond

      e2t = e2a_aee(tee)

      if (present(values)) then
         e22_values = e2a_aee(values)
      endif

      if (.not. present(cond)) then
         Bcond='DD'
      else
         Bcond = cond
      endif

      select case(Bcond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesTau_NN(e2t,e22_values)
         else
            call at_BoundariesTau_NN(e2t)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesTau_DN(e2t,e22_values)
         else
            call at_BoundariesTau_DN(e2t)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesTau_ND(e2t,e22_values)
         else
            call at_BoundariesTau_ND(e2t)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesTau_DD(e2t,e22_values)
         else
            call at_BoundariesTau_DD(e2t)
         endif
      case default
         call MessageNotify('E','tee_BoundariesTau','B.C. not supported')
      end select

      tee = aee_e2a(e2t)

    end subroutine tee_BoundariesTau

    subroutine tee_BoundariesGrid(tee,values,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! ¶֤ǤζŬ
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ
      ! tee_Initial ˤꤹӥȿ(nm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)      :: tee
              !(inout) ŬѤǡ. 줿֤ͤ.

      real(8), dimension(2,-mm:mm,-lm:lm), intent(in), optional :: values
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ.
              !     ά/ 0 Ȥʤ.

      character(len=2), intent(in), optional             :: cond
              !(in) . ά 'DD'
              !        DD : ξüǥꥯ
              !        DN : üǥꥯ, üΥޥ
              !        ND : üΥޥ, üǥꥯ
              !        NN : ξüΥޥ

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)         :: e2t

      real(8), dimension((2*lm+1)*(2*mm+1),2)            :: e22_values
      character(len=2)                                   :: Bcond

      e2t = e2a_aee(tee)

      if (present(values)) then
         e22_values = e2a_aee(values)
      endif

      if (.not. present(cond)) then
         BCond = 'DD'
      else
         BCond = cond
      endif

      select case(Bcond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesGrid_NN(e2t,e22_values)
         else
            call at_BoundariesGrid_NN(e2t)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesGrid_DN(e2t,e22_values)
         else
            call at_BoundariesGrid_DN(e2t)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesGrid_ND(e2t,e22_values)
         else
            call at_BoundariesGrid_ND(e2t)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesGrid_DD(e2t,e22_values)
         else
            call at_BoundariesGrid_DD(e2t)
         endif
      case default
         call MessageNotify('E','tee_BoundariesGrid','B.C. not supported')
      end select

      tee = aee_e2a(e2t)

    end subroutine tee_BoundariesGrid

    subroutine tee_TorBoundariesTau(tee_TOR,cond,new)

      ! ȥ®٥ݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ȥݥƥ󥷥ζ
      !
      !      = 0 at boundaries           (Ǵ)
      !     ߦ/z = 0 at boundaries    (Ϥʤ)
      !
      ! Ǥ뤫 tee_Boundaries бǽ, ΤӺƤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_TOR
              !(inout) ŬѤǡ. 줿֤ͤ.

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      logical :: rigid1 = .true.
      logical :: rigid2 = .true.
      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: n
      save    :: alu, kp, first

      select case (cond)
      case ('RR')
        rigid1 = .TRUE.  ; rigid2 = .TRUE.
      case ('RF')
        rigid1 = .TRUE.  ; rigid2 = .FALSE.
      case ('FR')
        rigid1 = .FALSE. ; rigid2 = .TRUE.
      case ('FF')
        rigid1 = .FALSE. ; rigid2 = .FALSE.
      case default
        call MessageNotify('E','tee_TorBoundariesTau','B.C. not supported')
      end select

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:nm,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work= 0.0D0 ; e2t_work(:,n)= 1.0D0
            alu(:,:,n) = e2t_work

            ! Ǵ
            ! ϳŪǴ
            if ( rigid1 ) then
               e2z_work = az_at(e2t_work)
            else
               e2z_work = az_at(at_Dz_at(e2t_work))
            endif
            alu(:,nm-1,n) = e2z_work(:,0)

            ! ϳŪǴ
            if ( rigid2 ) then
               e2z_work = az_at(e2t_work)
            else
               e2z_work = az_at(at_Dz_at(e2t_work))
            endif
            alu(:,nm,n)   = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)
         call MessageNotify('M','tee_TorBoundariesTau',&
                            'Matrix to apply  b.c. newly produced.')
      endif

      e2t_work = e2a_aee(tee_Tor)

      e2t_work(:,nm-1) = 0.0D0
      e2t_work(:,nm)   = 0.0D0

      tee_Tor = aee_e2a(lusolve(alu,kp,e2t_work))

    end subroutine tee_TorBoundariesTau

    subroutine tee_TorBoundariesGrid(tee_TOR,cond,new)
      !
      ! ȥ®٥ݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ.
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ
      ! tee_Initial ˤꤹӥȿ(nm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      ! ȥ®٥ݥƥ󥷥ζ
      !
      !      = 0 at boundaries           (Ǵ)
      !     ߦ/z = 0 at boundaries    (Ϥʤ)
      !
      ! ǤΤ tee_Boundaries бǽ, ΤӺƤ
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_TOR
              !(inout) ŬѤǡ. 줿֤ͤ.

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      logical :: rigid1 = .true.
      logical :: rigid2 = .true.
      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: n
      save     :: alu, kp, first

      select case (cond)
      case ('RR')
        rigid1 = .TRUE.  ; rigid2 = .TRUE.
      case ('RF')
        rigid1 = .TRUE.  ; rigid2 = .FALSE.
      case ('FR')
        rigid1 = .FALSE. ; rigid2 = .TRUE.
      case ('FF')
        rigid1 = .FALSE. ; rigid2 = .FALSE.
      case default
        call MessageNotify('E','tee_TorBoundariesGrid','B.C. not supported')
      end select

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( nm /= km ) then
            call MessageNotify('E','tee_TorBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:km,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0
            e2z_work = az_at(e2t_work)

            alu(:,:,n) = e2z_work          ! ΰͤΤޤ.


            ! Ǵ
            ! ϳŪǴ
            if ( rigid1 ) then
               e2z_work = az_at(e2t_work)
            else
               e2z_work=az_at(at_Dz_at(e2t_work))
            endif
            alu(:,0,n) = e2z_work(:,0)

            ! ϳŪǴ
            if ( rigid2 ) then
               e2z_work = az_at(e2t_work)
            else
               e2z_work=az_at(at_Dz_at(e2t_work))
            endif
            alu(:,km,n)   = e2z_work(:,km)

         enddo
         call ludecomp(alu,kp)
         call MessageNotify('M','TorBoundariesGrid',&
                            'Matrix to apply  b.c. newly produced.')
      endif

      e2z_work = az_at(e2a_aee(tee_Tor))
      e2z_work(:,0)  = 0.0D0
      e2z_work(:,km) = 0.0D0
      tee_TOR = aee_e2a(lusolve(alu,kp,e2z_work))

    end subroutine tee_TorBoundariesGrid

    function tee_LaplaPol2PolTau_tee(tee,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      ! ӥն֤ǥˡˤ붭ŬѤƤ.
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !      ^2 = f
      !       = const. at boundaries.
      !      ߦ/z = 0 at boundaries          (Ǵ)
      !      or ^2/z^2 = 0 at boundaries   (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(in) :: tee
              !(in) Ϣ^2ʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)      :: tee_LaplaPol2PolTau_tee
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)  :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km)  :: e2z_work
      logical                                     :: rigid1 = .true.
      logical                                     :: rigid2 = .true.

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: n
      save    :: alu, kp, first

      if ( present(cond) ) then
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','tee_LaplaPol2PolTau_tee','B.C. not supported')
         end select
      else
         rigid1 = .TRUE.  ; rigid2 = .TRUE.
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:nm,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         alu = 0.0d0
         do n=0,nm-2
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,n) = e2a_aee(tee_lapla_tee(aee_e2a(e2t_work)))
         enddo

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            e2z_work = az_at(e2t_work)

            ! ưŪ. ή϶ǰ
            alu(:,nm,n)   = e2z_work(:,0)
            alu(:,nm-1,n) = e2z_work(:,km)

            ! ϳŪǴ
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            if ( rigid1 ) then
               e2z_work=az_at(at_Dz_at(e2t_work))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(e2t_work)))
            endif
            alu(:,nm-2,n) = e2z_work(:,0)

            ! ϳŪǴ
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            if ( rigid2 ) then
               e2z_work=az_at(at_Dz_at(e2t_work))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(e2t_work)))
            endif
            alu(:,nm-3,n) = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','tee_LaplaPol2PolTau_tee',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      e2t_work         = e2a_aee(tee)
      e2t_work(:,nm)   = 0.0D0               ! ưŪ
      e2t_work(:,nm-1) = 0.0D0               ! ưŪ
      e2t_work(:,nm-2) = 0.0D0               ! ϳŪ
      e2t_work(:,nm-3) = 0.0D0               ! ϳŪ

      tee_LaplaPol2PolTau_tee = aee_e2a(lusolve(alu,kp,e2t_work))

    end function tee_LaplaPol2PolTau_tee

    function zee_LaplaPol2Pol_zee(zee,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      !
      ! ӥճʻ֤ǶŬѤƤ.
      ! δؿѤ뤿ˤ wt_Initial ˤꤹ
      ! ӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !   ^2 = f
      !      = const. at boundaries.
      !     ߦ/z = 0 at boundaries           (Ǵ)
      !     or ^2/z^2 = 0 at boundaries    (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:km,-mm:mm,-lm:lm),intent(in)  :: zee
              !(in) Ϣ^2ʬ

      real(8), dimension(0:km,-mm:mm,-lm:lm)             :: zee_LaplaPol2Pol_zee
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:km)  :: e2z_work
      logical                                     :: rigid1 = .true.
      logical                                     :: rigid2 = .true.

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: k
      save    :: alu, kp, first

      select case (cond)
      case ('RR')
        rigid1 = .TRUE.  ; rigid2 = .TRUE.
      case ('RF')
        rigid1 = .TRUE.  ; rigid2 = .FALSE.
      case ('FR')
        rigid1 = .FALSE. ; rigid2 = .TRUE.
      case ('FF')
        rigid1 = .FALSE. ; rigid2 = .FALSE.
      case default
        call MessageNotify('E','zee_laplapol2pol_zee','B.C. not supported')
      end select

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( nm /= km ) then
            call MessageNotify('E','zee_LaplaPol2Pol_zee', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:km,0:km),kp((2*lm+1)*(2*mm+1),0:km))

         do k=0,km
            e2z_work = 0.0D0 ; e2z_work(:,k) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,k) &
                 = e2a_aee(zee_tee(tee_lapla_tee(tee_zee(aee_e2a(e2z_work)))))
         enddo

         do k=0,km
            e2z_work = 0.0D0 ; e2z_work(:,k) = 1.0D0

            ! ưŪ. ή϶ǰ
            alu(:,0,k)   = e2z_work(:,0)
            alu(:,km,k)  = e2z_work(:,km)

            ! ϳŪǴ
            e2z_work = 0.0D0 ; e2z_work(:,k) = 1.0D0
            if ( rigid1 ) then
               e2z_work=az_at(at_Dz_at(at_az(e2z_work)))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(at_az(e2z_work))))
            endif
            alu(:,1,k) = e2z_work(:,0)

            ! ϳŪǴ
            e2z_work = 0.0D0 ; e2z_work(:,k) = 1.0D0
            if ( rigid2 ) then
               e2z_work=az_at(at_Dz_at(at_az(e2z_work)))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(at_az(e2z_work))))
            endif
            alu(:,km-1,k) = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','zee_LaplaPol2Pol_zee',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      e2z_work        = e2a_aee(zee)
      e2z_work(:,1)    = 0.0D0               ! ϳŪ
      e2z_work(:,km-1) = 0.0D0               ! ϳŪ
      e2z_work(:,0)    = 0.0D0               ! ưŪ
      e2z_work(:,km)   = 0.0D0               ! ưŪ

      e2z_work = lusolve(alu,kp,e2z_work)

      zee_laplapol2pol_zee = aee_e2a(e2z_work)

    end function zee_LaplaPol2Pol_zee

    function tee_LaplaPol2PolGrid_tee(tee,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      ! ӥճʻ֤ǶŬѤƤ.
      !
      ! δؿѤ뤿ˤ tee_Initial ˤꤹ
      ! ӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !    ^2 = f
      !       = const. at boundaries.
      !      ߦ/z = 0 at boundaries          (Ǵ)
      !      or ^2/z^2 = 0 at boundaries   (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      ! ǽŪ˥ӥշβߤˤ, tee_LaplaPol2Pol_tee 
      ! ٤ƥӥ -- ʻѴ 1 ʬʤƺѤ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(in) :: tee
              !(in) Ϣ^2ʬ

      real(8), dimension(0:nm,-mm:mm,-lm:lm)      :: tee_LaplaPol2PolGrid_tee
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm)  :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km)  :: e2z_work
      logical                                     :: rigid1 = .true.
      logical                                     :: rigid2 = .true.

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: n
      save    :: alu, kp, first

      select case (cond)
      case ('RR')
        rigid1 = .TRUE.  ; rigid2 = .TRUE.
      case ('RF')
        rigid1 = .TRUE.  ; rigid2 = .FALSE.
      case ('FR')
        rigid1 = .FALSE. ; rigid2 = .TRUE.
      case ('FF')
        rigid1 = .FALSE. ; rigid2 = .FALSE.
      case default
        call MessageNotify('E','tee_LaplaPol2PolGrid_tee','B.C. not supported')
      end select

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( nm /= km ) then
            call MessageNotify('E','tee_LaplaPol2PolGrid_tee', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:km,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,n) = e2a_aee(zee_tee(tee_lapla_tee(aee_e2a(e2t_work))))
         enddo

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            e2z_work = az_at(e2t_work)

            ! ưŪ. ή϶ǰ
            alu(:,0,n)   = e2z_work(:,0)
            alu(:,km,n)  = e2z_work(:,km)

            ! ϳŪǴ
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            if ( rigid1 ) then
               e2z_work=az_at(at_Dz_at(e2t_work))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(e2t_work)))
            endif
            alu(:,1,n) = e2z_work(:,0)

            ! ϳŪǴ
            e2t_work = 0.0D0 ; e2t_work(:,n) = 1.0D0
            if ( rigid2 ) then
               e2z_work=az_at(at_Dz_at(e2t_work))
            else
               e2z_work=az_at(at_Dz_at(at_Dz_at(e2t_work)))
            endif
            alu(:,km-1,n) = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','tee_LaplaPol2PolGrid_tee',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      e2z_work         = az_at(e2a_aee(tee))
      e2z_work(:,1)    = 0.0D0               ! ϳŪ
      e2z_work(:,km-1) = 0.0D0               ! ϳŪ
      e2z_work(:,0)    = 0.0D0               ! ưŪ
      e2z_work(:,km)   = 0.0D0               ! ưŪ

      tee_LaplaPol2PolGrid_tee = aee_e2a(lusolve(alu,kp,e2z_work))

    end function tee_LaplaPol2PolGrid_tee

    subroutine tee_TormagBoundariesTau(tee_TOR,new)

      ! ȥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    tee_psi = 0   at the outer boundary
      ! ¦
      !    tee_psi = 0   at the inner boundary
      !
      ! Ǥ뤫 tee_Boundaries бǽ, ΤӺƤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_TOR
              !(inout) ŬѤǡ. 줿֤ͤ.

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: n
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:nm,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work= 0.0D0 ; e2t_work(:,n)= 1.0D0
            alu(:,:,n) = e2t_work

            ! ŵƳ
            e2z_work = az_at(e2t_work)
            alu(:,nm-1,n) = e2z_work(:,0)
            alu(:,nm,n)   = e2z_work(:,km)

         enddo

         call ludecomp(alu,kp)
         call MessageNotify('M','tee_TormagBoundariesTau',&
                            'Matrix to apply  b.c. newly produced.')
      endif

      e2t_work = e2a_aee(tee_Tor)

      e2t_work(:,nm-1) = 0.0D0
      e2t_work(:,nm)   = 0.0D0


      tee_Tor = aee_e2a(lusolve(alu,kp,e2t_work))

    end subroutine tee_TormagBoundariesTau

    subroutine tee_TormagBoundariesGrid(tee_TOR,new)
      !
      ! ȥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ.
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ
      ! tee_Initial ˤꤹӥȿ(nm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      ! ߤΤȤʪŵƳΤξΤбƤ.
      ! ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    tee_psi = 0   at the outer boundary
      ! ¦
      !    tee_psi = 0   at the inner boundary
      !
      ! ǤΤ tee_Boundaries бǽ, ΤӺƤ
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_TOR
              !(inout) ŬѤǡ. 줿֤ͤ.

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: n
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( nm /= km ) then
            call MessageNotify('E','tee_TorMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:km,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0
            e2z_work = az_at(e2t_work)

            alu(:,:,n) = e2z_work          ! ΰͤΤޤ.

            ! ŵƳ
            alu(:,0,n)  = e2z_work(:,0)
            alu(:,km,n) = e2z_work(:,km)

         enddo
         call ludecomp(alu,kp)
         call MessageNotify('M','TormagBoundariesGrid',&
                            'Matrix to apply  b.c. newly produced.')
      endif

      e2z_work = az_at(e2a_aee(tee_Tor))
      e2z_work(:,0)  = 0.0D0
      e2z_work(:,km) = 0.0D0
      tee_TOR = aee_e2a(lusolve(alu,kp,e2z_work))

    end subroutine tee_TormagBoundariesGrid

    subroutine tee_PolmagBoundariesTau(tee_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ݥݥƥ󥷥γƿʿڥȥ
      ! ʬ h ˤƶ郎Ϳ,
      !
      !  * ¦ : dh/dz + K h = 0
      !  * ¦ : dh/dz - K h = 0
      !
      ! Ǥ.  K=sqrt(l^2+m^2)  h οʿȿǤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_POL
              !(inout) ŬѤǡ. 줿֤ͤ.

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_kh

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l, m, n, e2index
      save    :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)

         allocate(alu((2*lm+1)*(2*mm+1),0:nm,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0

            alu(:,:,n) = e2t_work(:,:)    ! ΰƱ
         enddo

         ! ŵƳ
         do m=-mm,mm
            do l=-lm,lm
               e2index = (2*mm+1)*(l+lm) + (m+mm+1)
               e2t_kh(e2index,:) = sqrt(dble(l**2+m**2))
            enddo
         enddo
         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0

            e2z_work = az_at(at_Dz_at(e2t_work) + e2t_kh * e2t_work)
            alu(:,lm-1,n) = e2z_work(:,0)

            e2z_work = az_at(at_Dz_at(e2t_work) - e2t_kh * e2t_work)
            alu(:,lm,n)   = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','tee_PolmagBoundariesTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      e2t_work = e2a_aee(tee_POL)
      e2t_work(:,lm-1) = 0.0D0
      e2t_work(:,lm)   = 0.0D0
      tee_POL = aee_e2a(lusolve(alu,kp,e2t_work))

    end subroutine tee_PolmagBoundariesTau

    subroutine tee_PolmagBoundariesGrid(tee_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ.
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ
      ! tee_Initial ˤꤹӥȿ(nm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      ! ߤΤȤʪŵƳΤξΤбƤ.
      ! ξ, ݥݥƥ󥷥γƿʿڥȥʬ h 
      ! ƶ郎Ϳ,
      !
      !  * ¦ : dh/dz + K h = 0
      !  * ¦ : dh/dz - K h = 0
      !
      ! Ǥ.  K=sqrt(l^2+m^2)  h οʿȿǤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension(0:nm,-mm:mm,-lm:lm),intent(inout)   :: tee_POL
              !(inout) ŬѤǡ. 줿֤ͤ.

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_work
      real(8), dimension((2*lm+1)*(2*mm+1),0:km) :: e2z_work

      real(8), dimension((2*lm+1)*(2*mm+1),0:nm) :: e2t_kh

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, m, n, e2index
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( nm /= km ) then
            call MessageNotify('E','tee_PolMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) )  deallocate(kp)
         allocate(alu((2*lm+1)*(2*mm+1),0:km,0:nm),kp((2*lm+1)*(2*mm+1),0:nm))

         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0
            e2z_work = az_at(e2t_work)

            alu(:,:,n) = e2z_work    ! ΰƱ
         enddo

         ! ŵƳ
         do m=-mm,mm
            do l=-lm,lm
               e2index = (2*mm+1)*(l+lm) + (m+mm+1)
               e2t_kh(e2index,:) = sqrt(dble(l**2+m**2))
            enddo
         enddo
         do n=0,nm
            e2t_work = 0.0D0 ; e2t_work(:,n)=1.0D0

            e2z_work = az_at(at_Dz_at(e2t_work) + e2t_kh * e2t_work)
            alu(:,0,n) = e2z_work(:,0)

            e2z_work = az_at(at_Dz_at(e2t_work) - e2t_kh * e2t_work)
            alu(:,km,n)   = e2z_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','tee_PolmagBoundariesGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      e2z_work = az_at(e2a_aee(tee_POL))
      e2z_work(:,0)  = 0.0D0
      e2z_work(:,km) = 0.0D0
      tee_POL = aee_e2a(lusolve(alu,kp,e2z_work))

    end subroutine tee_PolmagBoundariesGrid

end module tee_module
