!--
!-------------------------------------------------------------------------
! Copyright (c) 2002--2013 SPMODEL Development Group. All rights reserved.  
!-------------------------------------------------------------------------
!ɽ  w_base_module
!
!  spml/w_base_module ⥸塼ϵ̾Ǥ 2 ήαưĴȡ
!  Ѥڥȥˡˤäƿͷ׻뤿Υ⥸塼 w_module
!  β⥸塼Ǥ, ڥȥ׻δŪ Fortran90 ؿ
!  .
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼Ƥ
!  . ڥȥǡӳʻǡγǼˡѴξܤ׻
!  ˡˤĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!== 
!
!      2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/03/13  ݹ  l_nm, nm_l ǰϤ褦˳ĥ
!      2005/07/04  ݹ  OpenMP Ѵ롼б
!                            Х󥯶򤱤뤿κɲ
!      2005/07/10  ݹ  OpenMP åȥåפΥå
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2007/11/21  ݹ  ֥롼å
!      2008/02/23  ʿ ʻǡ(im,jm)  (0:im-1, 0:jm-1)
!                             ѹ.
!      2008/06/25  ʿ ʻǡ(0:im-1,1:jm) ѹ
!      2008/07/04  ʿ Ȥ RDoc Ѥ
!      2008/12/28  ݹ   xy_w, w_xy ΥȤɲ
!      2009/01/09  ݹ   w_base_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!      2009/07/30  ݹ   ΰѿѹ(for OpenMP)
!      2010/03/26  ʿ ĤΥ롼פν֤줫
!      2013/02/11  ݹ  w_StreamPotential2Vector,  
!                            w_Vector2VorDiv Ƴ
!      2013/02/14  ݹ  w_VectorCosLat2VorDiv Ƴ
!      2013/02/23  ݹ  w_base_Finalize Ƴ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_base_module
  !
  != w_base_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_base_module.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== .
  !
  ! spml/w_base_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿
  ! ⥸塼 w_module β⥸塼Ǥ, ڥȥˡ
  ! Ū Fortran90 ؿ󶡤.
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼
  ! ƤǤ. ڥȥǡӳʻǡγǼˡ
  ! Ѵξܤ׻ˡˤĤƤ ISPACK/SNPACK,SPPACK Υޥ
  ! 奢򻲾Ȥ줿.
  !
  use dc_message
  implicit none

  integer               :: im=64            ! ʻ()
  integer               :: jm=32            ! ʻ()
  integer               :: nm=21            ! ȿ
  integer               :: np=1             ! OPENMP 祹åɿ

  logical               :: openmp=.false.   ! OPENMP å

  integer               :: it(6)            ! Ѵ
  real(8), allocatable  :: t(:)             ! Ѵ
  integer, allocatable  :: ip(:)            ! Ѵ
  real(8), allocatable  :: p(:), r(:)       ! Ѵ
  integer, allocatable  :: ia(:)            ! Ѵ
  real(8), allocatable  :: a(:)             ! Ѵ
  real(8), allocatable  :: y(:,:)           ! Ѵ

  real(8), allocatable  :: q(:)             ! 
  real(8), allocatable  :: ww(:), ws(:)     ! 
  real(8), allocatable  :: wv(:)            ! (OPENMP)

  real(8), allocatable  :: x_Lon(:), y_Lat(:)                ! ٷ
  real(8), allocatable  :: x_Lon_Weight(:), y_Lat_Weight(:)  ! ɸŤ
  real(8), allocatable  :: xy_Lon(:,:), xy_Lat(:,:)

  logical               :: w_base_initialize=.false.   ! եå

  integer               :: id=65, jd=33     ! xy_work 礭
  integer               :: iw               ! ww,ws 礭

  real(8), parameter    :: pi=3.1415926535897932385D0

  private

  public im, jm, nm                           ! ʻ, ȿ, Ⱦ
  public it, t, y, ip, p, r, ia, a            ! ѴѺ
  public openmp, np                           ! OPENMP ѿ

  public w_base_Initial                       ! ֥롼
  public w_base_Finalize                      ! λ֥롼

  public x_Lon, y_Lat                         ! ʻҺɸ
  public x_Lon_Weight, y_Lat_Weight           ! ʻҺɸŤ
  public xy_Lon, xy_Lat                       ! ʻҺɸ(im,jm)
  public l_nm, nm_l                           ! ȿǼ
  public xy_w, w_xy                           ! Ѵؿ
  public w_StreamPotential2Vector             ! ήݥƥ󥷥뤫®پ׻
  public w_Vector2VorDiv                      ! ®پ줫鱲ȯ׻
  public w_VectorCosLat2VorDiv                ! ®پ줫鱲ȯ׻

  interface l_nm
     module procedure l_nm_array00
     module procedure l_nm_array01
     module procedure l_nm_array10
     module procedure l_nm_array11
  end interface

  interface nm_l
     module procedure nm_l_int
     module procedure nm_l_array
  end interface

  save im, jm, nm, np                    ! ʻ, ȿ, openmp 򵭲
  save it, t, y, ip, p, r, ia, a         ! Ѵ򵭲
  save id, jd, iw                        ! Ѵ礭
  save w_base_initialize                 ! ե饰

  contains
  !---------------  -----------------
    subroutine w_base_Initial(n_in,i_in,j_in,np_in)
      !
      ! ڥȥѴγʻ, ȿ OPENMP ѻ
      ! 祹åɿꤹ.
      !
      ! ºݤλѤˤϾ̥֥롼 w_Initial Ѥ뤳.
      !
      integer,intent(in) :: i_in              !(in) ʻ()
      integer,intent(in) :: j_in              !(in) ʻ()
      integer,intent(in) :: n_in              !(in) ȿ
      integer,intent(in), optional :: np_in   !(in) OPENMP Ǥκ祹åɿ

      integer :: i, j

      im = i_in  ; jm = j_in  ; nm = n_in

      if ( present(np_in) )then
         np = np_in

         if ( np .gt. 1 ) then
            openmp = .true. 
            allocate(wv((nm+4)*(nm+3)*np))
            call MessageNotify('M','w_base_Initial', &
                 'OpenMP computation was set up.')
         else
            openmp = .false. 
         endif

      else
         openmp = .false. 
      endif

      if ( im/2*2 .eq. im ) then
         id = im+1 
      else
         id = im
      endif
      if ( openmp ) then
         jd = jm
      else if ( jm/2*2 .eq. jm ) then
         jd = jm+1
      else
         jd = jm
      endif
      allocate(t(im*2))                       ! Ѵ
      allocate(ip(((nm+1)/2+nm+1)*2))         ! Ѵ
      allocate(p(((nm+1)/2+nm+1)*jm))         ! Ѵ
      allocate(r(((nm+1)/2*2+3)*(nm/2+1)))    ! Ѵ
      allocate(ia((nm+1)*(nm+1)*4))           ! Ѵ
      allocate(a((nm+1)*(nm+1)*6))            ! Ѵ
      allocate(y(jm/2,4))                     ! Ѵ

      if ( openmp ) then
         iw=(im+nm+1)*3*jm/2
      else
         iw=max((nm+4)*(nm+3),jd*3*(nm+1),jd*im)
      endif

      allocate(x_Lon(0:im-1))                ! ʻɸǼ()
      allocate(x_Lon_Weight(0:im-1))
      allocate(xy_Lon(0:im-1,1:jm))
      allocate(y_Lat(1:jm))
      allocate(y_Lat_Weight(1:jm))             ! ʻɸǼ
      allocate(xy_Lat(0:im-1,1:jm))            ! ʻɸǼ

      call sninit(nm,im,jm,it,t,y,ip,p,r,ia,a)

      do i=0,im-1
         x_Lon(i)  = 2*pi/im*i               ! ٺɸ
         x_Lon_Weight(i) = 2*pi/im           ! ٺɸŤ
      enddo


      do j=1,jm/2
         y_Lat(jm/2+j)   =  asin(y(j,1))        ! ٺɸ
         y_Lat(jm/2-j+1) = -asin(y(j,1))        ! ٺɸ
         y_Lat_Weight(jm/2+j)   = 2*y(j,2)      ! ٽŤ(Gauss grid)
         y_Lat_Weight(jm/2-j+1) = 2*y(j,2)      ! ٽŤ(Gauss grid)
      enddo

      do j=1,jm
         xy_Lon(:,j) = x_Lon
      enddo

      do i=0,im-1
         xy_Lat(i,:) = y_Lat
      enddo

      w_base_initialize = .true.

      call MessageNotify('M','w_base_initial',&
           'w_base_module (2013/02/23) is initialized')

    end subroutine w_base_Initial

  !--------------- ܴؿ -----------------

    function l_nm_array00(n,m)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  n,m Ȥͤξ, ֤ͤ. 
      !
      integer               :: l_nm_array00   
      !(out) ڥȥǡγǼ 

      integer, intent(in)   :: n     !(in) ȿ
      integer, intent(in)   :: m     !(in) Ӿȿ           

      call snnm2l(n,m,l_nm_array00)
    end function l_nm_array00

    function l_nm_array01(n,marray)           ! ڥȥǡγǼ 
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  n ,  2  marray  1 ξ, 
      ! marray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: n               !(in) ȿ
      integer, intent(in)  :: marray(:)       !(in) Ӿȿ
      integer              :: l_nm_array01(size(marray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(marray)
         l_nm_array01(i) = l_nm_array00(n,marray(i))
      enddo
    end function l_nm_array01

    function l_nm_array10(narray,m)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  narray  1 ,  2   m ξ, 
      ! narray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: narray(:)           !(in) ȿ  
      integer, intent(in)  :: m                   !(in) Ӿȿ
      integer              :: l_nm_array10(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(narray)
         l_nm_array10(i) = l_nm_array00(narray(i),m)
      enddo
    end function l_nm_array10

    function l_nm_array11(narray,marray)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1,2  narray, marray Ȥ 1 ξ, 
      ! narray, marray Ʊ礭 1 ֤. 
      ! narray, marray Ʊ礭ǤʤФʤʤ. 
      !
      integer, intent(in)  :: narray(:)          !(in) ȿ  
      integer, intent(in)  :: marray(:)          !(in) Ӿȿ
      integer              :: l_nm_array11(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      if ( size(narray) .ne. size(marray) ) then
         call MessageNotify('E','l_nm_array11',&
              'dimensions of input arrays  n and m are different.')
      endif

      do i=1, size(narray)
         l_nm_array11(i) = l_nm_array00(narray(i),marray(i))
      enddo
    end function l_nm_array11

    function nm_l_int(l)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  l ͤξ, бȿӾȿ
      ! Ĺ 2  1 ֤ͤ. 
      ! nm_l(1) ȿ, nm_l(2) ӾȿǤ. 
      !
      integer               :: nm_l_int(2)  !(out) ȿ, Ӿȿ
      integer, intent(in)   :: l            !(in) ڥȥǡγǼ
      
      call snl2nm(l,nm_l_int(1),nm_l_int(2))
    end function nm_l_int

    function nm_l_array(larray)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  larray  1 ξ, 
      ! larray б n, m Ǽ 2 ֤. 
      ! nm_l_array(:,1) ȿ, nm_l_array(:,2) ӾȿǤ. 
      !
      integer, intent(in)  :: larray(:)
      !(out) ȿ, Ӿȿ

      integer              :: nm_l_array(size(larray),2)
      !(in) ڥȥǡγǼ

      integer              :: i

      do i=1, size(larray)
         nm_l_array(i,:) = nm_l_int(larray(i))
      enddo
    end function nm_l_array

  !--------------- Ѵ -----------------

    function xy_w(w_data,ipow,iflag)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: xy_w(0:im-1,1:jm)
      !(out) ʻǡ

      real(8), intent(in)   :: w_data((nm+1)*(nm+1))
      !(in) ڥȥǡ

      integer, intent(in), optional  :: ipow      
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ
      !    1 : ʬ cosա/ߦ ѤѴ
      !    2 : sinդѤѴ
      !    ά 0.
      !
      real(8) :: xy_work(id,jd)                   ! w_xy,xy_w Ѵ
      real(8) :: q(((nm+1)/2+nm+1)*jm)            ! 
      real(8) :: ws(iw),ww(iw)                    ! 

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval, i, j

      logical :: first=.true.                    ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','xy_w',&
              'w_base_module not initialize yet.')
      endif

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','xy_w', &
                 'OpenMP routine SNTSOG/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntsog(nm,im,id,jm,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call snts2g(nm,im,id,jm,jd,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      do j=1,jm
        do i=0,im-1
          xy_w(i,j) = xy_work(i+1,j)
        enddo
      enddo
      first = .false.

    end function xy_w

    function w_xy(xy_data,ipow,iflag)
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(1 ).
      !
      real(8)               :: w_xy((nm+1)*(nm+1))
      !(out) ڥȥǡ

      real(8), intent(in)   :: xy_data(0:im-1,1:jm)
      !(in) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !    0 : ̾Ѵ
      !   -1 : ʬѤѴ 
      !    1 : ʬ 1/cosա(f cos^2)/ߦ ѤѴ
      !    2 : sinդѤѴ
      !  ά 0.

      real(8) :: xy_work(id,jd)                   ! w_xy,xy_w Ѵ
      real(8) :: q(((nm+1)/2+nm+1)*jm)            ! 
      real(8) :: ws(iw),ww(iw)                    ! 

      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval, i, j

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_xy',&
              'w_base_module not initialize yet.')
      endif

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif
      
      do j=1,jm
        do i=0,im-1
          xy_work(i+1,j)=xy_data(i,j)
        enddo
      enddo

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','w_xy', &
                 'OpenMP routine SNTGOS/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntgos(nm,im,id,jm,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call sntg2s(nm,im,id,jm,jd,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      first = .false.

    end function w_xy

  !----------- ®, ١ȯ, ήݥƥ󥷥׻ -------------

    subroutine w_StreamPotential2Vector(w_Psi, w_Chi, xy_U, xy_V)
      !
      ! ήݥƥ󥷥(ڥȥǡ)®پ(ʻҥǡ)
      ! ()Ѵ(1 )
      !
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !   u cos =      ߦ/ߦ - cosբߦ/ߦ, 
      !   v cos = cosբߦ/ߦ +      ߦ/ߦ 
      !
      real(8), intent(in)   :: w_Psi((nm+1)*(nm+1))
      !(in) ήؿ
      real(8), intent(in)   :: w_Chi((nm+1)*(nm+1))
      !(in) ®٥ݥƥ󥷥

      real(8), intent(out)   :: xy_U(0:im-1,1:jm)
      !(out) ®ٷʬ
      real(8), intent(out)   :: xy_V(0:im-1,1:jm)
      !(out) ®ٰʬ

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_StreamPotential2Vector',&
              'w_base_module not initialize yet.')
      endif
      !
      !   u cos = ߦ/ߦ - cosբߦ/ߦ η׻
      !
      xy_U = xy_w(w_Chi,ipow=1,iflag=-1) - xy_w(w_Psi,ipow=1,iflag=1) 
      !
      !   v cos = cosբߦ/ߦ + ߦ/ߦ η׻
      !
      xy_V = xy_w(w_Chi,ipow=1,iflag=1) + xy_w(w_Psi,ipow=1,iflag=-1) 

    end subroutine w_StreamPotential2Vector

    subroutine w_Vector2VorDiv(xy_U, xy_V, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 )
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xy_U(0:im-1,1:jm)
      !(in) ®ٷʬ
      real(8), intent(in)   :: xy_V(0:im-1,1:jm)
      !(in) ®ٰʬ

      real(8), intent(out)   :: w_Vor((nm+1)*(nm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((nm+1)*(nm+1))
      !(out) ®٥ݥƥ󥷥

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_Vector2VorDiv',&
              'w_base_module not initialize yet.')
      endif

      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !
      w_Vor = w_xy(xy_V,ipow=1,iflag=-1) - w_xy(xy_U,ipow=1,iflag=1)
      !
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Div = w_xy(xy_U,ipow=1,iflag=-1) + w_xy(xy_V,ipow=1,iflag=1)

    end subroutine w_Vector2VorDiv

    subroutine w_VectorCosLat2VorDiv(xy_UCosLat, xy_VCosLat, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 )
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xy_UCosLat(0:im-1,1:jm)
      !(in) ®ٷʬ * cos(lat)
      real(8), intent(in)   :: xy_VCosLat(0:im-1,1:jm)
      !(in) ®ٰʬ * cos(lat)

      real(8), intent(out)   :: w_Vor((nm+1)*(nm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((nm+1)*(nm+1))
      !(out) ®٥ݥƥ󥷥

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_VectorCosLat2VorDiv',&
              'w_base_module not initialize yet.')
      endif

      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !
      w_Vor = w_xy(xy_VCosLat,ipow=2,iflag=-1) - w_xy(xy_UCosLat,ipow=2,iflag=1)
      !
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Div = w_xy(xy_UCosLat,ipow=2,iflag=-1) + w_xy(xy_VCosLat,ipow=2,iflag=1)

    end subroutine w_VectorCosLat2VorDiv

  !--------------- λ -----------------
    subroutine w_base_Finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! ºݤλѤˤϾ̥֥롼 w_Finalize Ѥ뤳.
      !
      if ( .not. w_base_initialize ) then
         call MessageNotify('W','w_base_Finalize',&
              'w_base_module not initialized yet')
         return
      endif

      if ( np .gt. 1 ) deallocate(wv)

      deallocate(t)         ! Ѵ
      deallocate(ip)        ! Ѵ
      deallocate(p)         ! Ѵ
      deallocate(r)         ! Ѵ
      deallocate(ia)        ! Ѵ
      deallocate(a)         ! Ѵ
      deallocate(y)         ! Ѵ

      deallocate(x_Lon)                ! ʻɸǼ()
      deallocate(x_Lon_weight)
      deallocate(xy_Lon)
      deallocate(y_Lat)
      deallocate(y_Lat_Weight)         ! ʻɸǼ
      deallocate(xy_Lat)               ! ʻɸǼ

      w_base_initialize = .false.

      call MessageNotify('M','w_base_Finalize',&
           'w_base_module (2013/02/23) is finalized')

    end subroutine w_base_Finalize

  end module w_base_module
