!----------------------------------------------------------------------
!     Copyright (c) 2008--2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_mpi_module
!
!  spml/w_deriv_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
!  ⥸塼 w_mpi_module β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2008/05/26  ݹ  w_deriv_module  MPI 
!      2013/02/23  ݹ  w_deriv_mpi_Finalize Ƴ
!
module w_deriv_mpi_module
  !
  ! w_deriv_mpi_module
  !
  !  spml/w_deriv_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
  !  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
  !  ⥸塼 w_mpi_module β⥸塼Ǥ, ڥȥˡ
  !  ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message, only : MessageNotify
  use w_base_module, only : im, jm, nm
  use w_base_mpi_module, only : it, t, y, ip, p, r, ia, a, &
                                jc, id, jd, xv_w, w_xv
  implicit none
  private im, jm, nm                          ! Intel Fortran к

  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  real(8), allocatable  :: q(:)               ! 
  real(8), allocatable  :: ww(:),ws(:),w(:)   ! 

  logical               :: w_deriv_initialize=.false.   ! եå

  private

  public w_deriv_mpi_Initial                  ! 
  public w_deriv_mpi_Finalize                 ! λ

  public xv_GradLon_w, xv_GradLat_w           ! ۷ʬ
  public w_DivLon_xv, w_DivLat_xv             ! ȯʬ
  public w_Div_xv_xv                          ! ȯʬ
  public w_JacobianMPI_w_w                    ! 䥳ӥ
  public xv_GradLambda_w, xv_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xv, w_DivMu_xv           ! ȯʬ(,̺ɸ)

  save ip2, ip3, p2, p3, r2, r3
  save w_deriv_initialize                     ! ե饰

  contains

  !---------------  -----------------
    subroutine w_deriv_mpi_initial
      !
      ! ڥȥѴγʻ, ȿꤹ.
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
      ! ʤФʤʤ. 
      !
      integer iw

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jc,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jc,3,ip,p,r,ip3,p3,r3)

      allocate(q(3*((nm+1)/2+nm+1)*jm))       ! 
      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*jm )
      allocate(ws(iw),ww(iw),w((nm+1)*(nm+1)))   ! 

      w_deriv_initialize=.true.

      call MessageNotify('M','w_deriv_mpi_initial', &
           'w_deriv_mpi_module (2013/02/23) is initialized')

    end subroutine w_deriv_mpi_initial

  !--------------- ʬ׻ -----------------
    function xv_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xv_GradLon_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradLon_w = xv_w(w_data,ipow=1,iflag=-1)
    end function xv_GradLon_w

    function xv_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xv_GradLat_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradLat_w = xv_w(w_data,ipow=1,iflag=1)
    end function xv_GradLat_w

    function w_DivLon_xv(xv_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ
      
      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLon_xv = w_xv(xv_data,ipow=1,iflag=-1)
    end function w_DivLon_xv

    function w_DivLat_xv(xv_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLat_xv = w_xv(xv_data,ipow=1,iflag=1)
    end function w_DivLat_xv

    function w_Div_xv_xv(xv_u,xv_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xv_xv((nm+1)*(nm+1))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xv_u(0:im-1,jc)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xv_v(0:im-1,jc)
      !(in) ٥ȥʬγʻǡ

      w_Div_xv_xv = w_Divlon_xv(xv_u) + w_Divlat_xv(xv_v)
    end function w_Div_xv_xv

    function w_JacobianMPI_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_JacobianMPI_w_w((nm+1)*(nm+1))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      call spmjcb(nm,im,id,jc,jd,w_a,w_b,w_JacobianMPI_w_w,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww,w)
    end function w_JacobianMPI_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xv_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xv_GradLambda_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ
      
      xv_GradLambda_w = xv_w(w_data,ipow=0,iflag=-1)
    end function xv_GradLambda_w

    function xv_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xv_GradMu_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradMu_w = xv_w(w_data,ipow=0,iflag=1)
    end function xv_GradMu_w

    function w_DivLambda_xv(xv_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLambda_xv = w_xv(xv_data,ipow=2,iflag=-1)
    end function w_DivLambda_xv

    function w_DivMu_xv(xv_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivMu_xv = w_xv(xv_data,ipow=2,iflag=1)
    end function w_DivMu_xv

  !--------------- λ -----------------
    subroutine w_deriv_mpi_finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_mpi_Finalize Ѥ뤳.
      !
      if ( .not. w_deriv_initialize ) then
         call MessageNotify('W','w_deriv_mpi_Finalize',&
              'w_deriv_mpi_module not initialized yet')
         return
      endif

      deallocate(ip2)      ! 䥳ӥ׻
      deallocate(p2)       ! 䥳ӥ׻
      deallocate(r2)       ! 䥳ӥ׻
      deallocate(ip3)      ! 䥳ӥ׻
      deallocate(p3)       ! 䥳ӥ׻
      deallocate(r3)       ! 䥳ӥ׻

      deallocate(q)        ! 
      deallocate(ws,ww,w)  ! 

      w_deriv_initialize = .false.

      call MessageNotify('M','w_deriv_mpi_Finalize',&
           'w_deriv_mpi_module (2013/02/23) is finalized')

    end subroutine w_deriv_mpi_finalize

end module w_deriv_mpi_module
