!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module_fftj ƥȥץ (ή䥳ӥ׻)
!
!  2011/12/10  ݹ
!
program eea_module_fftj_jacobianZ_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module_fftj
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: yxa_JacobZ(0:jm-1,0:im-1,2)  ! ʻҥǡ

  integer            :: k1=3,l1=1
  integer            :: k2=2,l2=4

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','eea_module_fftj_jacobianZ_test', &
       'eea_module_fftj jacobianZ function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yxa_Data(:,:,1) = sin(k1*pi*yx_X) + cos(l1*pi*yx_Y)
  yxa_Data(:,:,2) = sin(k2*pi*yx_X) + cos(l2*pi*yx_Y)
  yxa_JacobZ(:,:,1) = (dble(k1)/l1-dble(l1)/k1)*cos(k1*pi*yx_X)*sin(l1*pi*yx_Y)
  yxa_JacobZ(:,:,2) = (dble(k2)/l2-dble(l2)/k2)*cos(k2*pi*yx_X)*sin(l2*pi*yx_Y)

  call AssertEqual(                                 &
    message = 'JacobZ(sin(k*pi*X)+cos(l*pi*Y))',    &
    answer = yxa_JacobZ,                            &
    check = yxa_eea(eea_JacobianZ_eea(eea_yxa(yxa_Data))), &
    significant_digits = check_digits, ignore_digits = ignore     )

  call MessageNotify('M','eea_module_fftj_jacobianZ_test', &
       'eea_module_fftj jacobianZ function tests succeeded!')

end program eea_module_fftj_jacobianZ_test
