!----------------------------------------------------------------------
!     Copyright (c) 2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  la_module ƥȥץ :: ѴؿΥƥ
!
!  2009/09/22  ݹ
!
program la_module_base_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use la_module
  implicit none

  integer :: jm(2)=(/16,32/)
  integer :: nm(2)=(/10,21/)
  integer :: km(2)=(/3,3/)

  real(8), allocatable ::  ya_data(:,:)
  real(8), allocatable ::  la_data(:,:)

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  integer :: n

  call MessageNotify('M','la_module_base_test', &
                         'la_module basic functions tests') 

  do n=1,2

  call la_Initial( nm(n), jm(n) )

  allocate(la_data(0:nm(n),km(n)))
  allocate(ya_data(1:jm(n),km(n)))

  !---- P_* Υƥ ----
  la_data= 0.0D0 
  ya_data(:,1) = sqrt(3.0D0)*sin(y_Lat)                   ! P_1
  la_data(1,1)=1.0D0
  ya_data(:,2) = sqrt(5.0D0)*(3.0/2*sin(y_Lat)**2-1/2.0)  ! P_2
  la_data(2,2)=1.0D0
  ya_data(:,3) = sqrt(7.0D0)*(5.0/2*sin(y_Lat)**3-3/2.0*sin(y_Lat))  ! P_3
  la_data(3,3)=1.0D0

  call AssertEqual(&
    message='P_* Test of la_ya(ya_data)',                         &
    answer = la_data,                                             &
    check = la_ya(ya_data),                                       &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='P_* Test of ya_la(la_ya(ya_data))',                  &
    answer = ya_data,                                             &
    check = ya_la(la_ya(ya_data)),                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪؿΥƥ ----
  ya_data(:,1) = (sin(y_Lat)-1)**2*(sin(y_Lat)-0.5)*(sin(y_Lat)+1)
  ya_data(:,2) = (sin(y_Lat)-1)**2*(sin(y_Lat)+1)**2
  ya_data(:,3) = (sin(y_Lat)-1)*(sin(y_Lat)-0.5)**2*(sin(y_Lat)+1)

  call AssertEqual(&
    message='general function Test of ya_la(la_ya(ya_data))',     &
    answer = ya_data,                                             &
    check = ya_la(la_ya(ya_data)),                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  deallocate(la_data)
  deallocate(ya_data)

  call la_Finalize

  enddo

  call MessageNotify('M','la_module_base_test', &
                         'la_module basic functions tests succeeded!') 

end program la_module_base_test
